/* StandaloneAppletWindow.java -- an applet frame
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;


class StandaloneAppletWindow extends Frame
{
  private static int testWindowCount;
  private static HashMap contexts = new HashMap();
  Applet applet;
  Label status = new Label();

  StandaloneAppletWindow(AppletTag tag, List appletWindows)
  {
    appletWindows.add(this);
    applet = AppletViewer.createApplet(tag);

    if (contexts.get(tag.codebase) == null)
      contexts.put(tag.codebase, new StandaloneAppletContext(appletWindows));

    setLayout(new BorderLayout());
    add(applet, BorderLayout.CENTER);
    add(status, BorderLayout.SOUTH);

    addWindowListener(new WindowAdapter()
        {
	  public void windowClosing(WindowEvent event)
	  {
	    applet.stop();
	    StandaloneAppletWindow.this.hide();
	    System.exit(0);
	  }
        });

    MenuItem restartItem = new MenuItem("Restart");
    MenuItem reloadItem = new MenuItem("Reload");
    MenuItem cancelItem = new MenuItem("Cancel");
    MenuItem saveItem = new MenuItem("Save...");
    MenuItem startItem = new MenuItem("Start");
    MenuItem cloneItem = new MenuItem("Clone...");
    MenuItem closeItem = new MenuItem("Close");

    MenuItem quitItem = new MenuItem("Quit");
    quitItem.addActionListener(new ActionListener()
        {
	  public void actionPerformed(ActionEvent e)
	  {
	    System.out.println("Quit Hit");
	  }
        });

    MenuBar menuBar = new MenuBar();
    Menu menuFile = new Menu("Applet");
    menuBar.add(menuFile);
    menuFile.add(restartItem);
    menuFile.add(reloadItem);
    menuFile.add(cancelItem);
    menuFile.add(saveItem);
    menuFile.add(startItem);
    menuFile.add(cloneItem);
    menuFile.add(closeItem);
    menuFile.add(quitItem);
    setMenuBar(menuBar);

    AppletContext context = (AppletContext) contexts.get(tag.codebase);
    ((StandaloneAppletContext) context).addApplet(applet);

    applet.setStub(new CommonAppletStub(tag, context));

    setTitle("GCJ Applet Viewer: " + tag.code);

    String testWindowCount = System.getProperty("gnu.gcjwebplugin.test.windowCount");

    if (testWindowCount == null)
      {
	// Create the frame's peer.  Otherwise getPreferredSize will read
	// its insets as 0.
	addNotify();
	setSize(getPreferredSize());

	setVisible(true);

	applet.init();
	applet.validate();
	applet.start();
      }
    else
      {
	applet.init();
	applet.start();

	if (++this.testWindowCount == Integer.decode(testWindowCount)
	                                       .intValue())
	  System.exit(0);
      }
  }

  void showStatus(String status)
  {
    this.status.setText(status);
  }
}
