/* AppletSecurityManager.java --
   Copyright (C) 2004  Michael Koch <konqueror@gmx.de>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.PropertyPermission;


class AppletSecurityManager extends SecurityManager
{
  AppletSecurityManager()
  {
    // Do nothing here.
  }

  public void checkPermission(Permission permission)
  {
    if (permission == null)
      throw new NullPointerException();

    // FIXME: we need to restrict this.
    //
    // libgcj asks for "java.io.FilePermission <<ALL FILES>> execute"
    // to be able to execute "addr2line" to get proper stack traces.
    if (permission instanceof FilePermission)
      return;
    
    // FIXME: we need to restrict this.
    if (permission instanceof SecurityPermission)
      return;
    
    // FIXME: is this really needed ?
    if (permission instanceof PropertyPermission)
      return;
    
    // Needed to allow to access AWT event queue.
    if (permission.getName().equals("accessEventQueue"))
      return;
    
    // Needed to create a class loader for each codebase.
    if (permission.getName().equals("createClassLoader"))
      return;

    // FIXME: we need to allow access to codebase here.

    if (permission instanceof SocketPermission      // for net access
	|| permission instanceof RuntimePermission) // for checkWrite(FileDescriptor)
      return;
    
    // Reject all other permissions.
    throw new SecurityException();
  }
}
