/* natAppletViewer.cc - implement getenv.
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <gcj/cni.h>

#include "AppletViewer.h"

// FIXME: This function does no encoding conversions, or error
// checking.  It is probably totally wrong.  This function is just an
// ugly hack to get around the annoying fact that Sun and, by
// extension, libgcj, no longer supports reading environment
// variables.
jstring
gnu::gcjwebplugin::AppletViewer::getenv (jstring name)
{
  int namelen = JvGetStringUTFLength (name);
  char* buf = (char *) malloc (namelen * sizeof (char));

  JvGetStringUTFRegion (name, 0, namelen, buf);
  buf[namelen] = '\0';

  char* value = ::getenv (buf);

  return value ? JvNewStringUTF (value) : 0;
}
