import java.applet.*;
import java.io.*;
import java.util.*;

public class TestAppletCodebaseTwo extends Applet
{
  public String getName ()
  {
    return "applet 1 in codebase 2";
  }

  public void init () throws java.io.IOException
  {
    System.out.println ("TestAppletCodebaseTwo.init");

    // Assume the other two applets have loaded by now.  That is,
    // applets named 1 and 2 should appear before 3 in the html file.
    // The context that we retrieve here should be a different context
    // than the context we populated in TestAppletCodebaseOne1 and
    // TestAppletCodebaseOne2.
    AppletContext ac = getAppletContext ();

    if (ac == null)
      {
	System.err.println ("error: applet context of " + getName () + " is null");
	return;
      }

    // Test that setStream works.
    ac.setStream (getName () + " stream 1", new PipedInputStream ());
    ac.setStream (getName () + " stream 2", new PipedInputStream ());
    ac.setStream (getName () + " stream 3", new PipedInputStream ());
    ac.setStream (getName () + " stream 4", new PipedInputStream ());
    ac.setStream (getName () + " stream 5", new PipedInputStream ());
    ac.setStream (getName () + " stream 6", new PipedInputStream ());
    ac.setStream (getName () + " stream 7", new PipedInputStream ());
    ac.setStream (getName () + " stream 8", new PipedInputStream ());

    // Test that getApplet doesn't return an applet in the other codebase.
    Applet a1 = ac.getApplet ("applet 1 in codebase 1");

    if (a1 != null)
      System.out.println ("called AppletContext.getApplet, got: " + a1.getName ());

    // Test that getApplets does not return the applets in the other codebase.
    Enumeration e = ac.getApplets ();
    while (e.hasMoreElements ())
      System.out.println ("called AppletContext.getApplets, got: " + ((Applet) e.nextElement ()).getName ());

    // Test that getStream can't return a stream from the other codebase.
    InputStream is = ac.getStream ("applet 1 in codebase 1 stream 3");
    if (is != null)
      System.out.println ("called AppletContext.getStream, got: applet 1 in codebase 1 stream 3");

    is = ac.getStream ("applet 2 in codebase 1 stream 5");
    if (is != null)
      System.out.println ("called AppletContext.getStream, got: applet 2 in codebase 1 stream 5");

    // Test that getStreamKeys works.
    Iterator i = ac.getStreamKeys ();

    while (i.hasNext ())
      System.out.println ("called AppletContext.getStreamKeys, got: " + (String) i.next ());
  }

  public void start ()
  {
    System.out.println ("TestAppletCodebaseTwo.start");
  }
}
