/* PluginAppletWindow.java -- an embeddable applet window
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.java.awt.EmbeddedWindow;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

class PluginAppletWindow extends EmbeddedWindow
{
  private static HashMap contexts = new HashMap ();

  Applet applet;
  AppletTag tag;
  private boolean isActive = false;

  PluginAppletWindow ()
  {
    super ();
  }

  void setTag (String tag, String documentbase)
    throws MalformedURLException, IOException
  {
    StringReader reader = new StringReader (tag);
    URL documentbaseURL = AppletTag.locationToURL (documentbase);
    this.tag = AppletTag.parseNextTag (new StreamTokenizer (reader),
				       documentbaseURL);
  }

  ///////////////////////////////////
  ////// EmbeddedWindow Method //////
  ///////////////////////////////////

  public void setHandle (long handle)
  {
    super.setHandle (handle);

    addNotify();

    setLayout (new BorderLayout());

    applet = AppletViewer.createApplet (tag);

    if (contexts.get (tag.codebase) == null)
      contexts.put (tag.codebase, new PluginAppletContext ());

    isActive = true;

    add (applet, BorderLayout.CENTER);

    setVisible (true);

    AppletContext context = (AppletContext) contexts.get (tag.codebase);
    ((PluginAppletContext) context).addApplet (applet);
    applet.setStub (new AppletStub (tag, context));
    applet.init ();
    applet.setVisible (true);
    applet.validate ();
    applet.start ();
  }

  /////////////////////////////
  ////// Component Method /////
  /////////////////////////////

  public void doLayout ()
  {
    super.doLayout();

    // Assume the applet to be our only child and give it all the
    // space we have.
    Component c = this.getComponent(0);
    if (c != null)
      {
	Dimension cs = null;

	if (tag != null)
	  cs = tag.dimensions;

	if (cs == null)
	  cs = getSize();

	c.setBounds(0, 0, cs.width, cs.height);
      }
  }
}
