/* AppletViewer.java -- a standalone viewer for Java applets
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.applet.Applet;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

class AppletViewer
{
  static native String getenv (String name);

  static Applet createApplet (AppletTag tag)
  {
    Applet applet = null;
    try
      {
        URLClassLoader loader;

	// FIXME: why does URLClassLoader throw a NoClassDefFoundError
	// when the html file we pass it is in the current working
	// directory?  (e.g. the Slime Volleyball applet).  I suspect
	// a URLClassLoader bug in libgcj.
	if (tag.archives.size() == 0)
	  loader = new URLClassLoader
	    (new URL [] { tag.prependCodebase ("") });
	else
	  loader = new URLClassLoader
	    ((URL []) tag.archives.toArray (new URL [tag.archives.size()]));

	String code = tag.code;

	if (code.endsWith( ".class"))
	  code = code.substring(0, code.length() - 6);

	Class c = loader.loadClass(code);
	applet = (Applet) c.newInstance();
      }
    catch (Exception e)
      {
	e.printStackTrace ();
      }
    return applet;
  }

  static void printHelpMessage (int status)
  {
    System.out.println ("Usage: gcjappletviewer [options] <filename>.class | <filename>.html... | url...");
    System.out.println ("Options:");
    System.out.println ("  --help                            Display this message");
    System.out.println ("  --code=<classname>[.class]        Run applet by class name or file name");
    System.out.println ("  --codebase=<directory>            Set applet codebase");
    System.out.println ("  --archive=<filename>.jar[,...]    Add archives to applet class loader");
    System.out.println ("  --param=<name>,<value>            Pass parameter to applet");
    System.out.println ("  --width=<width>                   Set width of applet viewer frame");
    System.out.println ("  --height=<height>                 Set height of applet viewer frame");
    System.out.println ("  --plugin                          Enable plugin mode");
    System.exit (status);
  }

  public static void main (String[] args)
    throws IOException
  {
    if (args.length == 0)
      {
	System.out.println ("gcjappletviewer: no input files");
	printHelpMessage (1);
      }

    LongOpt[] longOptions = new LongOpt[]
      {
	new LongOpt ("code",     LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("codebase", LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("archive",  LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("param",    LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("width",    LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("height",   LongOpt.REQUIRED_ARGUMENT, null, 0),
	new LongOpt ("plugin",   LongOpt.NO_ARGUMENT,       null, 0),
	new LongOpt ("help",     LongOpt.NO_ARGUMENT,       null, 0),
      };

    Getopt opts = new Getopt("gcjappletviewer", args, "", longOptions);

    int optionValue;
    int optionIndex;

    String code = "";
    String codebase = "";
    String archives = "";
    List parameters = new ArrayList ();
    Dimension dimensions = new Dimension (-1, -1);

    boolean codeGiven = false;
    boolean widthGiven = false;
    boolean heightGiven = false;
    boolean pluginMode = false;

    // This loop parses the command line, placing all option arguments
    // at the start of args, all non-options at the end, and setting
    // optind to the index of the first non-option argument.
    while ((optionValue = opts.getopt()) != -1)
      {
	if (optionValue == 0)
	  {
	    optionIndex = opts.getLongind();
	    
	    if (optionIndex == 0) // --code
	      {
		codeGiven = true;
		code = opts.getOptarg();
	      }
	    if (optionIndex == 1) // --codebase
	      codebase = opts.getOptarg();
	    if (optionIndex == 2) // --archive
	      archives = opts.getOptarg();
	    else if (optionIndex == 3) // --param
	      parameters.add (opts.getOptarg());
	    else if (optionIndex == 4) // --width
	      {
		widthGiven = true;
		dimensions.width =
		  Math.max (1, Integer.parseInt(opts.getOptarg()));
	      }
	    else if (optionIndex == 5) // --height
	      {
		heightGiven = true;
		dimensions.height =
		  Math.max (1, Integer.parseInt(opts.getOptarg()));
	      }
	    else if (optionIndex == 6) // --plugin
	      {
		pluginMode = true;
		break;
	      }
	    else if (optionIndex == 7) // --help
	      printHelpMessage (0);
	  }
      }

    if (dimensions.height < 0)
      dimensions.height = 200;

    if (dimensions.width < 0)
      dimensions.width = (int) (1.6 * dimensions.height);

    System.err.println (dimensions);

    if (pluginMode)
      PluginAppletViewer.start (System.in, System.out);
    else
      new StandaloneAppletViewer (code, codebase,
				  archives, parameters,
				  dimensions,
				  widthGiven, heightGiven,
				  codeGiven,
				  args, opts, opts.getOptind ());
  }
}
