/* PluginAppletViewer.java - manages embeddable applet windows
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.java.awt.EmbeddedWindow;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Enumeration;
import java.util.Iterator;

/**
 * PluginAppletViewer communicates through pipes with a web browser
 * plugin.  A PluginAppletViewer manages applet windows that may be
 * embedded into web pages.
 */
class PluginAppletViewer
{
  // A mapping of instance IDs to PluginAppletWindows.
  static HashMap appletWindows = new HashMap ();

  private static BufferedReader stdin;
  private static BufferedWriter stdout;

  static void start (InputStream inputStream, OutputStream outputStream)
    throws MalformedURLException, IOException
  {
    // Set up input and output pipes.
    stdin = new BufferedReader (new InputStreamReader (inputStream));
    stdout = new BufferedWriter (new OutputStreamWriter (outputStream));

    write ("running");

    String input = read ();
    PluginAppletWindow currentWindow = null;

    while (true)
      {
	if (input.equals ("instance"))
	  {
	    // Read applet instance identifier.
	    String key = read ();

	    if (appletWindows.get (key) == null)
	      appletWindows.put (key, new PluginAppletWindow ());

	    currentWindow = (PluginAppletWindow) appletWindows.get (key);
	  }
	else if (input.equals ("tag"))
	  {
	    String documentbase = read ();
	    String tag = read ();

	    currentWindow.setTag (tag, documentbase);
	  }
	else if (input.equals ("xid"))
	  {
	    long handle = Long.parseLong (read ());

	    currentWindow.setHandle (handle);
	  }
	else if (input.equals ("width"))
	  {
	    int width = Integer.parseInt (read ());

	    currentWindow.setSize (width, currentWindow.getHeight ());
	  }
	else if (input.equals ("height"))
	  {
	    int height = Integer.parseInt (read ());

	    currentWindow.setSize (currentWindow.getWidth (), height);
	  }
	else if (input.equals ("destroy"))
	  {
	    appletWindows.remove (currentWindow);
	    currentWindow.dispose ();
	  }
	input = read ();
      }
  }

  static void write (String output)
    throws IOException
  {
    // Write string to plugin.
    stdout.write (output, 0, output.length());
    stdout.newLine ();
    stdout.flush ();

    System.err.println ("  PIPE: appletviewer wrote: " + output);
  }

  static String read ()
    throws IOException
  {
    // Read string from plugin.
    String input = stdin.readLine();

    System.err.println ("  PIPE: appletviewer read: " + input);

    if (input.equals ("shutdown"))
      {
	stdin.close ();
	stdout.close ();
	System.exit (0);
      }

    // Return confirmation string to plugin.
    write (input);

    return input;
  }
}
