/* gcjwebplugin - Webbrowser plugin to execute Java (tm) applets.
   Copyright (C) 2003  Michael Koch <konqueror@gmx.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307  USA

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


#include <npapi.h>
#include <npupp.h>

#include <jni.h>

#include "jniHelp.h"
#include "config.h"

#define PLUGIN_NAME "GCJ web browser plugin " PACKAGE_VERSION
#define PLUGIN_DESC "GCJ web browser plugin executes Java applets in Mozilla and other web browsers"
#define PLUGIN_MIME_TYPE "application/x-java-applet"
#define PLUGIN_MIME_DESC "application/x-java-applet::Java(tm) Plug-in"

#define PLUGIN_DEBUG(arg) ;

struct GCJPluginData
{
  JNIEnv* jniEnv;
  
  jclass embeddedWindow_class;
  jclass applet_class;

  jobject embeddedWindow;
  jobject applet;
};

char*
NPP_GetMIMEDescription()
{
  PLUGIN_DEBUG ("NPP_GetMimeDexcription\n");

  return PLUGIN_MIME_DESC;
}

NPError
NPP_GetValue (NPP instance, NPPVariable variable, void* value)
{
  PLUGIN_DEBUG ("NPP_GetValue\n");

  NPError result = NPERR_NO_ERROR;

  switch (variable)
    {
    case NPPVpluginNameString: // plugin name
    case NPPVpluginDescriptionString: // plugin description
      *((char**) value) = "GCJ web browser plugin " VERSION;
      break;

    default:
      result = NPERR_GENERIC_ERROR;
      break;
    }

  return result;
}

NPError
NPP_Initialize()
{
  PLUGIN_DEBUG ("NPP_Initialize\n");

  return NPERR_NO_ERROR;
}

void
NPP_Shutdown()
{
  PLUGIN_DEBUG ("NPP_Shutdown\n");
}

NPError
NPP_New (NPMIMEType pluginType, NPP instance, uint16 mode, int16 argc, char* argn[], char* argv[], NPSavedData* saved)
{
  PLUGIN_DEBUG ("NPP_New\n");

  if (!instance)
    return NPERR_INVALID_INSTANCE_ERROR;

  GCJPluginData* data =
    (GCJPluginData*) NPN_MemAlloc (sizeof (struct GCJPluginData));

  if (!data)
    return NPERR_OUT_OF_MEMORY_ERROR;

  data->jniEnv = NULL;
  data->applet_class = NULL;
  data->embeddedWindow = NULL;
  data->applet = NULL;

  JNI_FindClass (data->jniEnv, "gnu/java/awt/EmbeddedWindow",
		 data->embeddedWindow_class);

  instance->pdata = data;
  
  return NPERR_GENERIC_ERROR;
}

NPError
NPP_Destroy (NPP instance, NPSavedData** save)
{
  PLUGIN_DEBUG ("NPP_Destroy\n");

  // FIXME: Do we need to free the memory for NPP->pdata here ?

  return NPERR_GENERIC_ERROR;
}

NPError
NPP_SetWindow (NPP instance, NPWindow* window)
{
  PLUGIN_DEBUG ("NPP_SetWindow\n");

  jmethodID embeddedWindow_init;
  GCJPluginData* data = (GCJPluginData*) instance->pdata;
  
  JNI_GetMethodID (data->jniEnv, data->embeddedWindow_class, "<init>", "(I)V",
		   embeddedWindow_init);
  JNI_NewObject1 (data->jniEnv, data->embeddedWindow_class, embeddedWindow_init,
		  (jint) window->window, data->embeddedWindow);
  
  return NPERR_NO_ERROR;
}

NPError
NPP_NewStream (NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16* stype)
{
  PLUGIN_DEBUG ("NPP_NewStream\n");

  return NPERR_GENERIC_ERROR;
}

NPError
NPP_DestroyStream (NPP instance, NPStream* stream, NPReason reason)
{
  PLUGIN_DEBUG ("NPP_DestroyStream\n");

  return NPERR_GENERIC_ERROR;
}

int32
NPP_WriteReady (NPP instance, NPStream* stream)
{
  PLUGIN_DEBUG ("NPP_WriteReady\n");

  return 0;
}

int32
NPP_Write (NPP instance, NPStream* stream, int32 offset, int32 len, void* buffer)
{
  PLUGIN_DEBUG ("NPP_Write\n");

  return 0;
}

void
NPP_StreamAsFile (NPP instance, NPStream* stream, const char* filename)
{
  PLUGIN_DEBUG ("NPP_StreamAsFile\n");
}

void
NPP_Print (NPP instance, NPPrint* platformPrint)
{
  PLUGIN_DEBUG ("NPP_Print\n");
}

int16
NPP_HandleEvent (NPP instance, void* event)
{
  PLUGIN_DEBUG ("NPP_HandleEvent\n");

  return 0;
}

void
NPP_URLNotify (NPP instance, const char* url, NPReason reason, void* notifyData)
{
  PLUGIN_DEBUG ("NPP_URLNotify\n");
}

jref
NPP_GetJavaClass ()
{
  PLUGIN_DEBUG ("NPP_GetJavaClass\n");

  return 0;
}
