/*
                GNU GO - the game of Go (Wei-Chi)
                Version 1.1   last revised 3-1-89
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
                    documented by Bob Webber
                    NeXT version by John Neil
*/
/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 1.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

mail address:   Man L. Li
                Dept. of Computer Science
                University of Houston
                4800 Calhoun Road
                Houston, TX 77004

e-mail address: manli@cs.uh.edu         (Internet)
                coscgbn@uhvax1.bitnet   (BITNET)
                70070,404               (CompuServe)

For the NeXT version, please report any bug/fix, modification, suggestion to

mail address:   John Neil
                Mathematics Department
                Portland State University
                PO Box 751
                Portland, OR  97207

e-mail address: neil@math.mth.pdx.edu  (Internet)
                neil@psuorvm.bitnet    (BITNET)
*/

#include "comment.header"

/* Generated by Interface Builder */

/* $Id: GoApp.h,v 1.1 2003/01/12 04:01:52 gcasa Exp $ */

/*
 * $Log: GoApp.h,v $
 * Revision 1.1  2003/01/12 04:01:52  gcasa
 * Committing the entire GNU Go and NeXT Go application to the repository.
 * See COPYING file for GNU License.
 *
 * Revision 1.4  1997/11/04 16:50:42  ergo
 * ported to OpenStep
 *
 * Revision 1.3  1997/07/06 19:38:21  ergo
 * actual version
 *
 * Revision 1.4  1997/05/30 18:44:14  ergo
 * Added an Inspector
 *
 * Revision 1.3  1997/05/04 18:57:17  ergo
 * added time control for moves
 *
 */

#import <AppKit/NSApplication.h>
#include "history.h"
#include "smartgo.h"
#include "igs.h"
#include "godict.h"
#include "GoServer.h"
#import "Controller.h"

extern unsigned char p[19][19], l[19][19], ma[19][19], ml[19][19];
extern char special_characters[19][19];
extern int hist[19][19], currentMoveNumber;
extern int rd, lib, play, pass, handicap, MAXX, MAXY;
extern int currentStone, opposingStone, blackCaptured, whiteCaptured;
extern int blackTerritory, whiteTerritory, SmartGoGameFlag, initialization;
extern float black_Score, white_Score;
extern int blackCapturedKoI, blackCapturedKoJ, whiteCapturedKoI, whiteCapturedKoJ;
extern int bothSides, neitherSide, blackPassed, whitePassed, manScoreTemp;
extern BOOL typeOfScoring, manualScoring, whiteSide, blackSide, AGAScoring;
extern int opn[9];                               // opening pattern flag
extern BOOL gameType;
extern BOOL finished;
extern gameHistory gameMoves[500];
extern int lastMove;
extern node *SGgameMoves, *currentNode;
extern FILE *smartGoInputFile;
extern char *SGfile, *currentSGfilePosition;
extern char *IGSStatusText, IGSPasswordText[20], IGSLoginText[20];

#ifndef KOMI
#define KOMI 5.5
#endif

@interface GoApp:NSApplication
{
  NSTimer *timer;
  id  gameWindow;
  id  MainGoView;
  id  handicapSlider;
  id  handicapText;
  id  BlackPlayer;
  id  WhitePlayer;
  id  prefPanel;
  id  savePrefsFlag;
  id  sizeSlider;
  id  sizeText;
  id  smartGoComments;
  id  smartGoPanel;
  id  smartGoNodeName;
  id  smartGoNodeNumber;
  id  smartgoVariants;
  id  stepForwardButton;
  id  stepBackwardButton;
  id  jumpForwardButton;
  id  jumpBackwardButton;
  id  scoringMethod;
  id  scoringType;
  id  AGAscoringMethodFlag;
  id  IGSCommand;
  id  IGSSendButton;
  id  IGSStatus;
  id  IGSobserveNumber;
  id  IGSPanel;
  id  IGSfont;
  id  IGSboldFont;
  id  LoadGameText;
  id  LoadGameWindow;
  id  observeSelPanel;
  id  observeScrollView;
  id  observeMatrix;
  id  observeBox;
  id  observeCell;
  id  loadMenuCell;
  id  observeMenuCell;
  id  unobserveMenuCell;
  id  versionString;
  id  transTypeMISC;
  id  transTypeNAME;
  id  transTypeCHAM;
  id  transTypeTECH;
  id  transTypePOLI;
  id  transTypeDIGI;
  id  transLangJP;
  id  transLangCH;
  id  transLangRK;
  id  transLangGB;
  id  transLangNL;
  id  transLangGE;
  id  transLangFR;
  id  transLangSV;
  id  transLangDG;
  id  transLangCP;
  id  translateWindow;
  id  translateTerm;
  id  translateResults;
  id  translateButton;
  id  formatMatrix;
  id  controller;
  id  gameInspector;
  id  CommandSender;
}

+ (void)initialize;
- showError: (const char *)errorMessage;
- UserPass:sender;
- stopGame:sender;
- startGame:sender;
- NewGame:sender;
- SetPreferences:sender;
- stepSmartGoFile:sender;
- stepBackSmartGoFile:sender;
- jumpSmartGoFile:sender;
- jumpBackSmartGoFile:sender;
- openNeXTGoFile:(const char*)aFile;
- openSmartGoFile:(const char *)aFile;
- displayNewSGNode;
- AddSGComment:(char *)s;
- AddSGVariantName:(char *)s;
- SetSGNodeName:(char *)s;
- IGSSendCommand:sender;
- setCommandSender:(id)aSender;
- connect:(GoServer*)server;
- checkNetTraffic;
- SetIGSStatus:(char *)s;
- getGoView;
- open:sender;
- save:sender;
- setFormat:sender;

/*
  The following methods are related to the built-in dictionary
  */
- initTranslator:sender;
- performTranslate:sender;
- addTranslateResults:(char *)s;
- translateOutput:(GODICT *)d;

/*
  The following methods are the various commands for the Internet Go Server
  */

- IGSOpenLoadGame:sender;
- IGSLoadGame:sender;
- IGSobserve:sender;
- IGSunobserve:sender;
- IGSdone:sender;
- IGSquit:sender;
- cellClicked:theCell;
- sendCommand:sender;
- gameCompleted;

- (void) checkingNetTraffic:(NSTimer *)aTimer;

@end



