/*
   Project: DataBasin

   Copyright (C) 2009 Free Software Foundation

   Author: Riccardo Mottola

   Created: 2009-01-13 00:36:45 +0100 by multix

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import "DBCVSWriter.h"

@implementation DBCVSWriter

- (id)initWithHandle:(NSFileHandle *)fileHandle
{
  if ((self = [super init]))
    {
      file = fileHandle;
      isQualified = NO;
      qualifier = @"\"";
      separator = @",";
      newLine = @"\n";
   }
  return self;
}

- (void)setFieldNames:(NSArray *)array andWriteIt:(BOOL)flag
{
  if (flag == YES)
    {
      NSString *theLine;
      const char *cStr;
      
      NSLog(@"should write out field names to file");
      theLine = [self formatOneLine:array];
      cStr = [theLine cString];
      NSLog(@"cString: %s", cStr);
      [file writeData:[NSData dataWithBytes:cStr length:strlen(cStr)]];
    }
}

- (void)writeDataSet:(NSArray *)array
{
  int i;
  int setCount;

  setCount = [array count];
  for (i = 0; i < setCount; i++)
    {
      const char *cStr;
      NSString *oneLine;
      
      oneLine = [self formatOneLine:[array objectAtIndex:i]];
      cStr = [oneLine cString];
      [file writeData:[NSData dataWithBytes:cStr length:strlen(cStr)]];
    }
}

- (NSString *)formatOneLine:(NSArray *)values
{
  NSMutableString *theLine;
  int      size;
  int      i;
  
  theLine = [[NSMutableString alloc] initWithCapacity:64];
  size = [values count];

  if (size == 0)
    return nil;
    
  for (i = 0; i < size-1; i++)
    {
      [theLine appendString:[values objectAtIndex:i]];
      [theLine appendString:separator];
    }
  [theLine appendString:[values objectAtIndex:i]];
  [theLine appendString:newLine];
  return theLine;
}

@end
