##Module: pathcontrol
##Assumes sys and os have been imported

##    Fonty Python Copyright  (C)  2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##     ( at your option )  any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##
import os

class PathControl:
    """Written with multi o/s in mind (Not really the case yet)
    1. Makes the .fontypython path
    2. Provide paths for fontypython on Linux and Windows
    3. Provide list of pog names (without the .pog extension)
    4. Provide a list of pog FILE names (with .pog extension) """
    def __init__ ( self ):
        self.__HOME = os.environ['HOME']
        __opsys = os.name
        if __opsys == "posix":
            self.__fphomepath = self.__HOME + "/.fontypython/"
            self.__fpconffile =  self.__HOME + "/.fontypython/fp.conf"
            #Is there a .fonts folder ?
            if not os.path.exists(self.__HOME + "/.fonts"):
                #We gotta make it.
                try:
                    os.mkdir ( self.__HOME + "/.fonts" )
                except:
                    print "Couldn't make the .fonts folder in %s" % self.__HOME
                    print "Please check your write permissions and try again."
                    sys.exit ()
            self.__userfontpath = self.__HOME + "/.fonts"
        elif __opsys == "nt":
            self.__fphomepath = self.__HOME + "\\fontypython\\"
            self.__fpconffile = self.__HOME + "\\fontypython\\fp.conf"
        else:
            sys.exit ( "Unsupported O/S" )
        
        #Make ~/.fontypython or ?:\Documents and Settings\blah\blah\fontypython
        if not os.path.exists ( self.__fphomepath ):
            try:
                os.makedirs ( self.__fphomepath ) #using makedirS - just in case.
            except:
                print "Couldn't make the folder in %s" % self.__fphomepath
                print "Please check your write permissions and try again."
                sys.exit ()
            
    def appPath ( self ): return self.__fphomepath
    def appConf ( self ): return self.__fpconffile
    def getPogNames ( self ): return [ f[0:-4] for f in os.listdir ( self.__fphomepath ) if ".pog" in f ]
    def getPogFileNames ( self ): return [ f for f in os.listdir ( self.__fphomepath ) if ".pog" in f ]
    def userFontPath ( self ): return self.__userfontpath
    def home ( self ) : return self.__HOME
