##    Fonty Python Copyright (C) 2006 Donn.C.Ingle
##
##    Contact: donn.ingle@gmail.com - I hope this email lasts.
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##

version = "0.1.3"

import sys

try:
    import wxversion
    #Let's make sure things will work.
    wxversion.ensureMinimal("2.6")
except:
    print """I cannot find python-wxversion, this
    may mean you have some missing dependencies.
    Fonty Python will try to start anyway ...
    
    If you get long error messages, you will need to
    install python-wxgtk2.6 or better.
    Go to http://wxpython.sourceforge.net/download.php
    """

#Try main wx
try:
    import wx
except:
    print """Fonty Python depends on "wxPython".
    Please install "python-wxgtk2.6" (or better) here are the details:
   
    Go to http://wxpython.sourceforge.net/download.php
    """
    sys.exit ()

#import PIL
try:
    import Image, ImageFont, ImageDraw #The PIL stuff.
except:
    print """Fonty Python depends on "PIL" - Python Imaging Library.
    Please install "python2.4-imaging" using your distro's tools.
    
    See: http://www.pythonware.com/products/pil/index.htm
    """
    sys.exit()

#Finish the imports
import wx.lib.scrolledpanel
import wx.lib.statbmp
import os
import pickle
from optparse import OptionParser

#-----------------------------------------------------------------------------------------------
# I tried to stick to this, but things got messy!
#
# Classes : Start with a cap and then camel
# Defs      : Start with a cap and then camel
# vars       : All lowercase and no camels
# globals  : Start with a small g then capital then continue

class PathControl:
    """
    Written with multi o/s in mind. Not really the case yet.
    1. Makes the .fontypython path.
    2. Provide paths for fontypython on Linux and Windows
    Is global
    """
    def __init__(self):
        self.HOME = os.environ['HOME']
        opsys = os.name
        if opsys == "posix":
            self.fphomepath = self.HOME + "/.fontypython/"
            self.fpconffile =  self.HOME + "/.fontypython/fp.conf"
            #Is there a .fonts folder ?
            if not os.path.exists(self.HOME + "/.fonts"):
                #We gotta make it.
                try:
                    os.mkdir(self.HOME + "/.fonts")
                except:
                    print "Couldn't make the .fonts folder in %s" % self.HOME
                    print "Please check your write permissions and try again."
                    sys.exit()
            self.userfontpath = self.HOME + "/.fonts"

        if opsys == "nt":
            self.fphomepath = self.HOME + "\\fontypython\\"
            self.fpconffile = self.HOME + "\\fontypython\\fp.conf"
            #Unfinished
        
        #Make ~/.fontypython or ?:\Documents and Settings\blah\blah\fontypython
        if not os.path.exists(self.fphomepath):
            try:
                os.makedirs(self.fphomepath) #using makedirS - just in case.
            except:
                print "Couldn't make the folder in %s" % self.fphomepath
                print "Please check your write permissions and try again."
                sys.exit()
            
    def FontyPythonHomePath(self):
        return self.fphomepath
    def FontyPythonConfigFile(self):
        return self.fpconffile
    def GetPogNames(self):
        """Only gets pognames sans extension"""
        list = [f[0:-4] for f in os.listdir(self.FontyPythonHomePath()) if ".pog" in f]
        return list
    def UserFontPath(self):
        """Returns a path to the font folder"""
        return self.userfontpath

class Fitmap(wx.lib.statbmp.GenStaticBitmap):
    """A Fitmap is a bitmap of a font, with events and a label and a bunch of stuff."""
    def __init__(self,parent, pos ,fitem, MAINFRAME):
        self.name = os.path.basename(fitem.paf)
        self.fitem = fitem #We are holding a ref to this object
        
        self.MAINFRAME = MAINFRAME
        
        #I prevent font's own height due to mad ttfs.
        #I based this on my preference. Some ttfs had these crazy heights
        #and would shoot off the page. So, I nixed that.
        self.height = gConfigure.points * 1.55
        
        self.bitmap,self.goodfont = self.wxTtfBitmap(self.fitem.paf,gConfigure.points," " + gConfigure.text + " ")
        self.whitebrush = wx.Brush('WHITE',wx.SOLID)
        
        sz = (self.bitmap.GetWidth(), self.height)
        self.gsb = wx.lib.statbmp.GenStaticBitmap.__init__(self,parent,-1,self.bitmap,pos,sz)#,style=wx.WANTS_CHARS)
        
        self.width = self.bitmap.GetWidth()
        
        self.Bind(wx.EVT_LEFT_UP,self.OnClick)
        self.Bind(wx.EVT_PAINT,  self.OnPaint)
        
    def OnPaint(self,event):
        dc = wx.PaintDC(self)
        dc.SetBackground(self.whitebrush)
        dc.Clear()

        if self._bitmap:
            #Draw the actual font bitmap with a tick/cross over it (If ticked)
            if self.fitem.ticked:
                dc.DrawBitmap(self._bitmap, 10, 0, True)
                dc.DrawBitmap(TICKMAP,20,5,True)
            else:
                dc.DrawBitmap(self._bitmap, 0, 0, True)

            #Now draw the text showing the font name
            if self.goodfont:
                if self.fitem.inactive:
                    dc.SetTextForeground("black")
                else:
                    dc.SetTextForeground("gray")
                    
                dc.SetFont(wx.Font(10, family=wx.SWISS, style=wx.NORMAL, weight=wx.NORMAL, underline=False))
                txt = self.name
            else:
                dc.SetTextForeground("red")
                dc.SetFont(wx.Font(10, family=wx.SWISS, style=wx.NORMAL, weight=wx.BOLD, underline=False))
                txt = "Bad font:%s" % self.name

            #tw , th = dc.GetTextExtent(txt)
            th = 16 #Seems faster to guess the height... gulp!
            dc.DrawText(txt,1,self.height-th)
            
            #Special message
            if self.fitem.inactive:
                dc.SetTextForeground("gray")
                dc.SetFont(wx.Font(10, family=wx.SWISS, style=wx.NORMAL, weight=wx.BOLD, underline=False))
                dc.DrawText(self.fitem.msg,1,1)
                
            #Now a dividing line
            dc.SetPen(wx.Pen("black",1))
            dc.SetBrush(wx.TRANSPARENT_BRUSH)
            dc.DrawLine(0,self.height-1,self.width,self.height-1)

    def OnClick(self,event):
        if self.goodfont and gCanTick and not self.fitem.inactive:
            self.Refresh() #forces a redraw.
            self.fitem.ticked = not(self.fitem.ticked)
        
    def wxTtfBitmap(self,paf,points,text):
        """Make a font and draw it using PIL. Then convert it to a wx bitmap.
        If there is a faster way to do this - please let me have it!
        """
        goodfont = True #If False, then the ttf could not be drawn.
        ly = int(self.height) #We control the height.
        try:
            font = ImageFont.truetype(paf,points)
            lx,discard = font.getsize(text)
            lx = int(lx) #Gotta int it because PIL prints a warning.
            pilimage = Image.new("RGB", (lx,ly), (255,255,255))
            draw = ImageDraw.Draw(pilimage)
            if self.fitem.inactive:
                col = (180,180,180)
            else:
                col = 0
            draw.text((0,0),text,font=font,fill=col)
        except IOError:
            lx = 200 #Random width - a guess.
            pilimage = Image.new("RGB", (lx,ly), (255,255,255))
            goodfont = False
        except:
            sys.exit("Unhandled PIL error: %s " % sys.exc_info()[0])
        try:    
            wximage = wx.EmptyImage(lx,ly)
            wximage.SetData(pilimage.convert('RGB').tostring())
            wximage.InitAlpha()
        except:
            sys.exit("Error creating a wximage of %s : %s" % (paf,sys.exc_info()[0]))
            
        return (wximage.ConvertToBitmap(),goodfont)

class FontView(wx.lib.scrolledpanel.ScrolledPanel):
    """Draw a list of fitmaps from a FontList object"""
    def __init__(self,parent):
        wx.lib.scrolledpanel.ScrolledPanel.__init__(self,parent, -1)
        self.parent = parent
        
        #self.Bind(wx.EVT_KEY_UP, self.parent.OnKeyUp) #Great - it works!!!
        
        self.fitmaps=[]
        self.drawFitmaps()
        
    def drawFitmaps(self):
        """Draw X number of fitmaps down the control"""
        for f in self.fitmaps:
           f.Destroy() #Ah, nailed ya! You bastard! I fart in your general direction!

        self.fitmaps=[] #I dunno, I feel I should keep refs to all the objects, to keep them alive.
        self.mySizer = wx.BoxSizer(wx.VERTICAL)

        index = self.parent.getPageIndex() - 1
        numinpage = gConfigure.numinpage
        
        #index * 10 = 0, 10, 20 etc
        #from that tot, for 10 fonts, or end of list = sublist
        start = index * numinpage
        fin = start + numinpage
        #print "fin before ",fin
        if fin > gFontlist.len():
            fin = gFontlist.len()
            
        sublist = gFontlist.fontitems[start:fin] #A short-list of font item objects

        i = 0
        #L=len(sublist)
        #print L, start, fin
        h=0
        for fitem in sublist:
            fm = Fitmap(self,(0,i*h),fitem, MAINFRAME=self.parent)
            h = fm.height + 10
            self.fitmaps.append(fm)
            self.mySizer.Add(fm,0,wx.GROW)
            i += 1
            #per = (100.00/L) * i
            #print "%3d" % per

        self.SetSizer(self.mySizer)
        self.SetAutoLayout(True)
        self.SetupScrolling(rate_x=5,rate_y=4)
        
class MainFrame(wx.Frame):
    def __init__(self,parent,title):
        #Draw the frame
        wx.Frame.__init__(self,parent,-1,title,gConfigure.pos,gConfigure.size)
        self.SetSizeHintsSz((300,400)) #After hours of hell, this is all that seems to work.
        
        #Try to show an icon
        try:
            image = wx.Image(gMyThingsDir + 'fplogo.png', wx.BITMAP_TYPE_PNG)
            image = image.ConvertToBitmap()
            icon = wx.EmptyIcon()
            icon.CopyFromBitmap(image)
            self.SetIcon(icon)
        except:
            pass
        
        #Work out how many pages to dispay.
        #I am terrible at this kind of thing, so this probably needs fixing.
        self.totpafs = gFontlist.len()
        #If there are more fonts demanded on a page than there are fonts at all...
        if gConfigure.numinpage > self.totpafs:
            gConfigure.numinpage = self.totpafs 
        self.totnumpages = self.totpafs / gConfigure.numinpage
        #If there is more than one page, get the remainder and add a page if need be.
        if self.totpafs > gConfigure.numinpage and self.totpafs % gConfigure.numinpage > 0:
            self.totnumpages += 1
        #Phew! That's over with!

        self.pageindex = 1 #I start here
        
        #Top panel - holds text and a choice control
        self.topPanel = wx.Panel(self)
        topPanelSizer = wx.BoxSizer(wx.HORIZONTAL)
        #INFO text
        if gFontlist.type == POG:
            txtview = "%s" % gFontlist.name
        if gFontlist.type == FOLDER:
            txtview = gFontlist.name #The path is the 'name'
        txtview = " Viewing %s" % txtview
        if gFontlistTarget:
            if gFontlistTarget.type == POG:
                txtdst = "to store in %s" % gFontlistTarget.name
                txtview = "%s %s" % (txtview,txtdst)
                
        self.info = wx.StaticText(self.topPanel, -1, txtview)
        
        #Now a combo box
        self.pagechoice = wx.Choice(self.topPanel, -1, choices = [str(n) for n in range(1,self.totnumpages+1)])
        
        topPanelSizer.Add(self.info,1,wx.ALIGN_CENTER_VERTICAL)
        #topPanelSizer.Add((1,1),1,wx.GROW)
        topPanelSizer.Add(self.pagechoice, 0 ,wx.EXPAND | wx.ALIGN_RIGHT) #Added it to the sizer
        self.topPanel.SetSizer(topPanelSizer) #Assign the sizer to the panel
        self.pagechoice.Bind(wx.EVT_CHOICE, self.OnPagechoiceClick)
        
        #Create the font view object
        self.fv = FontView(self)
        
        #Create the panel for the buttons, at the bottom
        self.buttonsPanel = wx.Panel(self)
        buttonsPanelSizer = wx.BoxSizer(wx.HORIZONTAL)

        self.buttPrev = wx.Button(self.buttonsPanel,PREV)
        self.buttMain   = wx.Button(self.buttonsPanel, label=gButtonText)
        self.buttNext = wx.Button(self.buttonsPanel, NEXT)
        self.buttPrev.Enable(False) #Starts out disabled
        
        buttonsPanelSizer.Add(self.buttPrev,0,wx.EXPAND)
        buttonsPanelSizer.Add((10,1),0,wx.EXPAND)
        buttonsPanelSizer.Add(self.buttMain,1,wx.EXPAND)
        buttonsPanelSizer.Add((10,1),0,wx.EXPAND)
        buttonsPanelSizer.Add(self.buttNext,0,wx.EXPAND)
        
        self.buttonsPanel.SetSizer(buttonsPanelSizer)
        
        #Now the sizer to hold all the controls on this frame
        frameSizer = wx.BoxSizer(wx.VERTICAL)
        frameSizer.Add(self.topPanel, 0, wx.EXPAND) #The top panel
        frameSizer.Add(self.fv,1,wx.EXPAND) #The font view
        frameSizer.Add((8,8),0,wx.EXPAND) #A spacer
        frameSizer.Add(self.buttonsPanel,0,wx.EXPAND) #The buttons
        self.SetSizer(frameSizer)
    
        #Setup a global ESC trap - thanks to Robin Dunn
        self.accel = wx.AcceleratorTable([(wx.ACCEL_NORMAL, wx.WXK_ESCAPE, ID_ESC)])
        self.SetAcceleratorTable(self.accel)
        self.Bind(wx.EVT_MENU, self.OnHandleESC, id=ID_ESC)
        print "done"
        
        #The events
        self.Bind(wx.EVT_CLOSE,self.OnCloseWindow)
        #self.Bind(wx.EVT_KEY_UP, self.OnKeyUp)
        self.buttPrev.Bind(wx.EVT_LEFT_UP,self.NavClick)
        self.buttNext.Bind(wx.EVT_LEFT_UP,self.NavClick)
        self.buttMain.Bind(wx.EVT_LEFT_UP,self.MainClick)
        
        self.buttonsPanel.SetFocus()
        self.ButtonState()
        
    def getPageIndex(self):
        return self.pageindex

    def OnPagechoiceClick(self,event):
        if self.pageindex != int(event.GetString()): #Only redraw if actually onto another page.
            self.pageindex =  int(event.GetString())
            self.ButtonState()
            self.fv.drawFitmaps()
        
    def NavClick(self,event):
        if event.GetId() == NEXT: 
            self.pageindex += 1
        else: #PREV
            self.pageindex -= 1
        if self.pageindex > self.totnumpages:
            self.pageindex = self.totnumpages
        if self.pageindex == 0:
            self.pageindex = 1
        self.ButtonState ()
        self.buttMain.SetFocus () #a GTK bug demands this move.
        self.pagechoice.SetSelection(self.pageindex-1) #Keep the choice control updated too.
        self.fv.drawFitmaps ()
        
    def ButtonState(self):
        #State of buttons
        n = True
        p = True
        if self.pageindex == self.totnumpages: 
            n = False
        if self.pageindex == 1:
            p = False
        self.buttNext.Enable(n)        
        self.buttPrev.Enable(p)

    def MainClick(self,event):
        """The main button in the frame"""
        if gButtonTask == REMOVE:
            print "Removing fonts from pog:",gFontlist.name,gFontlist.paf
            victims = []
            dowrite = False
            for i in gFontlist.fontitems:
                if i.ticked:
                    victims.append(i)
                    dowrite = True #There was actually some change
            for v in victims:
                gFontlist.fontitems.remove(v)
                
            if dowrite: WritePog(gFontlist)
            
        if gButtonTask == COPY:
            print "Copying fonts from %s to %s" % (gFontlist.name,gFontlistTarget.name)
            dowrite = False
            for i in gFontlist.fontitems:
                if i.ticked:
                    gFontlistTarget.fontitems.append(i)
                    dowrite = True
            
            if dowrite: WritePog(gFontlistTarget)
        
        print "Done."
        self.EndApp()
            
    def OnHandleESC(self,event):
        #keycode = event.GetKeyCode()
        #if keycode == wx.WXK_ESCAPE:
        print "Done. No changes have been made."
        self.EndApp()
        #event.Skip()
            
    def OnCloseWindow(self, event):
        print "Done. No changes have been made."
        self.EndApp()
    def EndApp(self):
        #Save my state: size, position, numfonts.
        self.size = self.GetClientSizeTuple()
        self.pos = self.GetPositionTuple()
        gConfigure.save(self.pos, self.size)
        
        self.Destroy()
   
class Configure:
    """Makes/Loads the conf file.
    Supplies size, pos, numinpage, text string and point size to other objects."""
    def __init__(self):
        self.data = {}
        #Set some defaults:
        self.size = (400,600)
        self.pos = wx.DefaultPosition
        self.numinpage = 10
        self.text = "Jump the lazy dog fox"
        self.points = 64        
        try:
            pf = open(gPC.FontyPythonConfigFile(),"r") #Using global gPC object!
            self.data = pickle.load(pf)
            pf.close()
            self.size = self.data['size']
            self.pos = self.data['pos']
            self.numinpage = int(self.data['numinpage'])
            self.text = self.data['text']
            self.points = int(self.data['points'])
        except:
            print "No config file found, creating it with defaults."
            self.__write__()
        
    def __write__(self):
        self.data = {"size":self.size,"pos":self.pos,"numinpage":self.numinpage,"text":self.text,"points":self.points}
        try:
            pf = open(gPC.FontyPythonConfigFile(),"w")
            pickle.dump(self.data,pf)
            pf.close()
        except:
            print "Could not write to the config file."
            
    def save(self, pos=None, size=None):
        if pos:
            self.pos = pos
        if size:
            self.size = size
        self.__write__() #Go write the file
        
class App(wx.App):
    def OnInit(self):
        frame = MainFrame(None, "Fonty Python: bring out your fonts!")
        self.SetTopWindow(frame)
        frame.Show(True)
        return True

class FontItem:
    """Represents a single font"""
    def __init__(self, paf, ticked, inactive = False, msg = ""):
        self.paf = paf
        self.ticked = ticked
        self.inactive = inactive #Means it shows, but cannot be ticked.
        self.msg = msg #Say something unique when I draw this item.
        #print self.paf
        
class FontList:
    """Represents either a Pog or a Folder full of Font Items"""
    def __init__(self, nameOrpath, type):
        self.fontitems = []
        self.type = type

        if type == POG:
            self.name = nameOrpath
            self.paf = gPC.FontyPythonHomePath() + self.name + ".pog"
            #Extract all the pafs from the pog file, also see if it's installed.
            #The first line will be 'installed' or "not installed"
            try:
                f = open(self.paf, "r")
            except:
                print "The pogfile %s could not be opened" % self.name
                sys.exit()
            line1 = f.readline()[:-1] #Get the first line, and strips the \n
            self.empty = True
            #try: #catch empty pog
            for paf in f: #This continues from line 2 onwards ...
                paf = paf[:-1] #Strip the dam \n from the file
                fi = FontItem(paf, False) #Make an item, unticked
                self.fontitems.append(fi)
                self.empty = False
           
            f.close()
            #Is it installed or not?
            if line1.upper() == "INSTALLED":
                self.installed = True
            elif line1.upper() == "NOT INSTALLED":
                self.installed = False
            else:
                #We have a bad file, missing the first row.
                #Why not make it anew?
                try:
                    f = open(self.paf, "w")
                    f.write("not installed\n")
                    f.close()
                    self.installed = False
                except:
                    print "%s is corrupt or there are permission problems. Please check." % self.paf
                    sys.exit()
        else: #it's a folder
            #Use abspath to make an entire path from root / to the folder in question
            #This to prevent fonts like ../ttfs/z/ or something horrid.
            #The self.name variable is fugly. It should be self.path , but .name is referred-to
            #by other users of this object...
            self.name = os.path.abspath(nameOrpath)
            self.empty = True
            for f in os.listdir( self.name ):
                if f[-4:].upper() == ".TTF":
                    fi = FontItem(os.path.join(self.name ,f), False)
                    self.fontitems.append(fi)
                    self.empty = False
            if self.empty:
                print "Fonty Python could find no ttf files in %s" % self.name
                sys.exit()
                
    def len(self):
        return len(self.fontitems)



# ===============BEGIN ===============

def MakePog(pogname):
    try:
        pogext = pogname + ".pog"
        f = open(os.path.join(gPC.FontyPythonHomePath(), pogext),"w")
        f.write("not installed\n")
        f.close()
    except:
        print "Error writing pog file %s" % pogext
        sys.exit()
    print "The pog named \"%s\" has been created" % pogname
    


def WritePog(fontlist):
    #Given a fontlist object, go and write it over a pog file
    #print "writing ", fontlist.paf
    try:
        f = open(fontlist.paf,"w")
        i = "not installed\n"
        if fontlist.installed:
            i = "installed\n"
        f.write(i)
        #Now write the font pafs
        for i in fontlist.fontitems:
            f.write(i.paf + "\n")
            #print "wrote ", i.paf + "\n"
        f.close()
    except:
        print "Error writing %s. Sorry about that.\n\
        Check your permissions on the %s folder." % (fontlist.name, gPC.FontyPythonHomePath())
        sys.exit()
        
def DetectPog(s, poglist):
    """Given a string s and a list of pognames, try to determine whether it's a pog or not"""
    """Return True or False"""

def determine_fontypython_path ():
    """Borrowed from wxglade.py"""
    try:
        root = __file__
        if os.path.islink(root):
            root = os.path.realpath(root)
        return os.path.dirname(os.path.abspath(root))
    except:
        print "I'm sorry, but something is wrong."
        print "There is no __file__ variable. Please contact the author."
        sys.exit ()
        
#Just clear up some sad facts:
if os.name != "posix":
    print "Sorry, only Gnu/Linux is supported at the moment."
    sys.exit()


#Consts
NEXT=wx.ID_FORWARD
PREV=wx.ID_BACKWARD
ID_ESC = wx.NewId ()
POG = 0
FOLDER = 1
CLOSE = 1 #Just close
REMOVE = 2 #Remove the selected fonts from the pog
COPY = 3 #Copy the selected fonts from target to store

#Globals
gCanTick = True #Can this thing be ticked?
gTickpng = "tick.png" #default image
gButtonText = "What do they call the 'Finish' button in Finland?"
gFontlistTarget = None #There is no target/store pog as yet.
gMyThingsDir = determine_fontypython_path () + "/things/" #point it at things/ folder

def start ():
    #Make global the vars that change value within this function.
    global gPC
    global gConfigure
    global gFontlist
    global gFontlistTarget
    global TICKMAP
    global gTickpng
    global gButtonText
    global gButtonTask
    global gCanTick
    
    #Ensure we have a .fontypython folder and a .fonts folder.
    gPC = PathControl() 
    
    #Sort out this command line stuff:
    parser = OptionParser()
    
    use = """%prog [OPTIONS] VIEW [STORE]

    VIEW  : A place where fonts are. A pog or a folder someplace.
    STORE : A pog. A place to keep those fonts (just references to them)
    (A "pog" is a place to keep typography. Well, why not?)
    Do not use spaces in pog names.
    
    Please use -e or --example to see more info.
    
    The basic idea:
    ===============
    Many designers have collections of ttf files in big directory
    structures or on other media. Fonty Python will let you gather
    your fonts and structure them into collections or what I call
    "pogs". Your fonts never move from where they are
    (so don't worry). All that happens is that you put references
    to fonts (by clicking them visually) into a pog and then you
    install or remove pogs as you need them.
    For example, you might have a pog called "logos" into which
    you place all the ttfs you have of company logos. After that,
    when you need to work with those logos, you simply install
    the 'logos' pog and start your design app!
    
    Manage your ttf fonts on Gnu/Linux!
    (A 100% GUI is coming, just as soon as the Parrot wakes up.)

    Fonty Python Copyright (C) 2006 Donn.C.Ingle
    Fonty Python comes with ABSOLUTELY NO WARRANTY; for details
    see the COPYING file.  This is free software, and you are welcome
    to redistribute it under certain conditions; see the COPYING file 
    for details."""
    
    parser = OptionParser(usage=use, version="Fonty Python %s Copyright (C) 2006 Donn.C.Ingle" % version)
    parser.add_option("-e", "--examples", action="store_const",dest="examples", const=True,
                      help="show some %$@#$ examples!")
        
    parser.add_option("-i", "--install", dest="install",metavar="pog",
                      help="install the fonts in this pog to your fonts folder")
    
    parser.add_option("-r", "--remove",dest="remove",metavar="pog",
                      help="remove the fonts in this pog from your fonts folder")
    
    parser.add_option("-l", "--list",action="store_const", const=True,
                      help="list the names of all the pogs")    
    
    parser.add_option("-s", "--size",action="store", metavar="num",dest="points",
                      help="set a new default point size. 64 is best")    
    
    parser.add_option("-v", "--view",action="store", metavar="num",dest="numinpage",
                      help="set a new default for how many fonts to view at one go. 10 is good")  

    parser.add_option("-t", "--text",action="store", metavar="\"text\"",dest="text", type="string",
                    help="set a new default sample text. \"This is an ex-parrot!\" is good. Be sure to use the quotes")  

    parser.add_option("-p", "--purge",action="store", metavar="pog",dest="purge", 
                    help="purge the pog of ttf files that are no longer really there")  
                       
    (options, args) = parser.parse_args()

    if options.examples:
        e = """
The basic format is:
%prog VIEW [STORE]
  VIEW  = A place where fonts are. A pog or a folder
          someplace.
  STORE = A pog. A place to keep those fonts (just 
          references to them). If you don't include
          this then you are viewing/editing only
          and not storing fonts in a pog.

Tips:
=====
* Don't use spaces in pog names. If you absolutely must
  then use quotes around the name, e.g. "Pogs of Ni"
* Use the Escape key to quit the app without making
  changes.
* If your design apps (for example The Gimp) do not
  reflect the fonts that you have installed, restart
  the app. Sometimes the system needs a while to
  reflect the new fonts in your fonts folder.

Examples: - mostly using short options, see -h
=========
%prog /path/to/fonts/ttfs/a
  This will let you view the fonts in that path,
  nothing more.
 
%prog /path/to/fonts/ttfs/b Trouser
  This will let you view and choose fonts from the
  path and it will store them in a pog named "Trouser".
  The pog will be created if it's not already there.

%prog Lumberjack
  This will let you see the fonts in the pog named
  "Lumberjack". You can also remove individual
  fonts by selecting them. A cross will appear
  indicating the fonts that will be removed.

%prog Camelot Spamalot
  This will let you see and choose fonts in
  "Camelot" and it will store them in "Spamalot"
  It lets you copy fonts between pogs.

%prog -i Cheese
%prog --install Cheese
   Will install the fonts in pog Cheese so you can
   use them in other apps.

%prog -r Trouser
%prog --remove Trouser
   Will remove the fonts listed in pog Trouser, so
   you can't use 'em anymore. (You Naughty thing)

%prog -t "Pigs on the wing"
    Will set the text and exit. It's odd that way.
    Start it again to see the change.
    
%prog -s 128 
    Will set the point size to 128 - Crazy man!
    
%prog --size 64 -v 10 Pimple
    Will set the point size to 64, the number of fonts
    to view to 10 and then display the Pimple pog.

%prog -p Glutton
    If there are any fonts in "Glutton" that are not
    really on your drive/media anymore (perhaps you
    deleted them or the cat did) then this will go 
    through your pog and cull them.
    
Your FontyPython folder is:
"""+gPC.FontyPythonHomePath()+"""
If you want to backup your pogs, that's where ya go.

contact: donn.ingle@gmail.com
Copyright (C) 2006 Donn.C.Ingle"""
        e = e.replace("%prog",sys.argv[0])
        print e
        sys.exit()

    
    #Go get a list of all pog names
    poglist = gPC.GetPogNames()
    
    #Let's handle those options that DO NOT require args
    #-l --list
    #Quick and dirty. Not using the FontList object at all.
    if options.list:
        if len(poglist) == 0:
            print "There are no pogs available."
            sys.exit()
        print "Listing %d pog(s)" % len(poglist)
        print "(*) indicates installed pogs"
        for pog in poglist:
            paf = gPC.FontyPythonHomePath() + pog + ".pog"
            try:
                f = open(paf,"r")
                installed = f.readline()[:-1] #Strips the \n off the end
                f.close()
            except:
                print "Could not open %s." % paf
            s = " "
            if installed.upper() == "INSTALLED":
                s = "*"
            print "%s %s" % (s,pog)
        sys.exit()
    
    #Start the config object - it will load (or create) the conf file.
    gConfigure = Configure() #We need this for entire app.
    
    #-p --point
    #This one can mix with other args, so don't exit.
    if options.points > 0:
        gConfigure.points = int(options.points)

    #-f --fonts
    #This one can mix with other args, so don't exit.
    if options.numinpage > 1:
        gConfigure.numinpage = int(options.numinpage)
        
    #-t --text
    #This one has potential to screw-up badly
    #if the user forgets the quotes.
    #For now, I will exit app.
    if options.text:
        gConfigure.text = options.text
        #Save the config file
        gConfigure.save()        
        print "Your text has been set to \"%s\"" % options.text
        print "Tip: Did you use quotes to surround your text?"
        print "Start FontyPython again to see the result."
        sys.exit()

    #Let's just make sure the user has a .fonts folder
    dst = gPC.UserFontPath()

    #Handle purge
    if options.purge:
        if options.purge in poglist:
            pog = FontList(options.purge, POG)
            if pog.installed:
                print "Please remove the pog first."
                sys.exit()
            else:
                #Let's build a new list of all the bad font items.
                badfonts = []
                for i in pog.fontitems:
                    try:
                        if not os.path.exists(i.paf):
                            badfonts.append(i)
                    except:
                        #Some bad voodoo 
                        sys.exit("Trouble removing %s" % i.paf)
                #Now go thru this list and remove from the pog fontlist object.
                for bi in badfonts:
                    pog.fontitems.remove(bi)
                #Now, write the fresh, lean pog to disk.
                WritePog(pog)
                print "Your pog has been purged. It's now a lean, mean, typo machine."
                print "Done."
                sys.exit()
        else:
            print "%s cannot be found. Try -l to see the names." % options.purge
        sys.exit ()
            
    #Right, now to handle the install and remove options
    if options.install:
        #Now we have to check that this *is* a valid pog
        if options.install in poglist:
            #Yup.
            #But, is it already installed? Actually ...
            #Even if it is, there might be new fonts in it,
            #so there's not much harm in simply overwriting
            #the links again.
            
            #This is pure gnu/linux for now.
            pog = FontList(options.install,POG)
            bugs = False
            if pog.empty:
                print "Pog %s is empty." % options.install
                sys.exit()
            print "Installing %s" % options.install
            for f in pog.fontitems:
                try:
                    fulldst = os.path.join(dst,os.path.basename(f.paf))
                    #Link it if it ain't already there.
                    if not os.path.exists(fulldst):  
                        os.symlink(f.paf,fulldst) #Should do the trick.
                except:
                    print "Could not find %s" % f.paf
                    bugs = True
                    #print sys.exc_info()[0]
            #Now, set the flag in the file: Re-write the entire thing...
            #Seems like overkill, but I can't find a simpler way at the moment.
            pog.installed = True
            WritePog(pog)
            if bugs: print "One or more fonts did not install."
            print "Done."
        else: #Not a valid pog
            print "Sorry, can't find %s. Try -l to see the names." % options.install
        sys.exit()

    if options.remove:
        #Is it a valid pog?
        if options.remove in poglist:
            #Only remove if the font is installed.
            pog = FontList(options.remove,POG)
            if pog.installed:
                for f in pog.fontitems:
                    #Point at the link in .fonts folder. A real mouthful...
                    #print gPC.UserFontPath(),os.path.basename(f.paf)
                    link = os.path.join(gPC.UserFontPath(),os.path.basename(f.paf))
                    if os.path.exists(link):
                        try:
                            os.unlink(link)
                        except:
                            print "Could not remove the link at %s" % link
                            #print sys.exc_info()
                pog.installed = False
                WritePog(pog)
                print "Pog %s has been removed." % options.remove
            else:
                print "Pog %s is not installed." % options.remove
        else:
            print "Sorry, can't find %s. Try -l to see the names." % options.remove
        sys.exit()

    if not args: #There are no arguments.
        #Save the config file
        gConfigure.save()
        print "Done."
        sys.exit()

    #Right, now we are down to the viewing stuff
    
    #Handle Cases A & B : fp pog and fp folder
    if len(args) == 1:
        #Only one argument, good.
        #Now, is it a folder or a pog?
        thing = args[0]
        if os.path.isdir(thing):
            #Well, it seems it's a path.
            gType = FOLDER
            gCanTick = False #No point in ticking a folder-view
            gFontlist = FontList(thing,FOLDER)
            gButtonText = "Close"
            gButtonTask = CLOSE
        else:
            #We check it's an existing Pog:
            if thing in poglist:
                #Yes, it's a pog that is there.
                gType = POG
                #You CAN tick a pog. Those ticked then can be removed.
                #BUT only if the pog is not installed. Otherwise you could
                #remove fonts from the pog, but they will still be linked
                #in the .fonts folder, leaving orphans all over the show.
                #I know every sperm is sacred, but .. orphans! The horror!
                gFontlist = FontList(thing,POG)
                if gFontlist.empty:
                    print "This pog is empty."
                    sys.exit ()
                if gFontlist.installed:
                    print "This pog is currently installed, viewing only."
                    gCanTick = False
                    gButtonTask = CLOSE
                    gButtonText = "Close"
                else:
                    gCanTick = True 
                    gTickpng = "cross.png"
                    gButtonText = "Remove selected fonts"
                    gButtonTask = REMOVE
            else:
                print "Cannot find %s" % thing
                sys.exit()
    
    if len(args) > 2:
        #The user may have chosen a pogname with spaces and no quotes
        print "Please check your arguments, there seem to be too many."
        print "If you wanted to use spaces in a pogname or folder then"
        print "please put quotes around them."
        sys.exit ()
    
    if len(args) > 1: #redundant if, but will leave it in for now.
        #At this point there are more than 1 args
            
            #Handle Case C ,D, E
            paramA = None
            paramB = None
            if os.path.isdir(args[0]):
                #Param A is a folder
                paramA = FOLDER
            else: #Param A MIGHT BE a Pog
                if args[0] in poglist:
                    paramA = POG
                else:
                    print "%s cannot be found" % args[0]
                    sys.exit ()
            if os.path.isdir(args[1]):
                #Param B is a folder
                paramB = FOLDER
            else:
                #Param B MIGHT be  a Pog
                #But it could also be a new pog, so we leave it.
                paramB = POG

            
            #Case : Error.
            if paramA == FOLDER and paramB == FOLDER:
                print "Folder to folder is really not my scene. Try -e"
                sys.exit()
                
            #Case C : fp pog pog
            if paramA == POG and paramB == POG:
                #Let's see if they are the same pog!
                if args[0] == args[1]:
                    print "Your pogs are the same! Try -e"
                    sys.exit()
                #Okay, they are different.

                #Let's FontList it.
                fontlistparamA = FontList(args[0],POG)
                if fontlistparamA.empty:
                    print "Pog %s is empty." % args[0]
                    sys.exit ()

                #Let's see if the second pog exists or if
                #we have to create it!
                if args[1] in poglist:
                    #Cool, it's there, let's get a FontList object of it
                    fontlistparamB = FontList(args[1],POG)
                else:
                    #Right, this second pog does not exist, let's make it.
                    MakePog(args[1])
                    #Now let's make a FontList of it - it will be an empty pog.
                    fontlistparamB = FontList(args[1],POG)
                
                #At this point we have two pogs in FontList objects.
                #We are viewing A and whatever is ticked in A will go into B.
                #Those fonts in A that are already in B are to be disabled.
                #So we compare all in A to B.
                #Hack 1 - make a list of pafs in B
                pafBlist = [i.paf for i in fontlistparamB.fontitems]
                for iA in fontlistparamA.fontitems:
                    if iA.paf in pafBlist:
                        iA.msg = "already in pog %s" % args[1]
                        iA.inactive = True
                del pafBlist
                
                gFontlist = fontlistparamA #Set this to the global var.
                gFontlistTarget = fontlistparamB
                gButtonText = "Take selected fonts"
                gButtonTask = COPY
                    
            #Case D : fp folder pog
            if paramA == FOLDER and paramB == POG:
                #We already know folder is legit.
                fontlistfolder = FontList(args[0], FOLDER)
                #So, let's focus on the Pog.
                #Is this an existing Pog, or do we gotta make it?
                if args[1] in poglist:
                    #Right, it's a real pog.
                    #Let's get a FontList of it.
                    fontlistpog = FontList(args[1], POG)
                else:
                    MakePog(args[1])
                    fontlistpog = FontList(args[1], POG)
                
                #At this point we have a folder and a pog in FontList objects
                #We are viewing the folder.
                #Whatever is ticked in A will be placed in B
                #If there are fonts in B already, then we disable them in A
                pafBlist = [i.paf for i in fontlistpog.fontitems]
                for iA in fontlistfolder.fontitems:
                    if iA.paf in pafBlist:
                        iA.msg = "already in pog %s" % args[1]
                        iA.inactive = True
                del pafBlist
                
                gFontlist = fontlistfolder #Make it global
                gFontlistTarget = fontlistpog
                
                gButtonText = "Take selected fonts"
                gButtonTask = COPY
                
            #Case E : An error
            if paramA == POG and paramB == FOLDER:
                print "Your arguments amuse me. Try -e"
                sys.exit()
    app = App(0)
    
    #Loaded here because it seems to need the delay from the import wx
    #The wx.Bitmap raises no error if the file cannot be located. Too bad.
    TICKMAP = wx.Bitmap(gMyThingsDir + gTickpng,type=wx.BITMAP_TYPE_PNG)

    #start!
    app.MainLoop()

if __name__ == "__main__":
    print "Please run the fp file, not this one"
    
