/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptCompilerBase;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.util.CompositeExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptCompiler
extends JavaScriptCompilerBase {
    public JavaScriptCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public JavaScriptCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        Context context = ContextFactory.getGlobal().enterContext();
        try {
            JavaScriptCompilerBase.Errors errors = new JavaScriptCompilerBase.Errors();
            for (int i = 0; i < units.length; ++i) {
                JRCompilationUnit unit = units[i];
                JavaScriptCompileData compileData = new JavaScriptCompileData();
                for (JRExpression expr : unit.getExpressions()) {
                    int id = unit.getCompileTask().getExpressionId(expr);
                    JavaScriptCompilerBase.ScriptExpressionVisitor defaultVisitor = this.defaultExpressionCreator();
                    JRExpressionUtil.visitChunks(expr, defaultVisitor);
                    String defaultExpression = defaultVisitor.getScript();
                    try {
                        context.compileString(defaultExpression, "expression", 0, null);
                    }
                    catch (EvaluatorException e) {
                        errors.addError(e);
                    }
                    if (errors.hasErrors()) continue;
                    JavaScriptCompilerBase.ScriptExpressionVisitor oldVisitor = this.oldExpressionCreator();
                    JavaScriptCompilerBase.ScriptExpressionVisitor estimatedVisitor = this.estimatedExpressionCreator();
                    JRExpressionUtil.visitChunks(expr, new CompositeExpressionChunkVisitor(oldVisitor, estimatedVisitor));
                    compileData.addExpression(id, defaultExpression, estimatedVisitor.getScript(), oldVisitor.getScript());
                }
                if (errors.hasErrors()) continue;
                unit.setCompileData(compileData);
            }
            String string = errors.errorMessage();
            return string;
        }
        finally {
            Context.exit();
        }
    }
}

