/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.ColumnText;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.TabSegment;
import net.sf.jasperreports.engine.type.RunDirectionEnum;

public class PdfTextRenderer
extends AbstractPdfTextRenderer {
    public static PdfTextRenderer getInstance() {
        return new PdfTextRenderer(DefaultJasperReportsContext.getInstance(), JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
    }

    public PdfTextRenderer(boolean ignoreMissingFont) {
        this(DefaultJasperReportsContext.getInstance(), ignoreMissingFont);
    }

    public PdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        super(jasperReportsContext, ignoreMissingFont);
    }

    public void draw() {
        TabSegment segment = (TabSegment)this.segments.get(this.segmentIndex);
        float advance = segment.layout.getAdvance();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(this.pdfExporter.getPhrase(segment.as, segment.text, this.text), (float)this.x + this.drawPosX + this.leftOffsetFactor * advance, (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset + this.lineHeight - this.drawPosY, (float)this.x + this.drawPosX + segment.layout.getAdvance() + this.rightOffsetFactor * advance, (float)(this.pdfExporter.exporterContext.getExportedReport().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - 400.0f - this.drawPosY, 0.0f, this.horizontalAlignment);
        colText.setLeading(this.lineHeight);
        colText.setRunDirection(this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 3);
        try {
            colText.go();
        }
        catch (DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

