/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.WrappingImageMapRenderable;
import net.sf.jasperreports.engine.util.WrappingRenderable;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderableUtil {
    private static final Log log = LogFactory.getLog(RenderableUtil.class);
    private JasperReportsContext jasperReportsContext;

    private RenderableUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static RenderableUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new RenderableUtil(jasperReportsContext);
    }

    public Renderable getRenderable(byte[] imageData) {
        return new JRImageRenderer(imageData);
    }

    public Renderable getRenderable(String imageLocation) throws JRException {
        return this.getRenderable(imageLocation, OnErrorTypeEnum.ERROR, true);
    }

    public Renderable getRenderable(String imageLocation, OnErrorTypeEnum onErrorType) throws JRException {
        return this.getRenderable(imageLocation, onErrorType, true);
    }

    public Renderable getRenderable(String imageLocation, OnErrorTypeEnum onErrorType, boolean isLazy) throws JRException {
        Renderable result;
        block4: {
            if (imageLocation == null) {
                return null;
            }
            if (isLazy) {
                return new JRImageRenderer(imageLocation);
            }
            try {
                byte[] data = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(imageLocation);
                result = new JRImageRenderer(data);
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("handled image error with type " + onErrorType + " for location " + imageLocation), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getRenderable(Image img, OnErrorTypeEnum onErrorType) throws JRException {
        ColorModel colorModel;
        ImageTypeEnum type = ImageTypeEnum.JPEG;
        if (img instanceof RenderedImage && (colorModel = ((RenderedImage)((Object)img)).getColorModel()).hasAlpha() && colorModel.getTransparency() != 1) {
            type = ImageTypeEnum.PNG;
        }
        return this.getRenderable(img, type, onErrorType);
    }

    public Renderable getRenderable(Image image, ImageTypeEnum imageType, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRImageLoader.getInstance(this.jasperReportsContext).loadBytesFromAwtImage(image, imageType));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getRenderable(InputStream is, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(is));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getRenderable(URL url, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(url));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType + " for URL " + url), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getRenderable(File file, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                result = new JRImageRenderer(JRLoader.loadBytes(file));
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType + " for file " + file), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getOnErrorRendererForDimension(Renderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                renderer.getDimension(this.jasperReportsContext);
                result = renderer;
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
            }
        }
        return result;
    }

    public Renderable getOnErrorRendererForImageData(Renderable renderer, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable result;
        block2: {
            try {
                renderer.getImageData(this.jasperReportsContext);
                result = renderer;
            }
            catch (Exception e) {
                result = this.handleImageError(e, onErrorType);
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)("handled image error with type " + onErrorType), (Throwable)e);
            }
        }
        return result;
    }

    protected Renderable handleImageError(Exception error, OnErrorTypeEnum onErrorType) throws JRException {
        Renderable errorRenderable;
        if (error instanceof JRException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRException)error);
        } else if (error instanceof JRRuntimeException) {
            errorRenderable = this.getOnErrorRenderer(onErrorType, (JRRuntimeException)error);
        } else {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("got unexpected image exception of type " + error.getClass().getName()), (Throwable)error);
            }
            throw new JRRuntimeException("Image error", error);
        }
        return errorRenderable;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRException e) throws JRException {
        JRImageRenderer renderer = null;
        switch (1.$SwitchMap$net$sf$jasperreports$engine$type$OnErrorTypeEnum[onErrorType.ordinal()]) {
            case 1: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public Renderable getOnErrorRenderer(OnErrorTypeEnum onErrorType, JRRuntimeException e) throws JRRuntimeException {
        JRImageRenderer renderer = null;
        switch (1.$SwitchMap$net$sf$jasperreports$engine$type$OnErrorTypeEnum[onErrorType.ordinal()]) {
            case 1: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/image-16.png");
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public static Renderable getWrappingRenderable(JRRenderable deprecatedRenderer) {
        Renderable renderable = null;
        if (deprecatedRenderer != null) {
            Renderable renderable2 = renderable = deprecatedRenderer instanceof Renderable ? (Renderable)deprecatedRenderer : null;
            if (renderable == null) {
                renderable = new WrappingRenderable(deprecatedRenderer);
            }
        }
        return renderable;
    }

    public static Renderable getWrappingRenderable(JRImageMapRenderer deprecatedRenderer) {
        Renderable renderable = null;
        if (deprecatedRenderer != null) {
            Renderable renderable2 = renderable = deprecatedRenderer instanceof Renderable ? (Renderable)((Object)deprecatedRenderer) : null;
            if (renderable == null) {
                renderable = new WrappingImageMapRenderable(deprecatedRenderer);
            }
        }
        return renderable;
    }
}

