/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggQuerySpec;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.CountingAggregationManager;
import mondrian.rolap.agg.DrillThroughQuerySpec;
import mondrian.rolap.agg.GroupingSetsList;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentArrayQuerySpec;
import mondrian.rolap.aggmatcher.AggStar;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationManager
extends RolapAggregationManager {
    private static final MondrianProperties properties = MondrianProperties.instance();
    private static final Logger LOGGER = Logger.getLogger(AggregationManager.class);
    private static AggregationManager instance;

    public static synchronized AggregationManager instance() {
        if (instance == null) {
            instance = AggregationManager.properties.EnableCacheHitCounters.get() ? new CountingAggregationManager() : new AggregationManager();
        }
        return instance;
    }

    AggregationManager() {
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public void loadAggregation(RolapStar.Measure[] measures, RolapStar.Column[] columns, AggregationKey aggregationKey, StarColumnPredicate[] predicates, RolapAggregationManager.PinSet pinnedSegments, GroupingSetsCollector groupingSetsCollector) {
        RolapStar star = measures[0].getStar();
        Aggregation aggregation = star.lookupOrCreateAggregation(aggregationKey);
        predicates = aggregation.optimizePredicates(columns, predicates);
        aggregation.load(columns, measures, predicates, pinnedSegments, groupingSetsCollector);
    }

    @Override
    public Object getCellFromCache(CellRequest request) {
        return this.getCellFromCache(request, null);
    }

    @Override
    public Object getCellFromCache(CellRequest request, RolapAggregationManager.PinSet pinSet) {
        RolapStar.Measure measure = request.getMeasure();
        AggregationKey aggregationKey = new AggregationKey(request);
        Aggregation aggregation = measure.getStar().lookupAggregation(aggregationKey);
        if (aggregation == null) {
            return null;
        }
        return aggregation.getCellValue(measure, request.getSingleValues(), pinSet);
    }

    @Override
    public String getDrillThroughSql(CellRequest request, boolean countOnly) {
        DrillThroughQuerySpec spec = new DrillThroughQuerySpec(request, countOnly);
        String sql = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(256);
            buf.append("DrillThroughSQL: ");
            buf.append(sql);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        return sql;
    }

    public String generateSql(GroupingSetsList groupingSetsList, List<StarPredicate> compoundPredicateList) {
        boolean[] rollup;
        RolapStar star;
        AggStar aggStar;
        BitKey levelBitKey = groupingSetsList.getDefaultLevelBitKey();
        BitKey measureBitKey = groupingSetsList.getDefaultMeasureBitKey();
        boolean hasCompoundPredicates = false;
        if (compoundPredicateList != null && compoundPredicateList.size() > 0) {
            hasCompoundPredicates = true;
        }
        if (MondrianProperties.instance().UseAggregates.get() && !hasCompoundPredicates && (aggStar = this.findAgg(star = groupingSetsList.getStar(), levelBitKey, measureBitKey, rollup = new boolean[]{false})) != null) {
            if (this.getLogger().isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(256);
                buf.append("MATCH: ");
                buf.append(star.getFactTable().getAlias());
                buf.append(Util.nl);
                buf.append("   foreign=");
                buf.append(levelBitKey);
                buf.append(Util.nl);
                buf.append("   measure=");
                buf.append(measureBitKey);
                buf.append(Util.nl);
                buf.append("   aggstar=");
                buf.append(aggStar.getBitKey());
                buf.append(Util.nl);
                buf.append("AggStar=");
                buf.append(aggStar.getFactTable().getName());
                buf.append(Util.nl);
                for (AggStar.Table.Column column : aggStar.getFactTable().getColumns()) {
                    buf.append("   ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                this.getLogger().debug((Object)buf.toString());
            }
            AggQuerySpec aggQuerySpec = new AggQuerySpec(aggStar, rollup[0], groupingSetsList);
            String sql = aggQuerySpec.generateSqlQuery();
            if (this.getLogger().isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(256);
                buf.append("generateSqlQuery: sql=");
                buf.append(sql);
                this.getLogger().debug((Object)buf.toString());
            }
            return sql;
        }
        if (this.getLogger().isDebugEnabled()) {
            star = groupingSetsList.getStar();
            StringBuilder buf = new StringBuilder(256);
            buf.append("NO MATCH: ");
            buf.append(star.getFactTable().getAlias());
            buf.append(Util.nl);
            buf.append("   foreign=");
            buf.append(levelBitKey);
            buf.append(Util.nl);
            buf.append("   measure=");
            buf.append(measureBitKey);
            buf.append(Util.nl);
            this.getLogger().debug((Object)buf.toString());
        }
        SegmentArrayQuerySpec spec = new SegmentArrayQuerySpec(groupingSetsList, compoundPredicateList);
        String sql = spec.generateSqlQuery();
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(256);
            buf.append("generateSqlQuery: sql=");
            buf.append(sql);
            this.getLogger().debug((Object)buf.toString());
        }
        return sql;
    }

    public AggStar findAgg(RolapStar star, BitKey levelBitKey, BitKey measureBitKey, boolean[] rollup) {
        assert (rollup != null);
        BitKey fullBitKey = levelBitKey.or(measureBitKey);
        for (AggStar aggStar : star.getAggStars()) {
            if (!aggStar.superSetMatch(fullBitKey)) continue;
            boolean isDistinct = measureBitKey.intersects(aggStar.getDistinctMeasureBitKey());
            if (!isDistinct) {
                rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
                return aggStar;
            }
            BitKey distinctMeasuresBitKey = measureBitKey.and(aggStar.getDistinctMeasureBitKey());
            BitSet distinctMeasures = distinctMeasuresBitKey.toBitSet();
            BitKey combinedLevelBitKey = null;
            int k = distinctMeasures.nextSetBit(0);
            while (k >= 0) {
                AggStar.FactTable.Measure distinctMeasure = aggStar.lookupMeasure(k);
                BitKey rollableLevelBitKey = distinctMeasure.getRollableLevelBitKey();
                combinedLevelBitKey = combinedLevelBitKey == null ? rollableLevelBitKey : combinedLevelBitKey.and(rollableLevelBitKey);
                k = distinctMeasures.nextSetBit(k + 1);
            }
            if (aggStar.hasForeignKeys()) {
                BitKey fkBitKey = aggStar.getForeignKeyBitKey().copy();
                for (AggStar.FactTable.Measure measure : aggStar.getFactTable().getMeasures()) {
                    if (!measure.isDistinct() || !measureBitKey.get(measure.getBitPosition())) continue;
                    fkBitKey.clear(measure.getBitPosition());
                }
                if (!fkBitKey.isEmpty()) continue;
            }
            if (!aggStar.select(levelBitKey, combinedLevelBitKey, measureBitKey)) continue;
            rollup[0] = !aggStar.getLevelBitKey().equals(levelBitKey);
            return aggStar;
        }
        return null;
    }

    @Override
    public RolapAggregationManager.PinSet createPinSet() {
        return new PinSetImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PinSetImpl
    extends HashSet<Segment>
    implements RolapAggregationManager.PinSet {
    }
}

