/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id
extends ExpBase
implements Cloneable {
    private final List<Segment> segments;

    public Id(Segment segment) {
        this.segments = Collections.singletonList(segment);
    }

    public Id(List<Segment> segments) {
        this.segments = segments;
    }

    @Override
    public Id clone() {
        return this;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Util.quoteMdxIdentifier(this.segments, buf);
        return buf.toString();
    }

    public String[] toStringArray() {
        String[] names = new String[this.segments.size()];
        int k = 0;
        for (Segment segment : this.segments) {
            names[k++] = segment.name;
        }
        return names;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public Segment getElement(int i) {
        return this.segments.get(i);
    }

    public Id append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new Id(newSegments);
    }

    @Override
    public Exp accept(Validator validator) {
        Exp element;
        if (this.segments.size() == 1) {
            Segment s = this.segments.get(0);
            if (s.quoting == Quoting.UNQUOTED && validator.getFunTable().isReserved(s.name)) {
                return Literal.createSymbol(s.name.toUpperCase());
            }
        }
        if ((element = Util.lookup(validator.getQuery(), this.segments, true)) == null) {
            return null;
        }
        return element.accept(validator);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(PrintWriter pw) {
        int k = 0;
        for (Segment s : this.segments) {
            if (k++ > 0) {
                pw.print(".");
            }
            switch (s.quoting) {
                case UNQUOTED: {
                    pw.print(s.name);
                    break;
                }
                case KEY: {
                    pw.print("&[" + Util.mdxEncodeString(s.name) + "]");
                    break;
                }
                case QUOTED: {
                    pw.print("[" + Util.mdxEncodeString(s.name) + "]");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quoting {
        UNQUOTED,
        QUOTED,
        KEY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Segment {
        public final String name;
        public final Quoting quoting;

        public Segment(String name, Quoting quoting) {
            this.name = name;
            this.quoting = quoting;
        }

        public String toString() {
            switch (this.quoting) {
                case UNQUOTED: 
                case QUOTED: {
                    return "[" + this.name + "]";
                }
                case KEY: {
                    return "&[" + this.name + "]";
                }
            }
            return "UNKNOWN:" + this.name;
        }

        public void toString(StringBuilder buf) {
            switch (this.quoting) {
                case UNQUOTED: {
                    buf.append(this.name);
                    return;
                }
                case QUOTED: {
                    Util.quoteMdxIdentifier(this.name, buf);
                    return;
                }
                case KEY: {
                    buf.append('&');
                    Util.quoteMdxIdentifier(this.name, buf);
                    return;
                }
            }
            throw Util.unexpected(this.quoting);
        }

        public boolean equals(Object o) {
            if (o instanceof Segment) {
                Segment that = (Segment)o;
                return that.name.equals(this.name) && that.quoting == this.quoting;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public static List<Segment> toList(String ... nameParts) {
            ArrayList<Segment> segments = new ArrayList<Segment>(nameParts.length);
            for (String namePart : nameParts) {
                segments.add(new Segment(namePart, Quoting.QUOTED));
            }
            return segments;
        }

        public boolean matches(String name) {
            switch (this.quoting) {
                case UNQUOTED: {
                    return Util.equalName(this.name, name);
                }
                case QUOTED: {
                    return this.name.equals(name);
                }
            }
            return false;
        }
    }
}

