/*
 *  scheduler.h - Routines for managing screens and scheduling them for
 *                being displayed.
 *                This file is part of the FreeLCD package.
 *  
 *  $Id: scheduler.h,v 1.3 2003/11/05 21:35:55 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */


#ifndef _SCHEDULER_H_
#define _SCHEDULER_H_ 1

#include "common/xmlt.h"
#include "common/slist.h"

typedef enum
{
  IMP_BACKGROUND, IMP_NORMAL, IMP_NOTIFICATION, IMP_ALERT
}
sch_importance;

void
sch_init (void);
        
int
sch_register_driver (void *handle, const char *output_name);

void
sch_add_screen (void *originator, const char *name, sch_importance importance, 
                int repetition, xml_node *layout);

int
sch_remove_screen (void *originator, const char *name);

void
sch_update_data (void *originator, const char *name, xml_node *data);

#endif
