/*
 *  charrenderer.h - Simple module for rendering a character-based layout
 *                   to a canvas.
 *                   This file is part of the FreeLCD package.
 *
 *  $Id: charrenderer.h,v 1.4 2004/01/16 23:38:38 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */


#ifndef _CHARRENDERER_H
#define _CHARRENDERER_H

#include "charlayout.h"
#include "charcanvas.h"
#include "common/dictionary.h"

/** Render the data, using the given layout, to the canvas. The canvas can
 * then be used by a driver to send it as good as possible to the device.
 * \param layout A layout, generated from XML data by cl_create_layout().
 * \param data The current values of the data items that need to be displayed.
 * \param canvas The canvas to render to. After this operation is finished,
 *        this canvas can be passed on to drv_process_canvas().
 */
void
cr_render (cl_layout *layout, dictionary *data, cc_canvas *canvas);


#endif
