/*
 *  cfontz-tbl.h - Character translation table and custom characters for
 *                 the CrystalFontz driver (cfontz.c)
 *                 This file is part of the FreeLCD package.
 *  
 *  $Id: cfontz-tbl.h,v 1.1 2003/11/02 21:29:33 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#define CFZ_UNDEFINED 0
#define CFZ_TABLE_END 0xFF8F

typedef struct
{
  wchar_t        index;
  unsigned char  direct;
  unsigned short custom_char1;
  unsigned short custom_char2;
}
cfz_translated;

static char custom_char[][8] = {

  /* 1: Backslash (yes, firmware rev.1 did not have a backslash) */
  
    { 0x00,   /*  ......  */
      0x10,   /*  .o....  */
      0x08,   /*  ..o...  */
      0x04,   /*  ...o..  */
      0x02,   /*  ....o.  */
      0x01,   /*  .....o  */
      0x00,   /*  ......  */
      0x00 }, /*  ......  */

  /* 2: Tilde */

    { 0x0A,   /*  ..o.o.  */
      0x14,   /*  .o.o..  */
      0x00,   /*  ......  */
      0x00,   /*  ......  */
      0x00,   /*  ......  */
      0x00,   /*  ......  */
      0x00,   /*  ......  */
      0x00 }, /*  ......  */

  /* 3: Inverted exclamation mark */

    { 0x00,   /*  ......  */
      0x04,   /*  ...o..  */
      0x00,   /*  ......  */
      0x00,   /*  ......  */
      0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x04 }, /*  ...o..  */

  /* 4: Pound sterling sign */

    { 0x06,   /*  ...oo.  */
      0x09,   /*  ..o..o  */
      0x08,   /*  ..o...  */
      0x1E,   /*  .oooo.  */
      0x08,   /*  ..o...  */
      0x08,   /*  ..o...  */
      0x1F,   /*  .ooooo  */
      0x00 }, /*  ......  */

  /* 5: Currency sign */

    { 0x00,   /*  ......  */
      0x15,   /*  .o.o.o  */
      0x0A,   /*  ..o.o.  */
      0x11,   /*  .o...o  */
      0x0A,   /*  ..o.o.  */
      0x15,   /*  .o.o.o  */
      0x00,   /*  ......  */
      0x00 }, /*  ......  */

  /* 6: Broken pipe */

    { 0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x00,   /*  ......  */
      0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x04,   /*  ...o..  */
      0x00 }, /*  ......  */

  /* 7: Paragraph sign */

    { 0x07,   /*  ...ooo  */
      0x08,   /*  ..o...  */
      0x0E,   /*  ..ooo.  */
      0x09,   /*  ..o..o  */
      0x07,   /*  ...ooo  */
      0x01,   /*  .....o  */
      0x0E,   /*  ..ooo.  */
      0x00 }, /*  ......  */

  /* 8: Copyright */

    { 0x1E,   /*  .oooo.  */
      0x21,   /*  o....o  */
      0x2D,   /*  o.oo.o  */
      0x29,   /*  o.o..o  */
      0x2D,   /*  o.oo.o  */
      0x21,   /*  o....o  */
      0x1E,   /*  .oooo.  */
      0x00 }, /*  ......  */

  /* 9: Euro currency sign */

    { 0x0E,   /*  ..ooo.  */
      0x11,   /*  .o...o  */
      0x3C,   /*  oooo..  */
      0x10,   /*  .o....  */
      0x3C,   /*  oooo..  */
      0x11,   /*  .o...o  */
      0x0E,   /*  ..ooo.  */
      0x00 }  /*  ......  */

};

static cfz_translated xtbl_v1[] = 
{

  /* Basic Latin */
    
    { 0x0020,   32,  0,  0 },
    { 0x0021,   33,  0,  0 }, 
    { 0x0022,   34,  0,  0 }, 
    { 0x0023,   35,  0,  0 }, 
    { 0x0024,   36,  0,  0 }, 
    { 0x0025,   37,  0,  0 },
    { 0x0026,   38,  0,  0 },
    { 0x0027,   39,  0,  0 },
    { 0x0028,   40,  0,  0 },
    { 0x0029,   41,  0,  0 },
    { 0x002A,   42,  0,  0 },
    { 0x002B,   43,  0,  0 },
    { 0x002C,   44,  0,  0 },
    { 0x002D,   45,  0,  0 },
    { 0x002E,   46,  0,  0 },
    { 0x002F,   47,  0,  0 },
    { 0x0030,   48,  0,  0 },
    { 0x0031,   49,  0,  0 },
    { 0x0032,   50,  0,  0 },
    { 0x0033,   51,  0,  0 },
    { 0x0034,   52,  0,  0 },
    { 0x0035,   53,  0,  0 },
    { 0x0036,   54,  0,  0 },
    { 0x0037,   55,  0,  0 },
    { 0x0038,   56,  0,  0 },
    { 0x0039,   57,  0,  0 },
    { 0x003A,   58,  0,  0 },
    { 0x003B,   59,  0,  0 },
    { 0x003C,   60,  0,  0 },
    { 0x003D,   61,  0,  0 },
    { 0x003E,   62,  0,  0 },
    { 0x003F,   63,  0,  0 },
    { 0x0040,   64,  0,  0 },
    { 0x0041,   65,  0,  0 },
    { 0x0042,   66,  0,  0 },
    { 0x0043,   67,  0,  0 },
    { 0x0044,   68,  0,  0 },
    { 0x0045,   69,  0,  0 },
    { 0x0046,   70,  0,  0 },
    { 0x0047,   71,  0,  0 },
    { 0x0048,   72,  0,  0 },
    { 0x0049,   73,  0,  0 },
    { 0x004A,   74,  0,  0 },
    { 0x004B,   75,  0,  0 },
    { 0x004C,   76,  0,  0 },
    { 0x004D,   77,  0,  0 },
    { 0x004E,   78,  0,  0 },
    { 0x004F,   79,  0,  0 },
    { 0x0050,   80,  0,  0 },
    { 0x0051,   81,  0,  0 },
    { 0x0052,   82,  0,  0 },
    { 0x0053,   83,  0,  0 },
    { 0x0054,   84,  0,  0 },
    { 0x0055,   85,  0,  0 },
    { 0x0056,   86,  0,  0 },
    { 0x0057,   87,  0,  0 },
    { 0x0058,   88,  0,  0 },
    { 0x0059,   89,  0,  0 },
    { 0x005A,   90,  0,  0 },
    { 0x005B,   91,  0,  0 },
    { 0x005C,   47,  1,  0 },
    { 0x005D,   93,  0,  0 },
    { 0x005E,   94,  0,  0 },
    { 0x005F,   95,  0,  0 },
    { 0x0060,   96,  0,  0 },
    { 0x0061,   97,  0,  0 },
    { 0x0062,   98,  0,  0 },
    { 0x0063,   99,  0,  0 },
    { 0x0064,  100,  0,  0 },
    { 0x0065,  101,  0,  0 },
    { 0x0066,  102,  0,  0 },
    { 0x0067,  103,  0,  0 },
    { 0x0068,  104,  0,  0 },
    { 0x0069,  105,  0,  0 },
    { 0x006A,  106,  0,  0 },
    { 0x006B,  107,  0,  0 },
    { 0x006C,  108,  0,  0 },
    { 0x006D,  109,  0,  0 },
    { 0x006E,  110,  0,  0 },
    { 0x006F,  111,  0,  0 },
    { 0x0070,  112,  0,  0 },
    { 0x0071,  113,  0,  0 },
    { 0x0072,  114,  0,  0 },
    { 0x0073,  115,  0,  0 },
    { 0x0074,  116,  0,  0 },
    { 0x0075,  117,  0,  0 },
    { 0x0076,  118,  0,  0 },
    { 0x0077,  119,  0,  0 },
    { 0x0078,  120,  0,  0 },
    { 0x0079,  121,  0,  0 },
    { 0x007A,  122,  0,  0 },
    { 0x007B,  123,  0,  0 },
    { 0x007C,  124,  0,  0 },
    { 0x007D,  125,  0,  0 },
    { 0x007E,  224,  2,  0 },
    { 0x007F,   32,  0,  0 },

  /* Latin-1 Supplement */

    { 0x00A0,   32,  0,  0 },
    { 0x00A1,  234,  3,  0 },
    { 0x00A2,  236,  0,  0 },
    { 0x00A3,  237,  4,  0 },
    { 0x00A4,   36,  5,  0 },
    { 0x00A5,   92,  0,  0 },
    { 0x00A6,  124,  6,  0 },
    { 0x00A7,   32,  7,  0 },
    { 0x00A9,   99,  8,  0 },
  
  /* Currency symbols */

    { 0x20A4,  237,  4,  0 },
    { 0x20AC,   69,  9,  0 },
  
    { CFZ_TABLE_END, 0,  0,  0 }
};

static cfz_translated xtbl_v2[] = 
{

  /* Basic Latin */
    
    { 0x0020,   32,  0,  0 },
    { 0x0021,   33,  0,  0 }, 
    { 0x0022,   34,  0,  0 }, 
    { 0x0023,   35,  0,  0 }, 
    { 0x0024,  162,  0,  0 }, 
    { 0x0025,   37,  0,  0 },
    { 0x0026,   38,  0,  0 },
    { 0x0027,   39,  0,  0 },
    { 0x0028,   40,  0,  0 },
    { 0x0029,   41,  0,  0 },
    { 0x002A,   42,  0,  0 },
    { 0x002B,   43,  0,  0 },
    { 0x002C,   44,  0,  0 },
    { 0x002D,   45,  0,  0 },
    { 0x002E,   46,  0,  0 },
    { 0x002F,   47,  0,  0 },
    { 0x0030,   48,  0,  0 },
    { 0x0031,   49,  0,  0 },
    { 0x0032,   50,  0,  0 },
    { 0x0033,   51,  0,  0 },
    { 0x0034,   52,  0,  0 },
    { 0x0035,   53,  0,  0 },
    { 0x0036,   54,  0,  0 },
    { 0x0037,   55,  0,  0 },
    { 0x0038,   56,  0,  0 },
    { 0x0039,   57,  0,  0 },
    { 0x003A,   58,  0,  0 },
    { 0x003B,   59,  0,  0 },
    { 0x003C,   60,  0,  0 },
    { 0x003D,   61,  0,  0 },
    { 0x003E,   62,  0,  0 },
    { 0x003F,   63,  0,  0 },
    { 0x0040,  160,  0,  0 },
    { 0x0041,   65,  0,  0 },
    { 0x0042,   66,  0,  0 },
    { 0x0043,   67,  0,  0 },
    { 0x0044,   68,  0,  0 },
    { 0x0045,   69,  0,  0 },
    { 0x0046,   70,  0,  0 },
    { 0x0047,   71,  0,  0 },
    { 0x0048,   72,  0,  0 },
    { 0x0049,   73,  0,  0 },
    { 0x004A,   74,  0,  0 },
    { 0x004B,   75,  0,  0 },
    { 0x004C,   76,  0,  0 },
    { 0x004D,   77,  0,  0 },
    { 0x004E,   78,  0,  0 },
    { 0x004F,   79,  0,  0 },
    { 0x0050,   80,  0,  0 },
    { 0x0051,   81,  0,  0 },
    { 0x0052,   82,  0,  0 },
    { 0x0053,   83,  0,  0 },
    { 0x0054,   84,  0,  0 },
    { 0x0055,   85,  0,  0 },
    { 0x0056,   86,  0,  0 },
    { 0x0057,   87,  0,  0 },
    { 0x0058,   88,  0,  0 },
    { 0x0059,   89,  0,  0 },
    { 0x005A,   90,  0,  0 },
    { 0x005B,  250,  0,  0 },
    { 0x005C,  251,  0,  0 },
    { 0x005D,  252,  0,  0 },
    { 0x005E,   13,  0,  0 },
    { 0x005F,  196,  0,  0 },

    { CFZ_TABLE_END, 0,  0,  0 }
};
