/*
 *  xmalloc.h : xmalloc() and related functions
 *              This file is part of the FreeLCD package.
 *
 *  $Id: xmalloc.h,v 1.5 2004/01/16 21:01:44 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

/** \file xmalloc.h
 * Convenient alternatives for malloc and friends.
 * These functions work just like their standard counterparts without the
 * 'x' prefix, but also check for out-of-memory conditions.
 */

#ifndef _XMALLOC_H
#define _XMALLOC_H 1

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <sys/types.h>

#if !HAVE_MALLOC
# undef malloc
void *rpl_malloc (size_t size);
#endif

#if !HAVE_REALLOC
# undef realloc
void *rpl_realloc (void *ptr, size_t size);
#endif

/** Reserve \a size bytes of memory on the heap.
 * If there is not enough free memory to reserve \a size bytes, an error
 * message is sent to the system log, and the application exits with
 * EXIT_FAILURE.
 * \param size Number of bytes to reserve.
 * \return A pointer to the reserved memory. */
void *
xmalloc (size_t size);

/** Change the size of a reserved memory block.
 * If there is not enough free memory to reserve \a size bytes, an error
 * message is sent to the system log, and the application exits with
 * EXIT_FAILURE.
 * \param ptr Pointer to the memory block that will be resized. If NULL,
 * this function works like an xmalloc() .
 * \param size New size of the memory block.
 * \return A pointer to the resized memory block. */
void *
xrealloc (void *ptr, size_t size);

/** Duplicate a string.
 * This function attempts to reserve enough memory to hold a copy of the
 * null-terminated string pointed to by \a str. If this fails, an error
 * message is sent to the system log, and the application exits with
 * EXIT_FAILURE.
 * \param str Pointer to a null-terminated string.
 * \return A pointer to a memory area that holds a copy of \a str. */
char *
xstrdup (const char *str);


#endif /* Multiple include guard */
