/*
 *  xmalloc.c - Wrappers for malloc() and realloc(). 
 *              This file is part of the FreeLCD package.
 *
 *  $Id: xmalloc.c,v 1.3 2004/01/16 21:01:44 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2002, 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "xmalloc.h"

#if !HAVE_MALLOC
void *malloc ();

void *
rpl_malloc (size_t size)
{
  if (size == 0)
    size = 1;

  return malloc (size);
}

#endif /* NOT HAVE_MALLOC */

#if !HAVE_REALLOC
void *realloc ();

void *
rpl_realloc (void *ptr, size_t size)
{
  if (size == 0)
    size = 1;

  return realloc (ptr, size);
}

#endif /* NOT HAVE_REALLOC */

#include <stdlib.h>
#include <syslog.h>
#include <string.h>


/*------------------------------------------------------------- xmalloc --*/
void *
xmalloc (size_t size)
{
  void *alloc = malloc (size);

  if (alloc == 0)
    {
      syslog (LOG_ERR, "out of memory (malloc)");
      exit (EXIT_FAILURE);
    }

  return alloc;
}

/*------------------------------------------------------------ xrealloc --*/
void *
xrealloc (void *ptr, size_t size)
{
  void *alloc;

  if (ptr == 0)
    return xmalloc (size);

  alloc = realloc (ptr, size);
  if (alloc == 0)
    {
      syslog (LOG_ERR, "out of memory (realloc)");
      exit (EXIT_FAILURE);
    }

  return alloc;
}

/*------------------------------------------------------------- xstrdup --*/
char *
xstrdup (const char *str)
{
  char *copy = strdup (str);

  if (copy == 0)
    {
      syslog (LOG_ERR, "out of memory (strdup)");
      exit (EXIT_FAILURE);
    }

  return copy;
}
