/*
 *  trace.h : Simple tracing mechanism to aid debugging.
 *            This file is part of the FreeLCD package.
 *  $Id: trace.h,v 1.1 2003/03/23 20:44:45 unicorn Exp $
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright (c) 2003, Jeroen van den Berg <unicorn@hippie.nu>
 */

#ifndef _TRACE_H_
#define _TRACE_H_ 1

#ifdef NDEBUG
# define trace(foo)
#else
# include <stdio.h>
# define trace(info) printf ("%s:%i  %s\n", __FILE__, __LINE__, info)
#endif

#endif
