/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _FILTERINBASE_H
#define _FILTERINBASE_H

#include <string>
#include <sys/types.h>

class FilterInBase
{
public:
	FilterInBase() {};
	virtual ~FilterInBase() {};

	bool Reset() { m_buf.clear(); return true; };
	bool AvailableData() { return m_buf.length(); };
	
	bool RemainingData(std::string &dataptr) { dataptr.assign(m_buf); m_buf.clear(); return true; };
	bool GetData(std::string &dataptr, size_t req);

	virtual int PutData(const char *data, size_t len) = 0;

protected:
	bool StoreData(const char *data, size_t len) { m_buf.append(data, len); return true; };
	
private:
	std::string m_buf;
};

#endif /* _FILTERINBASE_H */

