/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <zlib.h>
#include "FilterOutBase.h"
#include "ZLibOutFilter.h"

ZLibOutFilter::ZLibOutFilter(unsigned int lvl) : m_error(false)
{
  m_zstream.zalloc = Z_NULL;
	m_zstream.zfree = Z_NULL;
	m_zstream.opaque = Z_NULL;
	if(deflateInit(&m_zstream, lvl) != Z_OK)
		m_error = true;
}

ZLibOutFilter::~ZLibOutFilter()
{
	if(!m_error)
		deflateEnd(&m_zstream);
}

bool ZLibOutFilter::PutData(const char *data, size_t len)
{
	char buf[1024];
	m_zstream.next_in = (Bytef*)data;
	m_zstream.avail_in = len;
	m_zstream.next_out = (Bytef*)buf;
	m_zstream.avail_out = 1024;

	//FIXME: Make sure to test this part
	
	/* While there is still data to be compressed */
	while(m_zstream.avail_in || (!m_zstream.avail_out))
	{
		/* Reset output buffer */
		m_zstream.next_out = (Bytef*)buf;
		m_zstream.avail_out = 1024;

		/* Compress */
		if(deflate(&m_zstream, Z_NO_FLUSH) != Z_OK)
			return false;
		
		/* Store Compressed Data */
		if(1024-m_zstream.avail_out)
			if(!StoreData(buf, 1024-m_zstream.avail_out))
				return false;
	}
	
	return true;
}

bool ZLibOutFilter::Flush()
{
	char buf[1024];
	m_zstream.next_in = (Bytef*)buf;
	m_zstream.avail_in = 0;
	m_zstream.next_out = (Bytef*)buf;
	m_zstream.avail_out = 1024;

	int defret;
	while((defret = deflate(&m_zstream, Z_FINISH)) == Z_OK)
	{
		/* Store Compressed Data */
		if(1024-m_zstream.avail_out)
			if(!StoreData(buf, 1024-m_zstream.avail_out))
				return false;

		m_zstream.next_out = (Bytef*)buf;
		m_zstream.avail_out = 1024;
	}

	/* Store Compressed Data */
	if(1024-m_zstream.avail_out)
		if(!StoreData(buf, 1024-m_zstream.avail_out))
			return false;
	
	if(defret != Z_STREAM_END)
		return false;
	
	return true;
}

