/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _INDEX_H
#define _INDEX_H

#include <stdio.h>
#include "ArchiverCallbacks.h"

struct IndexFooter
{
	off_t index_size;
	unsigned char sumbuf[20];
	unsigned char magic[5];
} __attribute__((packed)); /* Pack this because it gets written to the archive */

class Index
{
public:
	Index(TArchiverWriteCallback write_callback);
	~Index();
	
	bool AddEntry(off_t index);
	bool CommitIndex();
	
private:
	FILE *tmp_index_file;
	TArchiverWriteCallback m_write;
};

#endif /* _INDEX_H */

