/*
	Copyright (C) 2005 Brian Gunlogson

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _FILTEREDMEMORYCACHE_H
#define _FILTEREDMEMORYCACHE_H

#include "FilterOutBase.h"
#include "FilterOutCacheBase.h"
#include "ArchiverCallbacks.h"
#include "sha1sum.h"

class FilteredMemoryCache : protected FilterOutCacheBase
{
public:
	FilteredMemoryCache(FilterOutBase *filter, off_t max_mem, TArchiverWriteCallback write_callback);
	~FilteredMemoryCache();

	bool PutData(const char *data, size_t len);
	bool Flush();
  
  off_t TotalBytes() {return m_total_bytes;};

  bool DataAvailable() {return ((!m_no_mem) && m_mem);};
  bool Dump();

private:
  FilterOutBase *m_filter;
  TArchiverWriteCallback m_write;

  off_t m_max_mem, m_total_bytes;
  bool m_no_mem;
  void *m_mem;
  
  bool WriteFilter(const char *buffer, unsigned int length);
  bool MemoryWrite(const char *buffer, unsigned int length);
};

#endif /* _FILTEREDMEMORYCACHE_H */

