/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2016-2017 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Fisoco.
 * 
 * Fisoco is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Fisoco is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *//////////////////////////////////////
/************
 * global.cc *
 * ~~~~~~~~~ *
 *************/

#include <iostream>
#include "../include/global.h"

bool debug_ok = false;

// This fonction is called from main.cc
void
activate_debug (bool state)
{
  debug_ok = state;
}

// Theses functions are called from cli.cc, etc..
void
debug (std::string message)
{
  if (debug_ok)
    std::cout << "\033[0;46m[DEBUG]\033[0m : " << message << std::endl;
}

void
error (std::string message)
{
  std::cout << "\033[0;41m[ERROR]\033[0m : " << message << std::endl;
}

void
goodnews (std::string message)
{
  std::cout << "\033[0;42m[YIPPEE]\033[0m : " << message << std::endl;
}

void
version ()
{
  std::cout
    << std::endl
    << "Fisoco 0.8.3-r1 (alpha) : "
    << gettext ("FInd, Sort, Order and COnvert files.") << std::endl
    << std::endl
    << "Copyright (C)2015-2016-2017 Felicien Pillot <felicien.pillot@member.fsf.org>"
    << std::endl
    << "Fisoco is free software: you can redistribute it and/or modify"
    << std::endl
    << "under the terms of the GNU General Public License." << std::endl
    << std::endl
    << "Fisoco is distributed in the hope that it will be useful," << std::endl
    << "but WITHOUT ANY WARRANTY; without even the implied warranty of"
    << std::endl
    << "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
    << std::endl
    << "GNU General Public License for more details." << std::endl
    << std::endl;
}

void
help ()
{
  std::cout
    << gettext
    ("Fisoco is a file manipulation oriented interactive program.")
    << std::endl
    << "Usage: fisoco [OPTIONS]" << std::endl
    << "Options:" << std::endl
    << "   \t--debug  \tEnable debug mode (bunch of useful messages)."
    << std::endl
    << " -h\t--help   \tDisplay this message." << std::endl
    << " -v\t--version\tDisplay copyright and version information."
    << std::endl
    << "Type 'help' in the interactive mode for more details about commands."
    << std::endl;
}
