/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 * 
 * This file is part of Fisoco.
 * 
 * Fisoco is free software: you can redistribute it and/or modify
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Fisoco is distributed in the hope that it will be useful,
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *//////////////////////////////////////
/***********
 * list.cc *
 * ~~~~~~~ *
 ***********/

#include "../include/global.h"
#include "../include/list.h"

// List functions

List::List ()
{
}

void
List::add_file (std::string dir, std::string file)
{
  std::string dbg_message = gettext ("Adding ") + file + gettext (" in list");
  debug (dbg_message);
  File *new_one;
  new_one = new File ();
  new_one->set_filename (file);
  new_one->set_filepath (dir);
  Llist.push_back (new_one);
}

void
List::del_file (int id)
{
}

std::list<std::string>
List::get_complete_names ()
{
  std::list<std::string> names;
  for (std::vector<File*>::iterator file = Llist.begin (); file != Llist.end (); file++)
    names.push_back ((*file)->get_filepath () + "/" + (*file)->get_filename ());
  return names;
}

std::vector<std::string>
List::get_infos (int id)
{
  std::vector<std::string> infos;
  if (id <= (int)Llist.size ())
    {
      File *file = Llist[(id-1)];
      std::string dbg_message = gettext ("Asking infos about the ")
	+ std::to_string (id) + gettext ("# file...");
      debug (dbg_message);
      infos.push_back (file->get_filename ());
      infos.push_back (file->get_filepath ());
      //      free (file);
    }
  else
    {
      std::string err_message = gettext ("Can't ask infos about the ") + std::to_string (id) + gettext ("# file !!");
      error (err_message);
    }
  return infos;
}

int
List::get_list_size ()
{
  return Llist.size ();
}

void
List::select (int id)
{
}

// File functions 

List::File::File ()
{
}

void
List::File::set_filename (std::string name)
{
  filename = name;
}

std::string
List::File::get_filename ()
{
  return filename;
}

void
List::File::set_filepath (std::string path)
{
  filepath = path;
}

std::string
List::File::get_filepath ()
{
  return filepath;
}


