/*
 * Decompiled with CFR 0.152.
 */
package org.natto.swingGUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.natto.Infofiles;
import org.natto.StaticTools;
import org.natto.jobDescription;
import org.natto.swingGUI.BareBonesBrowserLaunch;

public class SubmitGui
extends JFrame
implements ActionListener {
    private JMenu helpMenu;
    private JButton fileButton1;
    private JLabel f1Text;
    private JButton fileButton2;
    private JLabel f2Text;
    private File file1 = null;
    private File zipFile = null;
    private File file2 = null;
    private JTextField cLine;
    private String workDir = "";
    private HashMap infoHash = null;
    private JButton cancelButton;
    private JButton submitButton;
    private String submitTarget = null;

    public SubmitGui(String myDir, HashMap infos, String targetHost) {
        this.setTitle("Submit");
        if (targetHost != null && !targetHost.equals("")) {
            this.setTitle("Submit to " + targetHost);
            this.submitTarget = targetHost;
        }
        this.workDir = myDir;
        this.infoHash = infos;
        this.setupGUI();
        this.setDefaultCloseOperation(3);
    }

    void setupGUI() {
        this.setLayout(new BorderLayout(10, 10));
        JMenuBar menubar = new JMenuBar();
        this.helpMenu = new JMenu("Help and examples");
        menubar.add(this.helpMenu);
        this.setJMenuBar(menubar);
        myMenuListener mml = new myMenuListener();
        this.helpMenu.addMenuListener(mml);
        JPanel textAndButton1 = new JPanel();
        textAndButton1.setLayout(new BorderLayout());
        this.f1Text = new JLabel();
        String supportedExt = Infofiles.getSupportedExt(this.infoHash);
        String uploadInst = "<html>Upload file 1 (compulsory).<br/>This file can be a binary or<br/>a script with a supported type:<br/>" + supportedExt + "</html>";
        this.f1Text.setText(uploadInst);
        textAndButton1.add((Component)this.f1Text, "West");
        this.fileButton1 = new JButton();
        this.fileButton1.setText("File #1");
        this.fileButton1.setPreferredSize(new Dimension(90, 20));
        textAndButton1.add((Component)this.fileButton1, "East");
        this.fileButton1.addActionListener(this);
        this.getContentPane().add((Component)textAndButton1, "First");
        JPanel textAndButton2 = new JPanel();
        textAndButton2.setLayout(new BorderLayout());
        this.f2Text = new JLabel();
        this.f2Text.setText("<html>Upload file 2 (optional).<br/>This file can be a data file for<br/>file 1. If you need more than one<br/>data files, please zip them and<br/>upload the zip file.<br/>If your data files are already<br/>in this directory, you do not need<br/>to upload them.</html>");
        textAndButton2.add((Component)this.f2Text, "West");
        this.fileButton2 = new JButton();
        this.fileButton2.setPreferredSize(new Dimension(90, 20));
        this.fileButton2.setText("File #2");
        textAndButton2.add((Component)this.fileButton2, "East");
        this.fileButton2.addActionListener(this);
        this.getContentPane().add((Component)textAndButton2, "Center");
        JPanel clAndButtons = new JPanel();
        clAndButtons.setLayout(new BorderLayout());
        JPanel clPanel = new JPanel();
        clPanel.setLayout(new BorderLayout());
        JLabel clText = new JLabel();
        clText.setText("Command line extra arguments (optional)");
        clPanel.add((Component)clText, "North");
        this.cLine = new JTextField(30);
        this.cLine.setEditable(true);
        clPanel.add((Component)this.cLine, "South");
        clAndButtons.add((Component)clPanel, "North");
        JPanel scPanel = new JPanel();
        this.submitButton = new JButton();
        this.submitButton.setText("Submit");
        this.submitButton.setEnabled(false);
        scPanel.add((Component)this.submitButton, "East");
        this.submitButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        scPanel.add((Component)this.cancelButton, "West");
        this.cancelButton.addActionListener(this);
        clAndButtons.add((Component)scPanel, "South");
        this.getContentPane().add((Component)clAndButtons, "Last");
        this.pack();
        this.setVisible(true);
        this.setResizable(true);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc;
        int rVal;
        if (e.getSource() == this.helpMenu) {
            System.out.println("help");
        }
        if (e.getSource() == this.submitButton) {
            String cLineExtra = "";
            if (this.cLine != null) {
                cLineExtra = this.cLine.getText();
            }
            this.submitJob(cLineExtra, this.submitTarget);
        }
        if ((e.getSource() == this.fileButton1 || e.getSource() == this.fileButton2) && (rVal = (fc = new JFileChooser(this.workDir)).showOpenDialog(this)) == 0) {
            File selFile = fc.getSelectedFile();
            String fullFname = selFile.getAbsolutePath();
            if (e.getSource() == this.fileButton1) {
                String compLaint = this.fileComplain(selFile);
                if (!"".equals(compLaint)) {
                    JOptionPane.showMessageDialog(null, "Sorry, unsupported extension.");
                    return;
                }
                this.file1 = selFile;
                if (fullFname.toLowerCase().endsWith(".zip")) {
                    String inZipNm = this.getFileSupportedInZip(fullFname);
                    this.zipFile = selFile;
                    this.file1 = new File(this.workDir + "/" + inZipNm);
                }
            } else {
                this.file2 = selFile;
            }
            StaticTools.copyFileIfNeeded(selFile, this.workDir);
            this.submitButton.setEnabled(true);
        }
        if (e.getSource() == this.cancelButton) {
            System.out.println("cancel");
            this.setVisible(false);
            this.dispose();
        }
    }

    String fileComplain(File myFile) {
        String fullName;
        if (StaticTools.fileIsELF(myFile)) {
            return "";
        }
        String fname = myFile.getName();
        String myExt = StaticTools.getFileExt(fname);
        if (myExt == null) {
            return "File has no extension.";
        }
        if (".zip".equals(myExt.toLowerCase()) && !this.getFileSupportedInZip(fullName = myFile.getAbsolutePath()).equals("")) {
            return "";
        }
        String myPrg = Infofiles.getPrgForExt(myExt, this.infoHash);
        if (myPrg == null) {
            return "Could not find the program for extension " + myExt;
        }
        return "";
    }

    String getFileSupportedInZip(String fullZipName) {
        File myFile = new File(fullZipName);
        String shortName = myFile.getName();
        String[] filesInZip = StaticTools.unZip(fullZipName, true);
        String allExtsStr = Infofiles.getSupportedExt(this.infoHash);
        String[] allExts = allExtsStr.split(" ");
        String myNoExt = shortName.substring(0, shortName.length() - 4);
        for (int i = 0; i < filesInZip.length; ++i) {
            String inZip = filesInZip[i];
            for (int j = 0; j < allExts.length; ++j) {
                String candFn = myNoExt + allExts[j];
                if (!candFn.equals(inZip)) continue;
                return inZip;
            }
        }
        return "";
    }

    void submitJob(String clineExtra, String targetHost) {
        jobDescription myJd = new jobDescription(this.workDir);
        String diags = myJd.writeJobDescription(this.file1, this.file2, this.zipFile, this.infoHash, clineExtra, targetHost);
        JOptionPane.showMessageDialog(null, diags);
        this.setVisible(false);
        this.dispose();
    }

    public static void nomain(String[] args) {
        String myDir = System.getProperty("user.dir");
        HashMap myHm = Infofiles.checkInfoFiles(myDir, "", 300);
        new SubmitGui(myDir, myHm, "");
    }

    class myMenuListener
    implements MenuListener {
        myMenuListener() {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            try {
                String toPage = "http://www.nongnu.org/executor/";
                BareBonesBrowserLaunch.openURL(toPage);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void menuDeselected(MenuEvent e) {
        }
    }
}

