/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.natto.GenGui;
import org.natto.StaticTools;
import org.natto.Task;
import org.natto.jobDescription;
import org.natto.swingGUI.DirPresenter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TaskExecution {
    static HashMap jobAndLine = new HashMap();

    public static Thread execCommand(final String dir, final String cmd, final String fileN, final String args, final String baseOutput, final int interval, final String myId) {
        Thread processThread = new Thread(new Runnable(){

            private String getLineFromFileThenDelete(File fileToRead) {
                String retMe = "\n";
                try {
                    if (fileToRead.exists() && fileToRead.length() > 0L) {
                        FileInputStream fstream = new FileInputStream(fileToRead);
                        DataInputStream in = new DataInputStream(fstream);
                        BufferedReader br = new BufferedReader(new InputStreamReader(in));
                        retMe = br.readLine();
                        fileToRead.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return retMe;
            }

            public void run() {
                Process process = null;
                String osName = System.getProperty("os.name");
                String fullCmd = cmd + " " + fileN;
                if (cmd.startsWith("./")) {
                    String chRes = StaticTools.execGet("chmod +x " + dir + "/" + fullCmd, true);
                    fullCmd = cmd;
                }
                String cmArgs = "";
                if (args != null) {
                    cmArgs = " " + args;
                }
                String[] command = new String[]{"bash", "-c", fullCmd + cmArgs};
                if (osName.startsWith("Windows")) {
                    String[] winc = new String[]{"CMD", "/Q", "/C", fullCmd + cmArgs};
                    command = winc;
                }
                System.out.println("execCommand " + fullCmd + cmArgs);
                if (fullCmd.startsWith("INTERNAL")) {
                    TaskExecution.handleInternal(cmd, args, dir, baseOutput, myId);
                    String runFileName = dir + "/" + baseOutput + ".run";
                    Task finishedTask = new Task(runFileName);
                    finishedTask.finishTask(0);
                    return;
                }
                ProcessBuilder probuilder = new ProcessBuilder(command);
                String toFileName = dir + "/" + baseOutput + ".to";
                File toFile = new File(toFileName);
                probuilder.directory(new File(dir));
                try {
                    String line;
                    process = probuilder.start();
                    OutputStream toProcess = process.getOutputStream();
                    DataOutputStream dos = new DataOutputStream(toProcess);
                    InputStream is = process.getInputStream();
                    InputStream es = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    InputStreamReader esr = new InputStreamReader(es);
                    BufferedReader br = new BufferedReader(isr);
                    BufferedReader bre = new BufferedReader(esr);
                    BufferedWriter fout = new BufferedWriter(new FileWriter(new File(dir + "/" + baseOutput + ".stdout")));
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("ASK")) {
                            long epoch = StaticTools.getEpoch();
                            line = line + " " + epoch;
                            fout.write(line + "\n");
                            fout.flush();
                            System.out.println("WAITING FOR ANSWER " + line);
                            boolean noAnswer = true;
                            while (noAnswer) {
                                Thread.sleep(interval);
                                String reply = this.getLineFromFileThenDelete(toFile);
                                if (reply.equals("") || reply.equals("\n")) continue;
                                dos.writeUTF(reply + "\n");
                                dos.flush();
                                noAnswer = false;
                            }
                            continue;
                        }
                        fout.write(line + "\n");
                        fout.flush();
                    }
                    fout.close();
                    BufferedWriter ferr = new BufferedWriter(new FileWriter(new File(dir + "/" + baseOutput + ".stderr")));
                    while ((line = bre.readLine()) != null) {
                        ferr.write(line + "\n");
                    }
                    ferr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean goOn = true;
                int retVal = Integer.MIN_VALUE;
                while (goOn) {
                    if (process == null) {
                        goOn = false;
                        retVal = -100;
                    }
                    try {
                        retVal = process.exitValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (retVal > Integer.MIN_VALUE) {
                        goOn = false;
                        String runFileName = dir + "/" + baseOutput + ".run";
                        Task finishedTask = new Task(runFileName);
                        finishedTask.finishTask(retVal);
                        continue;
                    }
                    try {
                        Thread.sleep(interval);
                    }
                    catch (Exception e) {}
                }
            }
        });
        processThread.start();
        return processThread;
    }

    private static void handleInternal(String cmd, String args, String dir, String baseOutput, String myId) {
        FileWriter fwr;
        File outFile = new File(dir + "/" + baseOutput + ".stdout");
        if (cmd.equals("INTERNAL:XMLLS")) {
            if (args == null || "$HOME".equals(args)) {
                args = System.getProperty("user.home");
            }
            File argDir = new File(args);
            Object[] fileNames = argDir.list();
            try {
                fwr = new FileWriter(outFile);
                fwr.write("<executor host=\"" + myId + "\">\n<dirlist directory=\"" + argDir + "\">\n");
                Arrays.sort(fileNames);
                for (int i = 0; i < fileNames.length; ++i) {
                    if (((String)fileNames[i]).startsWith(".")) continue;
                    File tmpFile = new File(argDir + "/" + (String)fileNames[i]);
                    String fileType = "file";
                    if (tmpFile.isDirectory()) {
                        fileType = "directory";
                    }
                    fwr.write("<entry type=\"" + fileType + "\">" + (String)fileNames[i] + "</entry>\n");
                }
                fwr.write("</dirlist>\n</executor>\n");
                fwr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (cmd.equals("INTERNAL:FILECOPY")) {
            try {
                String errMsg = "";
                int latterQpos = args.indexOf("\" ");
                if (latterQpos > 2) {
                    String copyThis = args.substring(1, latterQpos).trim();
                    String toThis = args.substring(latterQpos + 1).trim();
                    if (".".equals(toThis)) {
                        toThis = dir;
                    }
                    System.out.println("Copying " + copyThis + " to " + toThis);
                    File fileForCopy = new File(copyThis);
                    boolean copyOK = StaticTools.copyFileIfNeeded(fileForCopy, toThis);
                    if (!copyOK) {
                        errMsg = "Copy failed.";
                    }
                } else {
                    errMsg = "Arguments are invalid: " + args;
                }
                if ("".equals(errMsg)) {
                    errMsg = "File copy OK";
                }
                fwr = new FileWriter(outFile);
                fwr.write(errMsg + "\n");
                fwr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void notifyAboutSubmittedJobs(String myId, int interval, String myDir, String fileName, GenGui myGui, boolean secOn) {
        Properties jobProp;
        String submitHost;
        int lastAskLine = 0;
        String noExt = fileName.replace(".run", "");
        Task ohJob = new Task(myDir + "/" + fileName);
        int ohJobStat = ohJob.getStatus();
        if (ohJobStat == Task.NOTIFIED) {
            return;
        }
        String jdFileName = myDir + "/" + noExt + ".jd";
        if (secOn) {
            jdFileName = jdFileName + ".asc";
        }
        if (!myId.equalsIgnoreCase(submitHost = (String)(jobProp = StaticTools.getPropertiesFromFile(jdFileName)).get("clientid"))) {
            return;
        }
        String fullOutFn = myDir + "/" + noExt + ".stdout";
        String fullErrFn = myDir + "/" + noExt + ".stderr";
        String fullDiscFn = myDir + "/" + noExt + ".to";
        File outFile = new File(fullOutFn);
        int exitInFile = 0;
        if (ohJobStat == Task.DONE) {
            try {
                exitInFile = ohJob.getExitCode();
                Thread.sleep(interval);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (outFile.exists()) {
                String curLine;
                FileInputStream fstream = new FileInputStream(outFile);
                String lastLine = "";
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                int lineNo = 0;
                while ((curLine = br.readLine()) != null) {
                    if (!curLine.startsWith("TELL ") && !curLine.startsWith("ASK ")) continue;
                    lastLine = curLine;
                    ++lineNo;
                }
                in.close();
                if (lastLine.startsWith("TELL ")) {
                    myGui.doTell(lastLine);
                }
                if (lastLine.startsWith("ASK ")) {
                    if (jobAndLine.containsKey(fullOutFn)) {
                        lastAskLine = (Integer)jobAndLine.get(fullOutFn);
                    }
                    if (lineNo != lastAskLine) {
                        lastLine = lastLine.substring(0, lastLine.lastIndexOf(" "));
                        String reply = myGui.doAsk(lastLine);
                        File toProcFile = new File(fullDiscFn);
                        FileWriter toProcFw = new FileWriter(toProcFile);
                        toProcFw.write(reply + "\n");
                        toProcFw.close();
                        jobAndLine.put(fullOutFn, lineNo);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ohJobStat == Task.DONE) {
            String myOut = StaticTools.getFileContent(fullOutFn, 1);
            String myErr = StaticTools.getFileContent(fullErrFn, 1);
            try {
                ohJob.setStatus(Task.NOTIFIED);
                System.out.println("My job has finished with code " + exitInFile);
                String myNotif = "Stdout starts with " + myOut;
                if (exitInFile > 0) {
                    myNotif = "Stderr starts with " + myErr;
                }
                if (myOut.startsWith("<executor ")) {
                    myOut = StaticTools.getFileContent(fullOutFn);
                    RenderedDirlist myRdl = TaskExecution.XMLRenderDirlist(myOut);
                    String[] toShow = myRdl.getEntries();
                    boolean[] myDirs = myRdl.getDirData();
                    String dirListed = myRdl.getDirName();
                    String execHost = myRdl.getHostName();
                    DirPresenter dirPres = new DirPresenter(toShow, myDirs);
                    int selInd = dirPres.getselectedIndex();
                    if (selInd > -1) {
                        String selItem = toShow[selInd];
                        String nextItem = dirListed + "/" + selItem;
                        String osName = System.getProperty("os.name");
                        if (osName.startsWith("Windows")) {
                            nextItem = dirListed + "\\" + selItem;
                            nextItem = nextItem.replace("\\", "\\\\");
                        }
                        jobDescription newJd = new jobDescription(myDir);
                        if (myDirs[selInd]) {
                            newJd.writeInternalCommand("XMLLS", nextItem, execHost);
                        } else {
                            int reply = JOptionPane.showConfirmDialog(null, "Do you want to copy file\n" + selItem + " to directory\n" + myDir + "?", null, 0);
                            if (reply == 0) {
                                newJd.writeInternalCommand("FILECOPY", "\"" + nextItem + "\" .", execHost);
                            }
                        }
                    }
                    ohJob.eraseCompletely();
                } else {
                    myGui.showJobFinishDiag(myNotif, myDir, exitInFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static RenderedDirlist XMLRenderDirlist(String xmlSource) {
        if (xmlSource == null) {
            return null;
        }
        if (!xmlSource.contains("<dirlist")) {
            return null;
        }
        boolean[] isDir = null;
        String[] fileNames = null;
        String execHost = "";
        String dirName = "";
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            int dirPos;
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlSource));
            Document doc = dBuilder.parse(is);
            int hostPos = xmlSource.indexOf(" host=");
            if (hostPos > 0) {
                int endPos = xmlSource.indexOf("\"", hostPos + 8);
                execHost = xmlSource.substring(hostPos + 7, endPos);
            }
            if ((dirPos = xmlSource.indexOf(" directory=")) > 0) {
                int endPos = xmlSource.indexOf("\"", dirPos + 13);
                dirName = xmlSource.substring(dirPos + 12, endPos);
            }
            NodeList nList = doc.getElementsByTagName("entry");
            isDir = new boolean[nList.getLength()];
            fileNames = new String[nList.getLength()];
            for (int i = 0; i < nList.getLength(); ++i) {
                boolean thisIsDir;
                String eName = nList.item(i).getTextContent();
                String eType = ((Element)nList.item(i)).getAttribute("type");
                isDir[i] = thisIsDir = eType.equals("directory");
                fileNames[i] = eName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RenderedDirlist rdl = new RenderedDirlist(fileNames, isDir, dirName, execHost);
        return rdl;
    }

    static class RenderedDirlist {
        private String[] dirEntries;
        private boolean[] isDir;
        private String execHost;
        private String dirName;

        public RenderedDirlist(String[] names, boolean[] theseAreDirs, String dirN, String hostN) {
            this.dirEntries = names;
            this.isDir = theseAreDirs;
            this.dirName = dirN;
            this.execHost = hostN;
        }

        String[] getEntries() {
            return this.dirEntries;
        }

        boolean[] getDirData() {
            return this.isDir;
        }

        String getDirName() {
            return this.dirName;
        }

        String getHostName() {
            return this.execHost;
        }
    }
}

