/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    int labelHandle;
    int imageHandle;
    int buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;
    String toolTipText;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return GTK.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return GTK.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return GTK.gtk_tree_view_column_get_width(this.handle);
    }

    @Override
    int gtk_clicked(int widget) {
        boolean doubleClick = false;
        boolean postEvent = true;
        int eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
            GDK.gdk_event_free(eventPtr);
            switch (gdkEvent.type) {
                case 7: {
                    int clickTime = this.display.getDoubleClickTime();
                    int eventTime = gdkEvent.time;
                    int eventButton = gdkEvent.button;
                    if (this.lastButton == eventButton && this.lastTime != 0 && Math.abs(this.lastTime - eventTime) <= clickTime) {
                        doubleClick = true;
                    }
                    this.lastTime = eventTime == 0 ? 1 : eventTime;
                    this.lastButton = eventButton;
                    break;
                }
            }
        }
        if (postEvent) {
            this.sendSelectionEvent(doubleClick ? 14 : 13);
        }
        return 0;
    }

    @Override
    int gtk_event_after(int widget, int gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
        }
        return 0;
    }

    @Override
    int gtk_mnemonic_activate(int widget, int arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    @Override
    int gtk_size_allocate(int widget, int allocation) {
        this.useFixedWidth = false;
        GtkAllocation widgetAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, widgetAllocation);
        boolean minimumResizeSignal = widgetAllocation.width == 1 && widgetAllocation.height == 1;
        boolean movingSignal = widgetAllocation.x == 0 && widgetAllocation.y == 0;
        int x = widgetAllocation.x;
        int width = widgetAllocation.width;
        if (x != this.lastX && !movingSignal) {
            this.lastX = x;
            this.sendEvent(10);
        }
        if (width != this.lastWidth && !minimumResizeSignal) {
            this.lastWidth = width;
            this.sendEvent(11);
        }
        return 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.buttonHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        if (this.buttonHandle != 0) {
            GtkRequisition requisition = new GtkRequisition();
            if (GTK.GTK3) {
                GTK.gtk_widget_show(this.buttonHandle);
                this.gtk_widget_get_preferred_size(this.buttonHandle, requisition);
                GTK.gtk_widget_hide(this.buttonHandle);
            } else {
                this.gtk_widget_get_preferred_size(this.buttonHandle, requisition);
            }
            width = requisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            boolean calcWidth = false;
            Rectangle itemBounds = null;
            int tableHeight = 0;
            if (this.parent.isVisible()) {
                Rectangle tableBounds = this.parent.getBounds();
                tableHeight = tableBounds.height - this.parent.getHeaderHeight();
            } else {
                calcWidth = true;
            }
            for (int i = 0; i < this.parent.items.length; ++i) {
                TableItem item = this.parent.items[i];
                if (itemBounds == null && item != null) {
                    itemBounds = item.getBounds();
                }
                boolean isVisible = false;
                if (!calcWidth && itemBounds != null) {
                    int itemTopBound = itemBounds.y + itemBounds.height * i + i;
                    int itemBottomBound = itemTopBound + itemBounds.height;
                    boolean bl = isVisible = itemTopBound > 0 && itemBottomBound < tableHeight;
                }
                if (item == null || !item.cached || !isVisible && !calcWidth) continue;
                width = Math.max(width, this.parent.calculateWidth(this.handle, item.handle));
            }
        } else {
            int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.parent.modelHandle, iter)) {
                do {
                    width = Math.max(width, this.parent.calculateWidth(this.handle, iter));
                } while (GTK.gtk_tree_model_iter_next(this.parent.modelHandle, iter));
            }
            OS.g_free(iter);
        }
        this.setWidthInPixels(width);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.buttonHandle = 0;
        this.handle = 0;
        this.modelIndex = -1;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, index == 0, this.style);
    }

    void setFontDescription(int font) {
        this.setFontDescription(this.labelHandle, font);
        this.setFontDescription(this.imageHandle, font);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList headerImageList = this.parent.headerImageList;
            if (headerImageList == null) {
                headerImageList = this.parent.headerImageList = new ImageList();
            }
            if ((imageIndex = headerImageList.indexOf(image)) == -1) {
                imageIndex = headerImageList.add(image);
            }
            int pixbuf = headerImageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_resizable(this.handle, resizable);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        GTK.gtk_tree_view_column_set_reorderable(this.handle, moveable);
    }

    @Override
    void setOrientation(boolean create) {
        if (!((this.parent.style & 0x4000000) == 0 && create || this.buttonHandle == 0)) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.buttonHandle, dir);
            GTK.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, dir);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        } else {
            GTK.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        this.setToolTipText(shell, string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        shell.setToolTipText(this.buttonHandle, newString);
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(width));
    }

    void setWidthInPixels(int width) {
        int windowList;
        int window;
        this.checkWidget();
        if (width < 0) {
            return;
        }
        if (width == this.lastWidth) {
            return;
        }
        if (width > 0) {
            this.useFixedWidth = true;
            GTK.gtk_tree_view_column_set_fixed_width(this.handle, width);
        }
        if (width != 0) {
            GTK.gtk_widget_realize(this.parent.handle);
        }
        GTK.gtk_tree_view_column_set_visible(this.handle, width != 0);
        this.lastWidth = width;
        if (width != 0 && this.buttonHandle != 0 && (window = GTK.gtk_widget_get_parent_window(this.buttonHandle)) != 0 && (windowList = GDK.gdk_window_get_children(window)) != 0) {
            int windows = windowList;
            int[] userData = new int[1];
            while (windows != 0) {
                int child = OS.g_list_data(windows);
                GDK.gdk_window_get_user_data(child, userData);
                if (userData[0] == this.buttonHandle) {
                    GDK.gdk_window_lower(child);
                    break;
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
        this.sendEvent(11);
    }
}

