/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime.property;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.glassfish.jaxb.core.v2.model.core.PropertyKind;
import org.glassfish.jaxb.core.v2.model.core.TypeRef;
import org.glassfish.jaxb.core.v2.runtime.RuntimeUtil;
import org.glassfish.jaxb.runtime.api.AccessorException;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeElementPropertyInfo;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeTypeRef;
import org.glassfish.jaxb.runtime.v2.runtime.JAXBContextImpl;
import org.glassfish.jaxb.runtime.v2.runtime.JaxBeanInfo;
import org.glassfish.jaxb.runtime.v2.runtime.Name;
import org.glassfish.jaxb.runtime.v2.runtime.Transducer;
import org.glassfish.jaxb.runtime.v2.runtime.XMLSerializer;
import org.glassfish.jaxb.runtime.v2.runtime.property.ArrayERProperty;
import org.glassfish.jaxb.runtime.v2.runtime.property.PropertyFactory;
import org.glassfish.jaxb.runtime.v2.runtime.property.TagAndType;
import org.glassfish.jaxb.runtime.v2.runtime.property.UnmarshallerChain;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Accessor;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.ListIterator;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.Lister;
import org.glassfish.jaxb.runtime.v2.runtime.reflect.NullSafeAccessor;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.ChildLoader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.DefaultValueLoaderDecorator;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.Loader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.TextLoader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.XsiNilLoader;
import org.glassfish.jaxb.runtime.v2.util.QNameMap;
import org.xml.sax.SAXException;

abstract class ArrayElementProperty<BeanT, ListT, ItemT>
extends ArrayERProperty<BeanT, ListT, ItemT> {
    private final Map<Class, TagAndType> typeMap = new HashMap<Class, TagAndType>();
    private Map<TypeRef<Type, Class>, JaxBeanInfo> refs = new HashMap<TypeRef<Type, Class>, JaxBeanInfo>();
    protected RuntimeElementPropertyInfo prop;
    private final Name nillableTagName;

    protected ArrayElementProperty(JAXBContextImpl grammar, RuntimeElementPropertyInfo prop) {
        super(grammar, prop, prop.getXmlName(), prop.isCollectionNillable());
        this.prop = prop;
        List<? extends RuntimeTypeRef> types = prop.getTypes();
        Name n2 = null;
        for (RuntimeTypeRef runtimeTypeRef : types) {
            Class type2 = (Class)runtimeTypeRef.getTarget().getType();
            if (type2.isPrimitive()) {
                type2 = RuntimeUtil.primitiveToBox.get(type2);
            }
            JaxBeanInfo beanInfo = grammar.getOrCreate(runtimeTypeRef.getTarget());
            TagAndType tt = new TagAndType(grammar.nameBuilder.createElementName(runtimeTypeRef.getTagName()), beanInfo);
            this.typeMap.put(type2, tt);
            this.refs.put(runtimeTypeRef, beanInfo);
            if (!runtimeTypeRef.isNillable() || n2 != null) continue;
            n2 = tt.tagName;
        }
        this.nillableTagName = n2;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.refs = null;
        this.prop = null;
    }

    @Override
    protected void serializeListBody(BeanT beanT, XMLSerializer w2, ListT list2) throws IOException, XMLStreamException, SAXException, AccessorException {
        ListIterator itr = this.lister.iterator(list2, w2);
        boolean isIdref = itr instanceof Lister.IDREFSIterator;
        while (itr.hasNext()) {
            try {
                Object item2 = itr.next();
                if (item2 != null) {
                    Class<?> itemType = item2.getClass();
                    if (isIdref) {
                        itemType = ((Lister.IDREFSIterator)itr).last().getClass();
                    }
                    TagAndType tt = this.typeMap.get(itemType);
                    while (tt == null && itemType != null) {
                        itemType = itemType.getSuperclass();
                        tt = this.typeMap.get(itemType);
                    }
                    if (tt == null) {
                        w2.startElement(this.typeMap.values().iterator().next().tagName, null);
                        w2.childAsXsiType(item2, this.fieldName, w2.grammar.getBeanInfo(Object.class), false);
                    } else {
                        w2.startElement(tt.tagName, null);
                        this.serializeItem(tt.beanInfo, item2, w2);
                    }
                    w2.endElement();
                    continue;
                }
                if (this.nillableTagName == null) continue;
                w2.startElement(this.nillableTagName, null);
                w2.writeXsiNilTrue();
                w2.endElement();
            }
            catch (JAXBException e2) {
                w2.reportError(this.fieldName, e2);
            }
        }
    }

    protected abstract void serializeItem(JaxBeanInfo var1, ItemT var2, XMLSerializer var3) throws SAXException, AccessorException, IOException, XMLStreamException;

    @Override
    public void createBodyUnmarshaller(UnmarshallerChain chain, QNameMap<ChildLoader> loaders) {
        int offset = chain.allocateOffset();
        ArrayERProperty.ReceiverImpl recv = new ArrayERProperty.ReceiverImpl(this, offset);
        for (RuntimeTypeRef runtimeTypeRef : this.prop.getTypes()) {
            Name tagName = chain.context.nameBuilder.createElementName(runtimeTypeRef.getTagName());
            Loader item2 = this.createItemUnmarshaller(chain, runtimeTypeRef);
            if (runtimeTypeRef.isNillable() || chain.context.allNillable) {
                item2 = new XsiNilLoader.Array(item2);
            }
            if (runtimeTypeRef.getDefaultValue() != null) {
                item2 = new DefaultValueLoaderDecorator(item2, runtimeTypeRef.getDefaultValue());
            }
            loaders.put(tagName, new ChildLoader(item2, recv));
        }
    }

    @Override
    public final PropertyKind getKind() {
        return PropertyKind.ELEMENT;
    }

    private Loader createItemUnmarshaller(UnmarshallerChain chain, RuntimeTypeRef typeRef) {
        if (PropertyFactory.isLeaf(typeRef.getSource())) {
            Transducer xducer = typeRef.getTransducer();
            return new TextLoader(xducer);
        }
        return this.refs.get(typeRef).getLoader(chain.context, true);
    }

    @Override
    public Accessor getElementPropertyAccessor(String nsUri, String localName) {
        if (this.wrapperTagName != null) {
            if (this.wrapperTagName.equals(nsUri, localName)) {
                return this.acc;
            }
        } else {
            for (TagAndType tt : this.typeMap.values()) {
                if (!tt.tagName.equals(nsUri, localName)) continue;
                return new NullSafeAccessor(this.acc, this.lister);
            }
        }
        return null;
    }
}

