/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CLayoutData;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

class ViewFormLayout
extends Layout {
    ViewFormLayout() {
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        ViewForm form2 = (ViewForm)composite;
        Control left2 = form2.topLeft;
        Control center2 = form2.topCenter;
        Control right2 = form2.topRight;
        Control content = form2.content;
        Point leftSize = new Point(0, 0);
        if (left2 != null) {
            leftSize = this.computeChildSize(left2, -1, -1, flushCache);
        }
        Point centerSize = new Point(0, 0);
        if (center2 != null) {
            centerSize = this.computeChildSize(center2, -1, -1, flushCache);
        }
        Point rightSize = new Point(0, 0);
        if (right2 != null) {
            rightSize = this.computeChildSize(right2, -1, -1, flushCache);
        }
        Point size = new Point(0, 0);
        if (form2.separateTopCenter || wHint != -1 && leftSize.x + centerSize.x + rightSize.x > wHint) {
            size.x = leftSize.x + rightSize.x;
            if (leftSize.x > 0 && rightSize.x > 0) {
                size.x += form2.horizontalSpacing;
            }
            size.x = Math.max(centerSize.x, size.x);
            size.y = Math.max(leftSize.y, rightSize.y);
            if (center2 != null) {
                size.y += centerSize.y;
                if (left2 != null || right2 != null) {
                    size.y += form2.verticalSpacing;
                }
            }
        } else {
            size.x = leftSize.x + centerSize.x + rightSize.x;
            int count = -1;
            if (leftSize.x > 0) {
                ++count;
            }
            if (centerSize.x > 0) {
                ++count;
            }
            if (rightSize.x > 0) {
                ++count;
            }
            if (count > 0) {
                size.x += count * form2.horizontalSpacing;
            }
            size.y = Math.max(leftSize.y, Math.max(centerSize.y, rightSize.y));
        }
        if (content != null) {
            if (left2 != null || right2 != null || center2 != null) {
                ++size.y;
            }
            Point contentSize = new Point(0, 0);
            contentSize = this.computeChildSize(content, -1, -1, flushCache);
            size.x = Math.max(size.x, contentSize.x);
            size.y += contentSize.y;
            if (size.y > contentSize.y) {
                size.y += form2.verticalSpacing;
            }
        }
        size.x += 2 * form2.marginWidth;
        size.y += 2 * form2.marginHeight;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    Point computeChildSize(Control control, int wHint, int hHint, boolean flushCache) {
        Object data2 = control.getLayoutData();
        if (data2 == null || !(data2 instanceof CLayoutData)) {
            data2 = new CLayoutData();
            control.setLayoutData(data2);
        }
        return ((CLayoutData)data2).computeSize(control, wHint, hHint, flushCache);
    }

    int computeTrim(Control c2) {
        if (c2 instanceof Scrollable) {
            Rectangle rect = ((Scrollable)c2).computeTrim(0, 0, 0, 0);
            return rect.width;
        }
        return c2.getBorderWidth() * 2;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null && data2 instanceof CLayoutData) {
            ((CLayoutData)data2).flushCache();
        }
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        int w2;
        int topHeight;
        ViewForm form2 = (ViewForm)composite;
        Control left2 = form2.topLeft;
        Control center2 = form2.topCenter;
        Control right2 = form2.topRight;
        Control content = form2.content;
        Rectangle rect = composite.getClientArea();
        Point leftSize = new Point(0, 0);
        if (left2 != null && !left2.isDisposed()) {
            leftSize = this.computeChildSize(left2, -1, -1, flushCache);
        }
        Point centerSize = new Point(0, 0);
        if (center2 != null && !center2.isDisposed()) {
            centerSize = this.computeChildSize(center2, -1, -1, flushCache);
        }
        Point rightSize = new Point(0, 0);
        if (right2 != null && !right2.isDisposed()) {
            rightSize = this.computeChildSize(right2, -1, -1, flushCache);
        }
        int minTopWidth = leftSize.x + centerSize.x + rightSize.x + 2 * form2.marginWidth + 2 * form2.highlight;
        int count = -1;
        if (leftSize.x > 0) {
            ++count;
        }
        if (centerSize.x > 0) {
            ++count;
        }
        if (rightSize.x > 0) {
            ++count;
        }
        if (count > 0) {
            minTopWidth += count * form2.horizontalSpacing;
        }
        int x2 = rect.x + rect.width - form2.marginWidth - form2.highlight;
        int y2 = rect.y + form2.marginHeight + form2.highlight;
        boolean top2 = false;
        if (form2.separateTopCenter || minTopWidth > rect.width) {
            int trim;
            topHeight = Math.max(rightSize.y, leftSize.y);
            if (right2 != null && !right2.isDisposed()) {
                top2 = true;
                right2.setBounds(x2 -= rightSize.x, y2, rightSize.x, topHeight);
                x2 -= form2.horizontalSpacing;
            }
            if (left2 != null && !left2.isDisposed()) {
                top2 = true;
                trim = this.computeTrim(left2);
                int leftW = x2 - rect.x - form2.marginWidth - form2.highlight - trim;
                leftSize = this.computeChildSize(left2, leftW, -1, false);
                left2.setBounds(rect.x + form2.marginWidth + form2.highlight, y2, leftSize.x, topHeight);
            }
            if (top2) {
                y2 += topHeight + form2.verticalSpacing;
            }
            if (center2 != null && !center2.isDisposed()) {
                top2 = true;
                trim = this.computeTrim(center2);
                w2 = rect.width - 2 * form2.marginWidth - 2 * form2.highlight - trim;
                Point size = this.computeChildSize(center2, w2, -1, false);
                if (size.x < centerSize.x) {
                    centerSize = size;
                }
                center2.setBounds(rect.x + rect.width - form2.marginWidth - form2.highlight - centerSize.x, y2, centerSize.x, centerSize.y);
                y2 += centerSize.y + form2.verticalSpacing;
            }
        } else {
            topHeight = Math.max(rightSize.y, Math.max(centerSize.y, leftSize.y));
            if (right2 != null && !right2.isDisposed()) {
                top2 = true;
                right2.setBounds(x2 -= rightSize.x, y2, rightSize.x, topHeight);
                x2 -= form2.horizontalSpacing;
            }
            if (center2 != null && !center2.isDisposed()) {
                top2 = true;
                center2.setBounds(x2 -= centerSize.x, y2, centerSize.x, topHeight);
                x2 -= form2.horizontalSpacing;
            }
            if (left2 != null && !left2.isDisposed()) {
                top2 = true;
                Rectangle trim = left2 instanceof Composite ? ((Composite)left2).computeTrim(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
                w2 = x2 - rect.x - form2.marginWidth - form2.highlight - trim.width;
                int h2 = topHeight - trim.height;
                leftSize = this.computeChildSize(left2, w2, h2, false);
                left2.setBounds(rect.x + form2.marginWidth + form2.highlight, y2, leftSize.x, topHeight);
            }
            if (top2) {
                y2 += topHeight + form2.verticalSpacing;
            }
        }
        int oldSeperator = form2.separator;
        form2.separator = -1;
        if (content != null && !content.isDisposed()) {
            if (left2 != null || right2 != null || center2 != null) {
                form2.separator = y2++;
            }
            content.setBounds(rect.x + form2.marginWidth + form2.highlight, y2, rect.width - 2 * form2.marginWidth - 2 * form2.highlight, rect.y + rect.height - y2 - form2.marginHeight - form2.highlight);
        }
        if (oldSeperator != form2.separator) {
            int b2;
            int t2;
            if (oldSeperator == -1) {
                t2 = form2.separator;
                b2 = form2.separator + 1;
            } else if (form2.separator == -1) {
                t2 = oldSeperator;
                b2 = oldSeperator + 1;
            } else {
                t2 = Math.min(form2.separator, oldSeperator);
                b2 = Math.max(form2.separator, oldSeperator);
            }
            form2.redraw(form2.borderLeft, t2, form2.getSize().x - form2.borderLeft - form2.borderRight, b2 - t2, false);
        }
    }
}

