/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.webkit.IWebDataSource;
import org.eclipse.swt.internal.webkit.IWebError;
import org.eclipse.swt.internal.webkit.IWebErrorPrivate;
import org.eclipse.swt.internal.webkit.IWebFrame;
import org.eclipse.swt.internal.webkit.IWebMutableURLRequest;
import org.eclipse.swt.internal.webkit.IWebURLRequest;
import org.eclipse.swt.internal.webkit.IWebView;
import org.eclipse.swt.internal.webkit.WebKit_win32;
import org.eclipse.swt.internal.win32.CERT_CONTEXT;
import org.eclipse.swt.internal.win32.CERT_INFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class WebFrameLoadDelegate {
    COMObject iWebFrameLoadDelegate;
    int refCount = 0;
    Browser browser;
    String html;
    String url;
    static final String OBJECTNAME_EXTERNAL = "external";

    WebFrameLoadDelegate(Browser browser) {
        this.createCOMInterfaces();
        this.browser = browser;
    }

    void addEventHandlers(boolean top2) {
        if (top2) {
            StringBuilder buffer = new StringBuilder("window.SWTkeyhandler = function SWTkeyhandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.keyCode, e.charCode, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey);} catch (e) {}};");
            buffer.append("document.addEventListener('keydown', SWTkeyhandler, true);");
            buffer.append("document.addEventListener('keypress', SWTkeyhandler, true);");
            buffer.append("document.addEventListener('keyup', SWTkeyhandler, true);");
            this.browser.execute(buffer.toString());
            buffer = new StringBuilder("window.SWTmousehandler = function SWTmousehandler(e) {");
            buffer.append("try {e.returnValue = HandleWebKitEvent(e.type, e.screenX, e.screenY, e.detail, e.button + 1, e.altKey, e.ctrlKey, e.shiftKey, e.metaKey, e.relatedTarget != null);} catch (e) {}};");
            buffer.append("document.addEventListener('mousedown', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mouseup', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mousemove', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mousewheel', SWTmousehandler, true);");
            buffer.append("document.addEventListener('dragstart', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mouseover', SWTmousehandler, true);");
            buffer.append("document.addEventListener('mouseout', SWTmousehandler, true);");
            this.browser.execute(buffer.toString());
        } else {
            StringBuilder buffer = new StringBuilder("for (var i = 0; i < frames.length; i++) {");
            buffer.append("frames[i].document.addEventListener('keydown', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keypress', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('keyup', window.SWTkeyhandler, true);");
            buffer.append("frames[i].document.addEventListener('mousedown', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseup', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousemove', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseover', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mouseout', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('mousewheel', window.SWTmousehandler, true);");
            buffer.append("frames[i].document.addEventListener('dragstart', window.SWTmousehandler, true);");
            buffer.append('}');
            this.browser.execute(buffer.toString());
        }
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[17];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 3;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 2;
        nArray[12] = 5;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 3;
        nArray[16] = 4;
        this.iWebFrameLoadDelegate = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return WebFrameLoadDelegate.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return WebFrameLoadDelegate.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return WebFrameLoadDelegate.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return WebFrameLoadDelegate.this.didStartProvisionalLoadForFrame(args2[0], args2[1]);
            }

            @Override
            public long method4(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method5(long[] args2) {
                return WebFrameLoadDelegate.this.didFailProvisionalLoadWithError(args2[0], args2[1], args2[2]);
            }

            @Override
            public long method6(long[] args2) {
                return WebFrameLoadDelegate.this.didCommitLoadForFrame(args2[0], args2[1]);
            }

            @Override
            public long method7(long[] args2) {
                return WebFrameLoadDelegate.this.didReceiveTitle(args2[0], args2[1], args2[2]);
            }

            @Override
            public long method8(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method9(long[] args2) {
                return WebFrameLoadDelegate.this.didFinishLoadForFrame(args2[0], args2[1]);
            }

            @Override
            public long method10(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method11(long[] args2) {
                return WebFrameLoadDelegate.this.didChangeLocationWithinPageForFrame(args2[0], args2[1]);
            }

            @Override
            public long method12(long[] args2) {
                return 0L;
            }

            @Override
            public long method13(long[] args2) {
                return -2147467263L;
            }

            @Override
            public long method14(long[] args2) {
                return 0L;
            }

            @Override
            public long method15(long[] args2) {
                return 0L;
            }

            @Override
            public long method16(long[] args2) {
                return WebFrameLoadDelegate.this.didClearWindowObject(args2[0], args2[1], args2[2], args2[3]);
            }
        };
        long ppVtable = this.iWebFrameLoadDelegate.ppVtable;
        long[] pVtable = new long[1];
        OS.MoveMemory(pVtable, ppVtable, C.PTR_SIZEOF);
        long[] funcs = new long[17];
        OS.MoveMemory(funcs, pVtable[0], C.PTR_SIZEOF * funcs.length);
        funcs[12] = WebKit_win32.willPerformClientRedirectToURL_CALLBACK(funcs[12]);
        OS.MoveMemory(pVtable[0], funcs, C.PTR_SIZEOF * funcs.length);
    }

    int didChangeLocationWithinPageForFrame(long webView, long frame) {
        int i2;
        IWebFrame iwebframe = new IWebFrame(frame);
        long[] result2 = new long[1];
        int hr = iwebframe.dataSource(result2);
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        IWebDataSource dataSource = new IWebDataSource(result2[0]);
        result2[0] = 0L;
        hr = dataSource.request(result2);
        dataSource.Release();
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        IWebURLRequest request = new IWebURLRequest(result2[0]);
        result2[0] = 0L;
        hr = request.URL(result2);
        request.Release();
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        String url2 = WebKit.extractBSTR(result2[0]);
        COM.SysFreeString(result2[0]);
        if (url2.length() == 0) {
            return 0;
        }
        if (url2.equals("file:///")) {
            url2 = "about:blank";
        } else {
            int length = "file:///".length();
            if (url2.startsWith("file:///") && url2.charAt(length) == '#') {
                url2 = "about:blank" + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        result2[0] = 0L;
        IWebView iWebView = new IWebView(webView);
        hr = iWebView.mainFrame(result2);
        boolean top2 = false;
        if (hr == 0 && result2[0] != 0L) {
            top2 = frame == result2[0];
            new IWebFrame(result2[0]).Release();
        }
        if (top2) {
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
            i2 = 0;
            while (i2 < statusTextListeners.length) {
                statusTextListeners[i2].changed(statusText);
                ++i2;
            }
        }
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top2;
        LocationListener[] locationListeners = this.browser.webBrowser.locationListeners;
        i2 = 0;
        while (i2 < locationListeners.length) {
            locationListeners[i2].changed(location);
            ++i2;
        }
        return 0;
    }

    int didClearWindowObject(long webView, long context, long windowScriptObject, long frame) {
        WebKit_win32.JSGlobalContextRetain(context);
        long globalObject = WebKit_win32.JSContextGetGlobalObject(context);
        long privateData = ((WebKit)this.browser.webBrowser).webViewData;
        long externalObject = WebKit_win32.JSObjectMake(context, WebKit.ExternalClass, privateData);
        byte[] bytes = "external\u0000".getBytes(StandardCharsets.UTF_8);
        long name = WebKit_win32.JSStringCreateWithUTF8CString(bytes);
        WebKit_win32.JSObjectSetProperty(context, globalObject, name, externalObject, 0L, null);
        WebKit_win32.JSStringRelease(name);
        for (BrowserFunction current : this.browser.webBrowser.functions.values()) {
            this.browser.execute(current.functionString);
        }
        IWebView iwebView = new IWebView(webView);
        long[] mainFrame = new long[1];
        iwebView.mainFrame(mainFrame);
        boolean top2 = mainFrame[0] == frame;
        new IWebFrame(mainFrame[0]).Release();
        this.addEventHandlers(top2);
        return 0;
    }

    int didCommitLoadForFrame(long webview2, long frame) {
        IWebFrame iWebFrame = new IWebFrame(frame);
        long[] result2 = new long[1];
        int hr = iWebFrame.dataSource(result2);
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        IWebDataSource dataSource = new IWebDataSource(result2[0]);
        result2[0] = 0L;
        hr = dataSource.request(result2);
        dataSource.Release();
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        IWebMutableURLRequest request = new IWebMutableURLRequest(result2[0]);
        result2[0] = 0L;
        hr = request.URL(result2);
        request.Release();
        if (hr != 0 || result2[0] == 0L) {
            return 0;
        }
        String url2 = WebKit.extractBSTR(result2[0]);
        COM.SysFreeString(result2[0]);
        if (url2.length() == 0) {
            return 0;
        }
        if (url2.equals("file:///")) {
            url2 = "about:blank";
        } else {
            int length = "file:///".length();
            if (url2.startsWith("file:///") && url2.charAt(length) == '#') {
                url2 = "about:blank" + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        result2[0] = 0L;
        IWebView iwebView = new IWebView(webview2);
        hr = iwebView.mainFrame(result2);
        boolean top2 = false;
        if (hr == 0 && result2[0] != 0L) {
            top2 = frame == result2[0];
            new IWebFrame(result2[0]).Release();
        }
        if (top2) {
            this.url = url2;
            if (url2.startsWith("about:blank") && this.html != null) {
                return 0;
            }
            for (BrowserFunction function : this.browser.webBrowser.functions.values()) {
                this.browser.webBrowser.execute(function.functionString);
            }
            ProgressEvent progress2 = new ProgressEvent(this.browser);
            progress2.display = display;
            progress2.widget = this.browser;
            progress2.current = 1;
            progress2.total = 100;
            ProgressListener[] progressListeners = this.browser.webBrowser.progressListeners;
            int i2 = 0;
            while (i2 < progressListeners.length) {
                progressListeners[i2].changed(progress2);
                ++i2;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            StatusTextListener[] statusTextListeners = this.browser.webBrowser.statusTextListeners;
            int i3 = 0;
            while (i3 < statusTextListeners.length) {
                statusTextListeners[i3].changed(statusText);
                ++i3;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top2;
        LocationListener[] locationListeners = this.browser.webBrowser.locationListeners;
        int i4 = 0;
        while (i4 < locationListeners.length) {
            locationListeners[i4].changed(location);
            ++i4;
        }
        return 0;
    }

    int didFailProvisionalLoadWithError(long webView, long error2, long frame) {
        IWebError iweberror = new IWebError(error2);
        int[] errorCode = new int[1];
        int hr = iweberror.code(errorCode);
        if (-1000 < errorCode[0]) {
            return 0;
        }
        String failingURLString = null;
        long[] failingURL = new long[1];
        hr = iweberror.failingURL(failingURL);
        if (hr == 0 && failingURL[0] != 0L) {
            failingURLString = WebKit.extractBSTR(failingURL[0]);
            COM.SysFreeString(failingURL[0]);
        }
        if (failingURLString != null && -1204 <= errorCode[0] && errorCode[0] <= -1200) {
            long[] result2 = new long[1];
            hr = iweberror.localizedDescription(result2);
            if (hr != 0 || result2[0] == 0L) {
                return 0;
            }
            String description2 = WebKit.extractBSTR(result2[0]);
            COM.SysFreeString(result2[0]);
            result2[0] = 0L;
            hr = iweberror.QueryInterface(WebKit_win32.IID_IWebErrorPrivate, result2);
            if (hr != 0 || result2[0] == 0L) {
                return 0;
            }
            IWebErrorPrivate webErrorPrivate = new IWebErrorPrivate(result2[0]);
            result2[0] = 0L;
            long[] certificate = new long[1];
            hr = webErrorPrivate.sslPeerCertificate(certificate);
            webErrorPrivate.Release();
            if (hr != 0 || certificate[0] == 0L) {
                return 0;
            }
            if (this.showCertificateDialog(webView, failingURLString, description2, certificate[0])) {
                IWebFrame iWebFrame = new IWebFrame(frame);
                hr = WebKit_win32.WebKitCreateInstance(WebKit_win32.CLSID_WebMutableURLRequest, 0L, WebKit_win32.IID_IWebMutableURLRequest, result2);
                if (hr != 0 || result2[0] == 0L) {
                    certificate[0] = 0L;
                    return 0;
                }
                IWebMutableURLRequest request = new IWebMutableURLRequest(result2[0]);
                request.setURL(failingURL[0]);
                request.setAllowsAnyHTTPSCertificate();
                iWebFrame.loadRequest(request.getAddress());
                request.Release();
            }
            certificate[0] = 0L;
            return 0;
        }
        long[] result3 = new long[1];
        hr = iweberror.localizedDescription(result3);
        if (hr != 0 || result3[0] == 0L) {
            return 0;
        }
        String description3 = WebKit.extractBSTR(result3[0]);
        COM.SysFreeString(result3[0]);
        if (!this.browser.isDisposed()) {
            String message2 = failingURLString != null ? String.valueOf(failingURLString) + "\n\n" : "";
            message2 = String.valueOf(message2) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{description3});
            MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
            messageBox.setMessage(message2);
            messageBox.open();
        }
        return 0;
    }

    int didFinishLoadForFrame(long webview2, long frame) {
        IWebView iWebView = new IWebView(webview2);
        long[] iWebFrame = new long[1];
        int hr = iWebView.mainFrame(iWebFrame);
        if (hr != 0 || iWebFrame[0] == 0L) {
            return 0;
        }
        boolean top2 = frame == iWebFrame[0];
        new IWebFrame(iWebFrame[0]).Release();
        if (!top2) {
            return 0;
        }
        if (this.html != null && this.getUrl().startsWith("about:blank")) {
            ((WebKit)this.browser.webBrowser).loadingText = true;
            long string2 = WebKit.createBSTR(this.html);
            long URLString = ((WebKit)this.browser.webBrowser).untrustedText ? WebKit.createBSTR("about:blank") : WebKit.createBSTR("file:///");
            IWebFrame mainFrame = new IWebFrame(frame);
            mainFrame.loadHTMLString(string2, URLString);
            this.html = null;
        }
        if (!((WebKit)this.browser.webBrowser).loadingText) {
            int i2;
            if (this.browser.isDisposed()) {
                return 0;
            }
            Display display = this.browser.getDisplay();
            IWebFrame mainFrame = new IWebFrame(frame);
            long[] result2 = new long[1];
            hr = mainFrame.dataSource(result2);
            if (hr != 0 || result2[0] == 0L) {
                return 0;
            }
            IWebDataSource dataSource = new IWebDataSource(result2[0]);
            result2[0] = 0L;
            hr = dataSource.pageTitle(result2);
            dataSource.Release();
            if (hr != 0) {
                return 0;
            }
            String title2 = null;
            if (result2[0] != 0L) {
                title2 = WebKit.extractBSTR(result2[0]);
                COM.SysFreeString(result2[0]);
            }
            if (title2 == null || title2.length() == 0) {
                TitleEvent newEvent = new TitleEvent(this.browser);
                newEvent.display = display;
                newEvent.widget = this.browser;
                newEvent.title = this.getUrl();
                TitleListener[] titleListeners = this.browser.webBrowser.titleListeners;
                i2 = 0;
                while (i2 < titleListeners.length) {
                    titleListeners[i2].changed(newEvent);
                    ++i2;
                }
                if (this.browser.isDisposed()) {
                    return 0;
                }
            }
            ProgressEvent progress2 = new ProgressEvent(this.browser);
            progress2.display = display;
            progress2.widget = this.browser;
            progress2.current = 100;
            progress2.total = 100;
            ProgressListener[] progressListeners = this.browser.webBrowser.progressListeners;
            i2 = 0;
            while (i2 < progressListeners.length) {
                progressListeners[i2].completed(progress2);
                ++i2;
            }
            if (this.browser.isDisposed()) {
                return 0;
            }
        }
        ((WebKit)this.browser.webBrowser).loadingText = false;
        return 0;
    }

    int didReceiveTitle(long webView, long title2, long frame) {
        IWebView iWebView = new IWebView(webView);
        long[] mainFrame = new long[1];
        int hr = iWebView.mainFrame(mainFrame);
        if (hr != 0 || frame == 0L) {
            return 0;
        }
        if (frame == mainFrame[0]) {
            String newTitle = WebKit.extractBSTR(title2);
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = newTitle;
            TitleListener[] titleListeners = this.browser.webBrowser.titleListeners;
            int i2 = 0;
            while (i2 < titleListeners.length) {
                titleListeners[i2].changed(newEvent);
                ++i2;
            }
        }
        new IWebFrame(mainFrame[0]).Release();
        return 0;
    }

    int didStartProvisionalLoadForFrame(long webView, long frame) {
        return 0;
    }

    void disposeCOMInterfaces() {
        if (this.iWebFrameLoadDelegate != null) {
            this.iWebFrameLoadDelegate.dispose();
            this.iWebFrameLoadDelegate = null;
        }
    }

    long getAddress() {
        return this.iWebFrameLoadDelegate.getAddress();
    }

    String getUrl() {
        if (this.url == null || this.url.length() == 0) {
            return "about:blank";
        }
        return this.url;
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebFrameLoadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, WebKit_win32.IID_IWebFrameLoadDelegate)) {
            OS.MoveMemory(ppvObject, new long[]{this.iWebFrameLoadDelegate.getAddress()}, C.PTR_SIZEOF);
            new IUnknown(this.iWebFrameLoadDelegate.getAddress()).AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[1], C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    boolean showCertificateDialog(long webView, String failingUrlString, String description2, long certificate) {
        Shell parent = this.browser.getShell();
        Shell shell = new Shell(parent, 67680);
        shell.setText(Compatibility.getMessage("SWT_InvalidCert_Title"));
        shell.setLayout(new GridLayout());
        Label label2 = new Label(shell, 64);
        String host = null;
        try {
            host = new URL(failingUrlString).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            host = failingUrlString;
        }
        StringBuilder message2 = new StringBuilder("\n");
        message2.append(Compatibility.getMessage("SWT_InvalidCert_Message", new String[]{host}));
        message2.append("\n\n");
        message2.append(Compatibility.getMessage(description2));
        message2.append("\n");
        message2.append(Compatibility.getMessage("SWT_InvalidCert_Connect"));
        message2.append("\n");
        label2.setText(message2.toString());
        GridData data2 = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label2.computeSize((int)-1, (int)-1).x;
        data2.widthHint = Math.min(width, maxWidth);
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        label2.setLayoutData(data2);
        boolean[] result2 = new boolean[1];
        Button[] buttons = new Button[3];
        Listener listener2 = event -> {
            if (event.widget == buttons[2]) {
                this.showCertificate(shell, certificate);
            } else {
                blArray[0] = event.widget == buttons[0];
                shell.close();
            }
        };
        Composite composite = new Composite(shell, 0);
        data2 = new GridData();
        data2.horizontalAlignment = 3;
        composite.setLayoutData(data2);
        composite.setLayout(new GridLayout(3, true));
        buttons[0] = new Button(composite, 8);
        buttons[0].setText(SWT.getMessage("SWT_Continue"));
        buttons[0].setLayoutData(new GridData(768));
        buttons[0].addListener(13, listener2);
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_Cancel"));
        buttons[1].setLayoutData(new GridData(768));
        buttons[1].addListener(13, listener2);
        buttons[2] = new Button(composite, 8);
        buttons[2].setText(SWT.getMessage("SWT_ViewCertificate"));
        buttons[2].setLayoutData(new GridData(768));
        buttons[2].addListener(13, listener2);
        shell.setDefaultButton(buttons[0]);
        shell.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle shellSize = shell.getBounds();
        int x2 = parent.getLocation().x + (parentSize.width - shellSize.width) / 2;
        int y2 = parent.getLocation().y + (parentSize.height - shellSize.height) / 2;
        shell.setLocation(x2, y2);
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result2[0];
    }

    void showCertificate(Shell parent, long certificate) {
        CERT_CONTEXT context = new CERT_CONTEXT();
        OS.MoveMemory(context, certificate, CERT_CONTEXT.sizeof);
        CERT_INFO info = new CERT_INFO();
        OS.MoveMemory(info, context.pCertInfo, CERT_INFO.sizeof);
        int length = OS.CertNameToStr(1, info.Issuer, 1, null, 0);
        char[] buffer = new char[length];
        OS.CertNameToStr(1, info.Issuer, 1, buffer, length);
        String issuer = new String(buffer, 0, length - 1);
        length = OS.CertNameToStr(1, info.Subject, 1, null, 0);
        buffer = new char[length];
        OS.CertNameToStr(1, info.Subject, 1, buffer, length);
        String subject = new String(buffer, 0, length - 1);
        SYSTEMTIME systemTime = new SYSTEMTIME();
        OS.FileTimeToSystemTime(info.NotBefore, systemTime);
        String validFrom = String.valueOf(systemTime.wDay) + "/" + systemTime.wMonth + "/" + systemTime.wYear;
        String validFromTime = String.valueOf(systemTime.wHour) + ":" + systemTime.wMinute + ":" + systemTime.wSecond;
        systemTime = new SYSTEMTIME();
        OS.FileTimeToSystemTime(info.NotAfter, systemTime);
        String validTo = String.valueOf(systemTime.wDay) + "/" + systemTime.wMonth + "/" + systemTime.wYear;
        String validToTime = String.valueOf(systemTime.wHour) + ":" + systemTime.wMinute + ":" + systemTime.wSecond;
        length = info.SerialNumber.cbData;
        byte[] serialNumber = new byte[length];
        OS.MoveMemory(serialNumber, info.SerialNumber.pbData, length);
        String hexSerialNumber = new String();
        int i2 = length - 1;
        while (i2 >= 0) {
            int number = 0xFF & serialNumber[i2];
            String hex2 = Integer.toHexString(number);
            if (hex2.length() == 1) {
                hexSerialNumber = String.valueOf(hexSerialNumber) + "0";
            }
            hexSerialNumber = String.valueOf(hexSerialNumber) + hex2 + " ";
            --i2;
        }
        final Shell dialog2 = new Shell(parent, 67680);
        dialog2.setText(SWT.getMessage("SWT_Certificate"));
        dialog2.setLayout(new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(dialog2, 0);
        tabFolder.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        tabFolder.setLayout(new FillLayout());
        TabItem general = new TabItem(tabFolder, 0);
        general.setText(SWT.getMessage("SWT_General"));
        Composite composite = new Composite(tabFolder, 2048);
        composite.setLayout(new GridLayout(1, false));
        Label issuedTo = new Label(composite, 0);
        issuedTo.setLayoutData(new GridData(1, 0x1000000, false, false));
        issuedTo.setText(Compatibility.getMessage("SWT_IssuedTo", new Object[]{subject}));
        Label issuedBy = new Label(composite, 0);
        issuedBy.setLayoutData(new GridData(1, 0x1000000, false, false));
        issuedBy.setText(Compatibility.getMessage("SWT_IssuedFrom", new Object[]{issuer}));
        Label valid2 = new Label(composite, 0);
        valid2.setLayoutData(new GridData(1, 0x1000000, false, false));
        valid2.setText(Compatibility.getMessage("SWT_ValidFromTo", new Object[]{validFrom, validTo}));
        general.setControl(composite);
        TabItem details = new TabItem(tabFolder, 0);
        details.setText(SWT.getMessage("SWT_Details"));
        Table table = new Table(tabFolder, 67588);
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(SWT.getMessage("SWT_Field"));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(SWT.getMessage("SWT_Value"));
        TableItem tableItem = new TableItem(table, 0);
        String version = "V" + String.valueOf(info.dwVersion + 1);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Version"), version});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_SerialNumber"), hexSerialNumber});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Issuer"), issuer});
        tableItem = new TableItem(table, 0);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(validFrom);
        stringBuilder2.append(", ");
        stringBuilder2.append(validFromTime);
        stringBuilder2.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidFrom"), stringBuilder2.toString()});
        tableItem = new TableItem(table, 0);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(validTo);
        stringBuilder.append(", ");
        stringBuilder.append(validToTime);
        stringBuilder.append(" GMT");
        tableItem.setText(new String[]{SWT.getMessage("SWT_ValidTo"), stringBuilder.toString()});
        tableItem = new TableItem(table, 0);
        tableItem.setText(new String[]{SWT.getMessage("SWT_Subject"), subject});
        int i3 = 0;
        while (i3 < table.getColumnCount()) {
            table.getColumn(i3).pack();
            ++i3;
        }
        details.setControl(table);
        Button ok = new Button(dialog2, 8);
        GridData layoutData = new GridData(0x1000008, 0x1000000, false, false);
        layoutData.widthHint = 75;
        ok.setLayoutData(layoutData);
        ok.setText(SWT.getMessage("SWT_OK"));
        ok.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e2) {
                dialog2.dispose();
            }
        });
        dialog2.setDefaultButton(ok);
        dialog2.pack();
        Rectangle parentSize = parent.getBounds();
        Rectangle dialogSize = dialog2.getBounds();
        int x2 = parent.getLocation().x + (parentSize.width - dialogSize.width) / 2;
        int y2 = parent.getLocation().y + (parentSize.height - dialogSize.height) / 2;
        dialog2.setLocation(x2, y2);
        dialog2.open();
        Display display = this.browser.getDisplay();
        while (!dialog2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

