/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.SetExpression;
import javafx.beans.property.ReadOnlyProperty;
import javafx.collections.ObservableSet;

public abstract class ReadOnlySetProperty<E>
extends SetExpression<E>
implements ReadOnlyProperty<ObservableSet<E>> {
    public void bindContentBidirectional(ObservableSet<E> observableSet) {
        Bindings.bindContentBidirectional(this, observableSet);
    }

    public void unbindContentBidirectional(Object object) {
        Bindings.unbindContentBidirectional(this, object);
    }

    public void bindContent(ObservableSet<E> observableSet) {
        Bindings.bindContent(this, observableSet);
    }

    public void unbindContent(Object object) {
        Bindings.unbindContent(this, object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set2 = (Set)object;
        if (set2.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(set2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (Object e2 : this) {
            if (e2 == null) continue;
            n2 += e2.hashCode();
        }
        return n2;
    }

    public String toString() {
        Object object = this.getBean();
        String string2 = this.getName();
        StringBuilder stringBuilder = new StringBuilder("ReadOnlySetProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string2 != null && !string2.equals("")) {
            stringBuilder.append("name: ").append(string2).append(", ");
        }
        stringBuilder.append("value: ").append(this.get()).append("]");
        return stringBuilder.toString();
    }
}

