/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.codec;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.ImgRaw;
import com.itextpdf.text.Jpeg;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.InvalidImageException;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.codec.CCITTG4Encoder;
import com.itextpdf.text.pdf.codec.TIFFDirectory;
import com.itextpdf.text.pdf.codec.TIFFFaxDecoder;
import com.itextpdf.text.pdf.codec.TIFFField;
import com.itextpdf.text.pdf.codec.TIFFLZWDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class TiffImage {
    public static int getNumberOfPages(RandomAccessFileOrArray s2) {
        try {
            return TIFFDirectory.getNumDirectories(s2);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    static int getDpi(TIFFField fd, int resolutionUnit) {
        if (fd == null) {
            return 0;
        }
        long[] res = fd.getAsRational(0);
        float frac = (float)res[0] / (float)res[1];
        int dpi = 0;
        switch (resolutionUnit) {
            case 1: 
            case 2: {
                dpi = (int)((double)frac + 0.5);
                break;
            }
            case 3: {
                dpi = (int)((double)frac * 2.54 + 0.5);
            }
        }
        return dpi;
    }

    /*
     * Unable to fully structure code
     */
    public static Image getTiffImage(RandomAccessFileOrArray s, boolean recoverFromImageError, int page, boolean direct) {
        if (page < 1) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.page.number.must.be.gt.eq.1", new Object[0]));
        }
        try {
            block49: {
                block48: {
                    dir = new TIFFDirectory(s, page - 1);
                    if (dir.isTagPresent(322)) {
                        throw new IllegalArgumentException(MessageLocalization.getComposedMessage("tiles.are.not.supported", new Object[0]));
                    }
                    compression = 1;
                    if (dir.isTagPresent(259)) {
                        compression = (int)dir.getFieldAsLong(259);
                    }
                    switch (compression) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 32771: {
                            break;
                        }
                        default: {
                            return TiffImage.getTiffImageColor(dir, s);
                        }
                    }
                    rotation = 0.0f;
                    if (dir.isTagPresent(274)) {
                        rot = (int)dir.getFieldAsLong(274);
                        if (rot == 3 || rot == 4) {
                            rotation = 3.1415927f;
                        } else if (rot == 5 || rot == 8) {
                            rotation = 1.5707964f;
                        } else if (rot == 6 || rot == 7) {
                            rotation = -1.5707964f;
                        }
                    }
                    img = null;
                    tiffT4Options = 0L;
                    tiffT6Options = 0L;
                    fillOrder = 1L;
                    h = (int)dir.getFieldAsLong(257);
                    w = (int)dir.getFieldAsLong(256);
                    dpiX = 0;
                    dpiY = 0;
                    XYRatio = 0.0f;
                    resolutionUnit = 2;
                    if (dir.isTagPresent(296)) {
                        resolutionUnit = (int)dir.getFieldAsLong(296);
                    }
                    dpiX = TiffImage.getDpi(dir.getField(282), resolutionUnit);
                    dpiY = TiffImage.getDpi(dir.getField(283), resolutionUnit);
                    if (resolutionUnit == 1) {
                        if (dpiY != 0) {
                            XYRatio = (float)dpiX / (float)dpiY;
                        }
                        dpiX = 0;
                        dpiY = 0;
                    }
                    rowsStrip = h;
                    if (dir.isTagPresent(278)) {
                        rowsStrip = (int)dir.getFieldAsLong(278);
                    }
                    if (rowsStrip <= 0 || rowsStrip > h) {
                        rowsStrip = h;
                    }
                    offset = TiffImage.getArrayLongShort(dir, 273);
                    size = TiffImage.getArrayLongShort(dir, 279);
                    if ((size == null || size.length == 1 && (size[0] == 0L || size[0] + offset[0] > s.length())) && h == rowsStrip) {
                        size = new long[]{s.length() - (long)((int)offset[0])};
                    }
                    reverse = false;
                    fillOrderField = dir.getField(266);
                    if (fillOrderField != null) {
                        fillOrder = fillOrderField.getAsLong(0);
                    }
                    reverse = fillOrder == 2L;
                    params = 0;
                    if (dir.isTagPresent(262) && (photo = dir.getFieldAsLong(262)) == 1L) {
                        params |= 1;
                    }
                    imagecomp = 0;
                    switch (compression) {
                        case 2: 
                        case 32771: {
                            imagecomp = 257;
                            params |= 10;
                            break;
                        }
                        case 3: {
                            imagecomp = 257;
                            params |= 12;
                            t4OptionsField = dir.getField(292);
                            if (t4OptionsField == null) break;
                            tiffT4Options = t4OptionsField.getAsLong(0);
                            if ((tiffT4Options & 1L) != 0L) {
                                imagecomp = 258;
                            }
                            if ((tiffT4Options & 4L) == 0L) break;
                            params |= 2;
                            break;
                        }
                        case 4: {
                            imagecomp = 256;
                            t6OptionsField = dir.getField(293);
                            if (t6OptionsField == null) break;
                            tiffT6Options = t6OptionsField.getAsLong(0);
                        }
                    }
                    if (!direct || rowsStrip != h) break block48;
                    im = new byte[(int)size[0]];
                    s.seek(offset[0]);
                    s.readFully(im);
                    img = Image.getInstance(w, h, false, imagecomp, params, im);
                    img.setInverted(true);
                    break block49;
                }
                rowsLeft = h;
                g4 = new CCITTG4Encoder(w);
                for (k = 0; k < offset.length; ++k) {
                    im = new byte[(int)size[k]];
                    s.seek(offset[k]);
                    s.readFully(im);
                    height = Math.min(rowsStrip, rowsLeft);
                    decoder = new TIFFFaxDecoder(fillOrder, w, height);
                    decoder.setRecoverFromImageError(recoverFromImageError);
                    outBuf = new byte[(w + 7) / 8 * height];
                    switch (compression) {
                        case 2: 
                        case 32771: {
                            decoder.decode1D(outBuf, im, 0, height);
                            g4.fax4Encode(outBuf, height);
                            break;
                        }
                        case 3: {
                            try {
                                decoder.decode2D(outBuf, im, 0, height, tiffT4Options);
                            }
                            catch (RuntimeException e) {
                                tiffT4Options ^= 4L;
                                try {
                                    decoder.decode2D(outBuf, im, 0, height, tiffT4Options);
                                }
                                catch (RuntimeException e2) {
                                    if (!recoverFromImageError) {
                                        throw e;
                                    }
                                    if (rowsStrip == 1) {
                                        throw e;
                                    }
                                    im = new byte[(int)size[0]];
                                    s.seek(offset[0]);
                                    s.readFully(im);
                                    img = Image.getInstance(w, h, false, imagecomp, params, im);
                                    img.setInverted(true);
                                    img.setDpi(dpiX, dpiY);
                                    img.setXYRatio(XYRatio);
                                    img.setOriginalType(5);
                                    if (rotation != 0.0f) {
                                        img.setInitialRotation(rotation);
                                    }
                                    return img;
                                }
                            }
                            g4.fax4Encode(outBuf, height);
                            break;
                        }
                        case 4: {
                            try {
                                decoder.decodeT6(outBuf, im, 0, height, tiffT6Options);
                            }
                            catch (InvalidImageException e) {
                                if (recoverFromImageError) ** GOTO lbl141
                                throw e;
                            }
lbl141:
                            // 2 sources

                            g4.fax4Encode(outBuf, height);
                        }
                    }
                    rowsLeft -= rowsStrip;
                }
                g4pic = g4.close();
                img = Image.getInstance(w, h, false, 256, params & 1, g4pic);
            }
            img.setDpi(dpiX, dpiY);
            img.setXYRatio(XYRatio);
            if (dir.isTagPresent(34675)) {
                try {
                    fd = dir.getField(34675);
                    icc_prof = ICC_Profile.getInstance(fd.getAsBytes());
                    if (icc_prof.getNumComponents() == 1) {
                        img.tagICC(icc_prof);
                    }
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            img.setOriginalType(5);
            if (rotation != 0.0f) {
                img.setInitialRotation(rotation);
            }
            return img;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getTiffImage(RandomAccessFileOrArray s2, boolean recoverFromImageError, int page) {
        return TiffImage.getTiffImage(s2, recoverFromImageError, page, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray s2, int page) {
        return TiffImage.getTiffImage(s2, page, false);
    }

    public static Image getTiffImage(RandomAccessFileOrArray s2, int page, boolean direct) {
        return TiffImage.getTiffImage(s2, false, page, direct);
    }

    protected static Image getTiffImageColor(TIFFDirectory dir, RandomAccessFileOrArray s2) {
        try {
            TIFFField predictorField;
            int compression = 1;
            if (dir.isTagPresent(259)) {
                compression = (int)dir.getFieldAsLong(259);
            }
            int predictor = 1;
            TIFFLZWDecoder lzwDecoder = null;
            switch (compression) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 32773: 
                case 32946: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.compression.1.is.not.supported", compression));
                }
            }
            int photometric = (int)dir.getFieldAsLong(262);
            switch (photometric) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                default: {
                    if (compression == 6 || compression == 7) break;
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.photometric.1.is.not.supported", photometric));
                }
            }
            float rotation = 0.0f;
            if (dir.isTagPresent(274)) {
                int rot = (int)dir.getFieldAsLong(274);
                if (rot == 3 || rot == 4) {
                    rotation = (float)Math.PI;
                } else if (rot == 5 || rot == 8) {
                    rotation = 1.5707964f;
                } else if (rot == 6 || rot == 7) {
                    rotation = -1.5707964f;
                }
            }
            if (dir.isTagPresent(284) && dir.getFieldAsLong(284) == 2L) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("planar.images.are.not.supported", new Object[0]));
            }
            int extraSamples = 0;
            if (dir.isTagPresent(338)) {
                extraSamples = 1;
            }
            int samplePerPixel = 1;
            if (dir.isTagPresent(277)) {
                samplePerPixel = (int)dir.getFieldAsLong(277);
            }
            int bitsPerSample = 1;
            if (dir.isTagPresent(258)) {
                bitsPerSample = (int)dir.getFieldAsLong(258);
            }
            switch (bitsPerSample) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageLocalization.getComposedMessage("bits.per.sample.1.is.not.supported", bitsPerSample));
                }
            }
            Image img = null;
            int h2 = (int)dir.getFieldAsLong(257);
            int w2 = (int)dir.getFieldAsLong(256);
            int dpiX = 0;
            int dpiY = 0;
            int resolutionUnit = 2;
            if (dir.isTagPresent(296)) {
                resolutionUnit = (int)dir.getFieldAsLong(296);
            }
            dpiX = TiffImage.getDpi(dir.getField(282), resolutionUnit);
            dpiY = TiffImage.getDpi(dir.getField(283), resolutionUnit);
            int fillOrder = 1;
            boolean reverse = false;
            TIFFField fillOrderField = dir.getField(266);
            if (fillOrderField != null) {
                fillOrder = fillOrderField.getAsInt(0);
            }
            reverse = fillOrder == 2;
            int rowsStrip = h2;
            if (dir.isTagPresent(278)) {
                rowsStrip = (int)dir.getFieldAsLong(278);
            }
            if (rowsStrip <= 0 || rowsStrip > h2) {
                rowsStrip = h2;
            }
            long[] offset = TiffImage.getArrayLongShort(dir, 273);
            long[] size = TiffImage.getArrayLongShort(dir, 279);
            if ((size == null || size.length == 1 && (size[0] == 0L || size[0] + offset[0] > s2.length())) && h2 == rowsStrip) {
                size = new long[]{s2.length() - (long)((int)offset[0])};
            }
            if ((compression == 5 || compression == 32946 || compression == 8) && (predictorField = dir.getField(317)) != null) {
                predictor = predictorField.getAsInt(0);
                if (predictor != 1 && predictor != 2) {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("illegal.value.for.predictor.in.tiff.file", new Object[0]));
                }
                if (predictor == 2 && bitsPerSample != 8) {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("1.bit.samples.are.not.supported.for.horizontal.differencing.predictor", bitsPerSample));
                }
            }
            if (compression == 5) {
                lzwDecoder = new TIFFLZWDecoder(w2, predictor, samplePerPixel);
            }
            int rowsLeft = h2;
            ByteArrayOutputStream stream = null;
            ByteArrayOutputStream mstream = null;
            DeflaterOutputStream zip2 = null;
            DeflaterOutputStream mzip = null;
            if (extraSamples > 0) {
                mstream = new ByteArrayOutputStream();
                mzip = new DeflaterOutputStream(mstream);
            }
            CCITTG4Encoder g4 = null;
            if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                g4 = new CCITTG4Encoder(w2);
            } else {
                stream = new ByteArrayOutputStream();
                if (compression != 6 && compression != 7) {
                    zip2 = new DeflaterOutputStream(stream);
                }
            }
            if (compression == 6) {
                if (!dir.isTagPresent(513)) {
                    throw new IOException(MessageLocalization.getComposedMessage("missing.tag.s.for.ojpeg.compression", new Object[0]));
                }
                int jpegOffset = (int)dir.getFieldAsLong(513);
                int jpegLength = (int)s2.length() - jpegOffset;
                if (dir.isTagPresent(514)) {
                    jpegLength = (int)dir.getFieldAsLong(514) + (int)size[0];
                }
                byte[] jpeg = new byte[Math.min(jpegLength, (int)s2.length() - jpegOffset)];
                s2.seek(jpegOffset);
                s2.readFully(jpeg);
                img = new Jpeg(jpeg);
            } else if (compression == 7) {
                if (size.length > 1) {
                    throw new IOException(MessageLocalization.getComposedMessage("compression.jpeg.is.only.supported.with.a.single.strip.this.image.has.1.strips", size.length));
                }
                byte[] jpeg = new byte[(int)size[0]];
                s2.seek(offset[0]);
                s2.readFully(jpeg);
                TIFFField jpegtables = dir.getField(347);
                if (jpegtables != null) {
                    byte[] temp = jpegtables.getAsBytes();
                    int tableoffset = 0;
                    int tablelength = temp.length;
                    if (temp[0] == -1 && temp[1] == -40) {
                        tableoffset = 2;
                        tablelength -= 2;
                    }
                    if (temp[temp.length - 2] == -1 && temp[temp.length - 1] == -39) {
                        tablelength -= 2;
                    }
                    byte[] tables = new byte[tablelength];
                    System.arraycopy(temp, tableoffset, tables, 0, tablelength);
                    byte[] jpegwithtables = new byte[jpeg.length + tables.length];
                    System.arraycopy(jpeg, 0, jpegwithtables, 0, 2);
                    System.arraycopy(tables, 0, jpegwithtables, 2, tables.length);
                    System.arraycopy(jpeg, 2, jpegwithtables, tables.length + 2, jpeg.length - 2);
                    jpeg = jpegwithtables;
                }
                img = new Jpeg(jpeg);
                if (photometric == 2) {
                    img.setColorTransform(0);
                }
            } else {
                for (int k2 = 0; k2 < offset.length; ++k2) {
                    byte[] im = new byte[(int)size[k2]];
                    s2.seek(offset[k2]);
                    s2.readFully(im);
                    int height = Math.min(rowsStrip, rowsLeft);
                    byte[] outBuf = null;
                    if (compression != 1) {
                        outBuf = new byte[(w2 * bitsPerSample * samplePerPixel + 7) / 8 * height];
                    }
                    if (reverse) {
                        TIFFFaxDecoder.reverseBits(im);
                    }
                    switch (compression) {
                        case 8: 
                        case 32946: {
                            TiffImage.inflate(im, outBuf);
                            TiffImage.applyPredictor(outBuf, predictor, w2, height, samplePerPixel);
                            break;
                        }
                        case 1: {
                            outBuf = im;
                            break;
                        }
                        case 32773: {
                            TiffImage.decodePackbits(im, outBuf);
                            break;
                        }
                        case 5: {
                            lzwDecoder.decode(im, outBuf, height);
                        }
                    }
                    if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                        g4.fax4Encode(outBuf, height);
                    } else if (extraSamples > 0) {
                        TiffImage.ProcessExtraSamples(zip2, mzip, outBuf, samplePerPixel, bitsPerSample, w2, height);
                    } else {
                        zip2.write(outBuf);
                    }
                    rowsLeft -= rowsStrip;
                }
                if (bitsPerSample == 1 && samplePerPixel == 1 && photometric != 3) {
                    img = Image.getInstance(w2, h2, false, 256, photometric == 1 ? 1 : 0, g4.close());
                } else {
                    zip2.close();
                    img = new ImgRaw(w2, h2, samplePerPixel - extraSamples, bitsPerSample, stream.toByteArray());
                    img.setDeflated(true);
                }
            }
            img.setDpi(dpiX, dpiY);
            if (compression != 6 && compression != 7) {
                if (dir.isTagPresent(34675)) {
                    try {
                        TIFFField fd = dir.getField(34675);
                        ICC_Profile icc_prof = ICC_Profile.getInstance(fd.getAsBytes());
                        if (samplePerPixel - extraSamples == icc_prof.getNumComponents()) {
                            img.tagICC(icc_prof);
                        }
                    }
                    catch (RuntimeException e2) {
                        // empty catch block
                    }
                }
                if (dir.isTagPresent(320)) {
                    int k3;
                    TIFFField fd = dir.getField(320);
                    char[] rgb = fd.getAsChars();
                    byte[] palette = new byte[rgb.length];
                    int gColor = rgb.length / 3;
                    int bColor = gColor * 2;
                    for (int k4 = 0; k4 < gColor; ++k4) {
                        palette[k4 * 3] = (byte)(rgb[k4] >>> 8);
                        palette[k4 * 3 + 1] = (byte)(rgb[k4 + gColor] >>> 8);
                        palette[k4 * 3 + 2] = (byte)(rgb[k4 + bColor] >>> 8);
                    }
                    boolean colormapBroken = true;
                    for (k3 = 0; k3 < palette.length; ++k3) {
                        if (palette[k3] == 0) continue;
                        colormapBroken = false;
                        break;
                    }
                    if (colormapBroken) {
                        for (k3 = 0; k3 < gColor; ++k3) {
                            palette[k3 * 3] = (byte)rgb[k3];
                            palette[k3 * 3 + 1] = (byte)rgb[k3 + gColor];
                            palette[k3 * 3 + 2] = (byte)rgb[k3 + bColor];
                        }
                    }
                    PdfArray indexed = new PdfArray();
                    indexed.add(PdfName.INDEXED);
                    indexed.add(PdfName.DEVICERGB);
                    indexed.add(new PdfNumber(gColor - 1));
                    indexed.add(new PdfString(palette));
                    PdfDictionary additional = new PdfDictionary();
                    additional.put(PdfName.COLORSPACE, indexed);
                    img.setAdditional(additional);
                }
                img.setOriginalType(5);
            }
            if (photometric == 0) {
                img.setInverted(true);
            }
            if (rotation != 0.0f) {
                img.setInitialRotation(rotation);
            }
            if (extraSamples > 0) {
                mzip.close();
                Image mimg = Image.getInstance(w2, h2, 1, bitsPerSample, mstream.toByteArray());
                mimg.makeMask();
                mimg.setDeflated(true);
                img.setImageMask(mimg);
            }
            return img;
        }
        catch (Exception e3) {
            throw new ExceptionConverter(e3);
        }
    }

    static Image ProcessExtraSamples(DeflaterOutputStream zip2, DeflaterOutputStream mzip, byte[] outBuf, int samplePerPixel, int bitsPerSample, int width, int height) throws IOException {
        int optr;
        int mptr;
        byte[] mask;
        if (bitsPerSample == 8) {
            mask = new byte[width * height];
            mptr = 0;
            optr = 0;
            int total = width * height * samplePerPixel;
            for (int k2 = 0; k2 < total; k2 += samplePerPixel) {
                for (int s2 = 0; s2 < samplePerPixel - 1; ++s2) {
                    outBuf[optr++] = outBuf[k2 + s2];
                }
                mask[mptr++] = outBuf[k2 + samplePerPixel - 1];
            }
        } else {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("extra.samples.are.not.supported", new Object[0]));
        }
        zip2.write(outBuf, 0, optr);
        mzip.write(mask, 0, mptr);
        return null;
    }

    static long[] getArrayLongShort(TIFFDirectory dir, int tag) {
        long[] offset;
        TIFFField field2 = dir.getField(tag);
        if (field2 == null) {
            return null;
        }
        if (field2.getType() == 4) {
            offset = field2.getAsLongs();
        } else {
            char[] temp = field2.getAsChars();
            offset = new long[temp.length];
            for (int k2 = 0; k2 < temp.length; ++k2) {
                offset[k2] = temp[k2];
            }
        }
        return offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void decodePackbits(byte[] data2, byte[] dst) {
        int srcCount = 0;
        int dstCount = 0;
        try {
            block2: while (dstCount < dst.length) {
                int i2;
                byte b2;
                if ((b2 = data2[srcCount++]) >= 0 && b2 <= 127) {
                    i2 = 0;
                    while (true) {
                        if (i2 >= b2 + 1) continue block2;
                        dst[dstCount++] = data2[srcCount++];
                        ++i2;
                    }
                }
                if (b2 <= -1 && b2 >= -127) {
                    byte repeat = data2[srcCount++];
                    i2 = 0;
                    while (true) {
                        if (i2 >= -b2 + 1) continue block2;
                        dst[dstCount++] = repeat;
                        ++i2;
                    }
                }
                ++srcCount;
            }
            return;
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    public static void inflate(byte[] deflated, byte[] inflated) {
        Inflater inflater = new Inflater();
        inflater.setInput(deflated);
        try {
            inflater.inflate(inflated);
        }
        catch (DataFormatException dfe) {
            throw new ExceptionConverter(dfe);
        }
    }

    public static void applyPredictor(byte[] uncompData, int predictor, int w2, int h2, int samplesPerPixel) {
        if (predictor != 2) {
            return;
        }
        for (int j2 = 0; j2 < h2; ++j2) {
            int count = samplesPerPixel * (j2 * w2 + 1);
            for (int i2 = samplesPerPixel; i2 < w2 * samplesPerPixel; ++i2) {
                int n2 = count;
                uncompData[n2] = (byte)(uncompData[n2] + uncompData[count - samplesPerPixel]);
                ++count;
            }
        }
    }
}

