/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock.normalizer.processor;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.datablock.normalizer.processor.AbstractProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProcessorEvaluator<T extends DataBlock> {
    private List<AbstractProcessor<T>> processors = new ArrayList<AbstractProcessor<T>>();

    public void process(List<DataBlock> dataBlocks) {
        this.evalProcessors(dataBlocks);
    }

    public void registerProcessor(AbstractProcessor<T> processor) {
        this.processors.add(processor);
    }

    private void evalProcessors(List<DataBlock> dataBlocks) {
        for (AbstractProcessor<DataBlock> abstractProcessor : this.processors) {
            for (DataBlock dataBlock : dataBlocks) {
                if (!abstractProcessor.getClassOfDataBlock().isAssignableFrom(dataBlock.getClass())) continue;
                abstractProcessor.preprocess(dataBlock);
            }
            abstractProcessor.preprocessFinished();
            Iterator<DataBlock> iterator = dataBlocks.iterator();
            while (iterator.hasNext()) {
                DataBlock dataBlock = iterator.next();
                if (!abstractProcessor.getClassOfDataBlock().isAssignableFrom(dataBlock.getClass()) || !abstractProcessor.isBad(dataBlock)) continue;
                iterator.remove();
            }
        }
    }
}

