/*
 * Decompiled with CFR 0.152.
 */
package gde.device.gpx;

import gde.DataAccess;
import gde.GDE;
import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.gpx.GPXAdapterDialog;
import gde.device.gpx.GPXDataReaderWriter;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.io.LogViewReader;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GPXAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(GPXAdapter.class.getName());
    final DataExplorer application;
    final Channels channels;
    final GPXAdapterDialog dialog;
    public static final Map<String, String> languageMap = new HashMap<String, String>();
    public static final Map<String, String> symbolMap = new HashMap<String, String>();
    public static final Map<String, String> unitMap = new HashMap<String, String>();
    public static final Map<String, Double> factorMap = new HashMap<String, Double>();
    public static final Map<String, Double> offsetMap = new HashMap<String, Double>();
    public static final Map<String, Double> reductionMap = new HashMap<String, Double>();
    public static final Map<String, Boolean> ignoreMap = new HashMap<String, Boolean>();
    public static final Map<String, Boolean> syncMap = new HashMap<String, Boolean>();

    public GPXAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.gpx.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new GPXAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1780"), Messages.getString((String)"GDE_MSGT1780"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.readProperties();
    }

    public GPXAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.gpx.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new GPXAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT1780"), Messages.getString((String)"GDE_MSGT1780"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
        this.readProperties();
    }

    private void readProperties() {
        DataAccess.getInstance().checkMappingFileAndCreate(((Object)((Object)this)).getClass(), "GPXAdapter.properties");
        try (InputStream stream = DataAccess.getInstance().getMappingInputStream("GPXAdapter.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            for (String propertyName : properties.stringPropertyNames()) {
                if (propertyName.startsWith("unit")) {
                    unitMap.put(propertyName.split("_")[1], properties.getProperty(propertyName).trim());
                    continue;
                }
                if (propertyName.startsWith("language")) {
                    languageMap.put(propertyName.substring(propertyName.indexOf(95) + 1), properties.getProperty(propertyName).trim());
                    continue;
                }
                if (propertyName.startsWith("sync")) {
                    syncMap.put(propertyName.substring(propertyName.indexOf(95) + 1), true);
                    continue;
                }
                if (propertyName.startsWith("ignore")) {
                    ignoreMap.put(propertyName.substring(propertyName.indexOf(95) + 1), true);
                    continue;
                }
                if (propertyName.startsWith("symbol")) {
                    symbolMap.put(propertyName.substring(propertyName.indexOf(95) + 1), properties.getProperty(propertyName).trim());
                    continue;
                }
                try {
                    if (propertyName.startsWith("factor")) {
                        factorMap.put(propertyName.substring(propertyName.indexOf(95) + 1), Double.valueOf(properties.getProperty(propertyName).trim()));
                        continue;
                    }
                    if (propertyName.startsWith("offset")) {
                        offsetMap.put(propertyName.substring(propertyName.indexOf(95) + 1), Double.valueOf(properties.getProperty(propertyName).trim()));
                        continue;
                    }
                    if (!propertyName.startsWith("reduction")) continue;
                    reductionMap.put(propertyName.substring(propertyName.indexOf(95) + 1), Double.valueOf(properties.getProperty(propertyName).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            String preopertyFilePath = "Mapping/GPXAdapter.properties";
            this.application.openMessageDialog(Messages.getString((String)"GDE_MSGW1776", (Object[])new String[]{preopertyFilePath}));
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block6: {
            NMEAParser data = new NMEAParser(this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), (IDevice)this, this.channels.getActiveChannelNumber(), this.getUTCdelta());
            String sThreadId = String.format("%06d", Thread.currentThread().threadId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                int lastLength = 0;
                for (int i = 0; i < recordDataSize; ++i) {
                    byte[] subLengthBytes = new byte[4];
                    System.arraycopy(dataBuffer, lastLength, subLengthBytes, 0, 4);
                    int subLenght = LogViewReader.parse2Int((byte[])subLengthBytes) - 8;
                    byte[] lineBuffer = new byte[subLenght];
                    System.arraycopy(dataBuffer, 4 + lastLength, lineBuffer, 0, subLenght);
                    String textInput = new String(lineBuffer, "ISO-8859-1");
                    StringTokenizer st = new StringTokenizer(textInput);
                    Vector<String> vec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        vec.add(st.nextToken("\r\n"));
                    }
                    data.parse(vec, vec.size());
                    lastLength += subLenght + 12;
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block6;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getOrdinal() == 0 || record.getOrdinal() == 1;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getOrdinal() > 1 ? (record.getName().toLowerCase().indexOf("flag") >= 0 ? String.format("0x%02x", record.realGet(rowIndex) / 1000) : record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor)) : String.format("%02.7f", (double)record.realGet(rowIndex).intValue() / 1000000.0);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + this.getMeasurementNameReplacement(recordSet.getChannelConfigNumber(), i));
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, i + " " + record.getName() + " hasReasonableData = " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.application.updateStatisticsData();
    }

    public GPXAdapterDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT1776"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GPXAdapter.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = GPXAdapter.this.dialog != null && !GPXAdapter.this.dialog.isDisposed() ? Integer.valueOf(GPXAdapter.this.dialog.getTabFolderSelectionIndex() + 1) : null;
                            String recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 4, selectedImportFile.lastIndexOf(46));
                            GPXDataReaderWriter.read(selectedImportFile, GPXAdapter.this, recordNameExtend, channelConfigNumber);
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    GPXAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT1781"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DRelativeItem action performed! " + String.valueOf(e));
                    GPXAdapter.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1782"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    GPXAdapter.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT1783"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    GPXAdapter.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT1779"), 1, 0, 2, 7, 9, 11, -1, type == 0, type == 2);
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(0).hasReasonableData() && activeRecordSet.get(1).hasReasonableData() && activeRecordSet.get(2).hasReasonableData();
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(1, 0, 2, additionalMeasurementOrdinal, this.findRecordByUnit(activeRecordSet, "m/s"), this.findRecordByUnit(activeRecordSet, "km"), -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    private int findRecordByUnit(RecordSet recordSet, String unit) {
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.getUnit().equalsIgnoreCase(unit)) continue;
            return record.getOrdinal();
        }
        return -1;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null && this.application.getActiveRecordSet() != null) {
            return this.findRecordByUnit(this.application.getActiveRecordSet(), "km/h");
        }
        return this.kmzMeasurementOrdinal;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        Record recordLatitude = recordSet.get(0);
        Record recordLongitude = recordSet.get(1);
        Record baroAlitude = recordSet.get(2);
        Record gpsAlitude = recordSet.get(2);
        return String.format("%02d%05d%s%03d%05d%s%c%05d%05d", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), Double.valueOf((double)baroAlitude.get(index).intValue() / 10000.0 + (double)startAltitude + (double)offsetAltitude).intValue(), Double.valueOf((double)gpsAlitude.get(index).intValue() / 1000.0 + (double)offsetAltitude).intValue());
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT1784", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT1784"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    GPXAdapter.this.open_closeCommPort();
                }
            });
        }
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordNames = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordNames.length - fileRecordsProperties.length > 0) {
            for (String recordProps : fileRecordsProperties) {
                cleanedRecordNames.add((String)StringHelper.splitString((String)recordProps, (String)"|-|", (String[])Record.propertyKeys).get(Record.propertyKeys[0]));
            }
            recordNames = cleanedRecordNames.toArray(new String[1]);
            recordSet.clear();
            for (int j = 0; j < recordNames.length; ++j) {
                MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), j);
                recordSet.addRecordName(recordNames[j]);
                recordSet.put(recordNames[j], (AbstractRecord)new Record((IDevice)this, j, recordNames[j], measurement.getSymbol(), measurement.getUnit(), measurement.isActive(), measurement.getStatistics(), measurement.getProperty(), 5));
            }
        }
        return recordNames;
    }
}

