/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.TabAreaContextMenu;
import gde.ui.tab.CellVoltageWindow;
import gde.utils.CellVoltageValues;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class CellVoltageDisplay
extends Composite {
    static final Logger log = Logger.getLogger(CellVoltageDisplay.class.getName());
    CLabel cellTextLabel;
    CLabel cellVoltageDigitalLabel;
    Canvas cellCanvas;
    Composite fillRight;
    Composite fillLeft;
    Composite cellComposite;
    Label upperVoltage;
    Label middleVoltage;
    Label lowerVoltage;
    final CellVoltageWindow parent;
    final DataExplorer application;
    final String displayHeaderText;
    final Color backgroundColor;
    final Menu popupmenu;
    final TabAreaContextMenu contextMenu;
    int voltage;
    int lastTop;
    int lastVoltageLevel;
    final int lowerLimitColorRed;
    final int upperLimitColorRed;
    final int lowerLimitColorGreen;
    final int deltaSpreadVoltage = 50;
    final int beginSpreadVoltage;
    final int upperLimitVoltage;
    final int lowerLimitVoltage;

    public CellVoltageDisplay(DataExplorer currentApplication, Composite cellVoltageMainComposite, int measurementValue, String measurementName, String measurementUnit, CellVoltageWindow useParent) {
        super(cellVoltageMainComposite, 2048);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.voltage = 0;
        this.lastTop = 0;
        this.lastVoltageLevel = 0;
        this.deltaSpreadVoltage = 50;
        this.voltage = measurementValue;
        this.displayHeaderText = String.format("%s [%S]", measurementName, measurementUnit);
        this.application = currentApplication;
        this.parent = useParent;
        this.backgroundColor = Settings.getInstance().getCellVoltageInnerAreaBackground();
        this.setBackground(this.backgroundColor);
        GridLayout mainCompositeLayout = new GridLayout();
        mainCompositeLayout.makeColumnsEqualWidth = true;
        mainCompositeLayout.verticalSpacing = 0;
        mainCompositeLayout.marginHeight = 0;
        mainCompositeLayout.marginWidth = 0;
        this.setLayout((Layout)mainCompositeLayout);
        int[] voltageLimits = CellVoltageValues.getVoltageLimits();
        this.upperLimitVoltage = voltageLimits[0];
        this.upperLimitColorRed = voltageLimits[1];
        this.lowerLimitColorGreen = voltageLimits[2];
        this.beginSpreadVoltage = voltageLimits[3];
        this.lowerLimitColorRed = voltageLimits[4];
        this.lowerLimitVoltage = voltageLimits[5];
        this.popupmenu = new Menu((Decorations)this.application.getShell(), 8);
        this.setMenu(this.popupmenu);
        this.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "CellVoltageDisplay.helpRequested " + String.valueOf(evt));
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_9.html");
            }
        });
        this.contextMenu = new TabAreaContextMenu();
        this.contextMenu.createMenu(this.popupmenu, TabAreaContextMenu.TabMenuType.SIMPLE);
    }

    public void create() {
        this.cellTextLabel = new CLabel((Composite)this, 0x1000000);
        this.cellTextLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE, 0));
        this.cellTextLabel.setBackground(this.backgroundColor);
        this.cellTextLabel.setText(this.displayHeaderText);
        this.cellTextLabel.setMenu(this.popupmenu);
        GridData text1LData = new GridData();
        text1LData.horizontalAlignment = 4;
        text1LData.grabExcessHorizontalSpace = true;
        this.cellTextLabel.setLayoutData((Object)text1LData);
        this.cellVoltageDigitalLabel = new CLabel((Composite)this, 0x1000000);
        this.cellVoltageDigitalLabel.setBackground(this.backgroundColor);
        this.cellVoltageDigitalLabel.setMenu(this.popupmenu);
        this.cellVoltageDigitalLabel.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + 22, 0));
        this.cellVoltageDigitalLabel.setText("0,00");
        GridData actualDigitalLabelLData = new GridData();
        actualDigitalLabelLData.horizontalAlignment = 4;
        actualDigitalLabelLData.grabExcessHorizontalSpace = true;
        this.cellVoltageDigitalLabel.setLayoutData((Object)actualDigitalLabelLData);
        this.cellComposite = new Composite((Composite)this, 0);
        GridData canvas1LData = new GridData();
        canvas1LData.horizontalAlignment = 4;
        canvas1LData.grabExcessHorizontalSpace = true;
        canvas1LData.grabExcessVerticalSpace = true;
        canvas1LData.verticalAlignment = 4;
        this.cellComposite.setLayoutData((Object)canvas1LData);
        FillLayout canvas1Layout = new FillLayout(256);
        canvas1Layout.marginHeight = 0;
        canvas1Layout.marginWidth = 0;
        this.cellComposite.setLayout((Layout)canvas1Layout);
        this.cellComposite.setMenu(this.popupmenu);
        this.fillLeft = new Composite(this.cellComposite, 0);
        this.fillLeft.setDragDetect(false);
        this.fillLeft.setEnabled(false);
        this.fillLeft.setBackground(this.backgroundColor);
        this.upperVoltage = new Label(this.fillLeft, 0);
        this.upperVoltage.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE, 0));
        this.middleVoltage = new Label(this.fillLeft, 0);
        this.middleVoltage.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE, 0));
        this.lowerVoltage = new Label(this.fillLeft, 0);
        this.lowerVoltage.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE, 0));
        this.cellCanvas = new Canvas(this.cellComposite, 0);
        this.cellCanvas.setDragDetect(false);
        this.cellCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "cellCanvas.paintControl, evt = " + String.valueOf(evt));
                }
                CellVoltageDisplay.this.voltagePaintControl(evt.gc);
            }
        });
        this.fillRight = new Composite(this.cellComposite, 0);
        this.fillRight.setEnabled(false);
        this.fillRight.setDragDetect(false);
        this.fillRight.setBackground(this.backgroundColor);
        this.layout();
    }

    public int getVoltage() {
        return this.voltage;
    }

    public void setVoltage(int newVoltage) {
        if (this.voltage != newVoltage) {
            this.voltage = newVoltage;
            String valueText = String.format("%.3f", (double)this.voltage / 1000.0);
            this.cellVoltageDigitalLabel.setText(valueText);
            Rectangle rect = this.cellCanvas.getClientArea();
            Point topHeight = this.calculateBarGraph(rect);
            if (this.lastVoltageLevel != this.checkVoltageLevel()) {
                this.cellCanvas.redraw();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, newVoltage + " redraw , " + topHeight.x + " -> " + topHeight.y);
                }
            } else if (this.lastTop < topHeight.x) {
                int top = this.lastTop - 1 < 0 ? 0 : this.lastTop - 1;
                int height = topHeight.x + 1 > rect.height - 1 ? rect.height - 1 : topHeight.x + 1;
                this.cellCanvas.redraw(0, top, rect.width - 1, height, false);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, newVoltage + " redraw , " + top + " -> " + height);
                }
            } else {
                int top = topHeight.x - 1 < 0 ? 0 : topHeight.x - 1;
                int height = this.lastTop + 1 > rect.height - 1 ? rect.height - 1 : this.lastTop + 1;
                this.cellCanvas.redraw(0, top, rect.width - 1, height, false);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, newVoltage + " redraw , " + top + " -> " + height);
                }
            }
        }
    }

    void voltagePaintControl(GC gc) {
        String valueText = String.format("%.3f", (double)this.voltage / 1000.0);
        this.cellVoltageDigitalLabel.setText(valueText);
        Rectangle rect = this.cellCanvas.getClientArea();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "cellCanvas.getBounds = " + String.valueOf(rect));
        }
        Point topHeight = this.calculateBarGraph(rect);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, valueText + " redraw , " + topHeight.x + " -> " + topHeight.y);
        }
        rect = new Rectangle(0, topHeight.x, rect.width - 1, topHeight.y);
        this.upperVoltage.setLocation(10, rect.x);
        this.upperVoltage.setText(String.format("%.1f", (double)this.upperLimitVoltage / 1000.0));
        this.middleVoltage.setLocation(10, 200);
        this.middleVoltage.setText(String.format("%.1f", (double)(this.lowerLimitVoltage + (this.upperLimitVoltage - this.lowerLimitVoltage) / 2) / 1000.0));
        this.lowerVoltage.setLocation(10, 300);
        this.lowerVoltage.setText(String.format("%.1f", (double)this.lowerLimitVoltage / 1000.0));
        this.lastVoltageLevel = this.checkVoltageLevel();
        switch (this.lastVoltageLevel) {
            case 1: {
                gc.setBackground(SWTResourceManager.getColor(3));
                break;
            }
            default: {
                gc.setBackground(SWTResourceManager.getColor(7));
                break;
            }
            case 3: {
                gc.setBackground(SWTResourceManager.getColor(5));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "fillRectangle = " + String.valueOf(rect));
        }
        gc.setForeground(SWTResourceManager.getColor(22));
        gc.drawLine(1, this.lastTop, rect.width - 1, this.lastTop);
        this.lastTop = topHeight.x;
        gc.fillRectangle(1, topHeight.x, rect.width - 1, topHeight.y);
        gc.setForeground(SWTResourceManager.getColor(2));
        gc.drawLine(1, topHeight.x, rect.width - 1, topHeight.x);
        gc.drawLine(0, 0, rect.width, 0);
        gc.drawLine(rect.width, 0, rect.width, rect.height + topHeight.x);
        gc.drawLine(0, 0, 0, rect.height + topHeight.x);
    }

    int checkVoltageLevel() {
        int voltageLevel = this.voltage < this.lowerLimitColorRed || this.voltage > this.upperLimitColorRed ? 1 : (this.voltage >= this.lowerLimitColorRed && this.voltage <= this.lowerLimitColorGreen ? 2 : 3);
        return voltageLevel;
    }

    Point calculateBarGraph(Rectangle cellCanvasBounds) {
        Point topHeight = new Point(0, 0);
        int baseVoltage = this.lowerLimitVoltage;
        if (this.parent.getVoltageDelta() < this.deltaSpreadVoltage && this.parent.getVoltageAvg() > this.beginSpreadVoltage) {
            baseVoltage = this.beginSpreadVoltage;
        }
        Double delta = (double)cellCanvasBounds.height / (1.0 * (double)this.upperLimitVoltage - (double)baseVoltage) * (1.0 * (double)this.upperLimitVoltage - (double)this.voltage);
        topHeight.x = (int)(delta + 0.5);
        topHeight.y = cellCanvasBounds.height - topHeight.x;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, topHeight.toString());
        }
        return topHeight;
    }
}

