/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MeasurementControl
extends Composite {
    static final Logger log = Logger.getLogger(MeasurementControl.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final DeviceDialog dialog;
    final MeasurementType measurementType;
    final int ordinal;
    final int channelConfigNumber;

    public MeasurementControl(Composite parentComposite, DeviceDialog parentDialog, int useChannelConfigNumber, int useOrdinal, MeasurementType useMeasurementType, IDevice useDevice, int horizontalSpan) {
        super(parentComposite, 0);
        this.dialog = parentDialog;
        this.channelConfigNumber = useChannelConfigNumber;
        this.ordinal = useOrdinal;
        this.measurementType = useMeasurementType;
        this.device = useDevice;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        RowLayout thisLayout = new RowLayout(256);
        GridData thisLData = new GridData();
        thisLData.horizontalSpan = horizontalSpan;
        thisLData.horizontalAlignment = 1;
        thisLData.verticalAlignment = 1;
        thisLData.heightHint = 23;
        this.setLayoutData(thisLData);
        this.setLayout((Layout)thisLayout);
        this.measurement = new Button((Composite)this, 0x1000020);
        RowData measurementLData = new RowData();
        measurementLData.width = 170;
        measurementLData.height = 20;
        this.measurement.setLayoutData((Object)measurementLData);
        this.measurement.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurement.setText(this.measurementType.getName());
        this.measurement.setToolTipText(Messages.getString("GDE_MSGT0299"));
        this.measurement.setSelection(this.measurementType.isActive());
        this.measurement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "measurement.widgetSelected, event=" + String.valueOf(evt));
                }
                boolean isVisible = MeasurementControl.this.measurement.getSelection();
                Channel activeChannel = MeasurementControl.this.channels.getActiveChannel();
                if (activeChannel != null) {
                    MeasurementControl.this.device.setMeasurementActive(activeChannel.getNumber(), MeasurementControl.this.ordinal, isVisible);
                    RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                    if (activeRecordSet != null) {
                        activeRecordSet.get(MeasurementControl.this.ordinal).setVisible(isVisible);
                        activeRecordSet.get(MeasurementControl.this.ordinal).setDisplayable(isVisible);
                        MeasurementControl.this.device.updateVisibilityStatus(activeRecordSet, false);
                        MeasurementControl.this.application.updateGraphicsWindow();
                    }
                }
                MeasurementControl.this.dialog.enableSaveButton(true);
            }
        });
        this.measurementSymbolLabel = new Label((Composite)this, 0x1000000);
        RowData measurementSymbolLabelLData = new RowData();
        measurementSymbolLabelLData.width = 50;
        measurementSymbolLabelLData.height = 20;
        this.measurementSymbolLabel.setLayoutData((Object)measurementSymbolLabelLData);
        this.measurementSymbolLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurementSymbolLabel.setText(this.measurementType.getSymbol());
        this.measurementUnitLabel = new Label((Composite)this, 0x1000000);
        RowData measurementUnitLabelLData = new RowData();
        measurementUnitLabelLData.width = 50;
        measurementUnitLabelLData.height = 20;
        this.measurementUnitLabel.setLayoutData((Object)measurementUnitLabelLData);
        this.measurementUnitLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurementUnitLabel.setText("[" + this.measurementType.getUnit() + "]");
    }
}

