/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui.menu;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.histo.datasources.SourceDataSet;
import gde.histo.datasources.SourceFolders;
import gde.histo.ui.ExclusionActivity;
import gde.histo.ui.HistoExplorer;
import gde.histo.utils.PathUtils;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.tab.GraphicsWindow;
import gde.utils.FileUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractTabAreaContextMenu {
    private static final String $CLASS_NAME = AbstractTabAreaContextMenu.class.getName();
    protected static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final DataExplorer application = DataExplorer.getInstance();
    protected final HistoExplorer presentHistoExplorer = DataExplorer.getInstance().getPresentHistoExplorer();
    protected final Settings settings = Settings.getInstance();
    protected boolean isCreated = false;
    protected MenuItem curveSelectionItem;
    protected MenuItem displayGraphicsHeaderItem;
    protected MenuItem displayGraphicsCommentItem;
    protected MenuItem displayGraphicsCurveSurvey;
    protected MenuItem suppressModeItem;
    protected MenuItem partialTableItem;
    protected MenuItem copyTabItem;
    protected MenuItem copyPrintImageItem;
    protected MenuItem fileName;
    protected MenuItem openRecordSetItem;
    protected MenuItem deleteFileItem;
    protected MenuItem openFolderItem;
    protected Menu hideMenu;
    protected Menu trackMenu;
    protected MenuItem hideItem;
    protected MenuItem hideMenuRecordSetItem;
    protected MenuItem hideMenuFileItem;
    protected MenuItem hideMenuRevokeItem;
    protected MenuItem trackItem;

    public abstract void createMenu(Menu var1);

    protected void createCheckItems(Menu popupMenu) {
        this.suppressModeItem = new MenuItem(popupMenu, 32);
        this.suppressModeItem.setText(Messages.getString("GDE_MSGT0859"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.suppressModeItem.setToolTipText(Messages.getString("GDE_MSGT0860"));
        }
        this.suppressModeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "suppressModeItem.widgetSelected, event=" + String.valueOf(evt));
                }
                AbstractTabAreaContextMenu.this.settings.setSuppressMode(AbstractTabAreaContextMenu.this.suppressModeItem.getSelection());
                AbstractTabAreaContextMenu.this.application.getMenuBar().getSuppressModeItem().setSelection(AbstractTabAreaContextMenu.this.suppressModeItem.getSelection());
                AbstractTabAreaContextMenu.this.presentHistoExplorer.resetHisto();
            }
        });
        this.curveSelectionItem = new MenuItem(popupMenu, 32);
        this.curveSelectionItem.setText(Messages.getString("GDE_MSGT0040"));
        this.curveSelectionItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "curveSelectionItem action performed! " + String.valueOf(e));
                boolean selection = AbstractTabAreaContextMenu.this.curveSelectionItem.getSelection();
                AbstractTabAreaContextMenu.this.application.enableCurveSelector(selection);
                AbstractTabAreaContextMenu.this.application.getMenuBar().getCurveSelectionMenuItem().setSelection(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.displayGraphicsHeaderItem = new MenuItem(popupMenu, 32);
        this.displayGraphicsHeaderItem.setText(Messages.getString("GDE_MSGT0041"));
        this.displayGraphicsHeaderItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "toggleViewGraphicsHeaderItem action performed! " + String.valueOf(e));
                boolean selection = AbstractTabAreaContextMenu.this.displayGraphicsHeaderItem.getSelection();
                AbstractTabAreaContextMenu.this.application.getMenuBar().getGraphicsHeaderMenuItem().setSelection(selection);
                AbstractTabAreaContextMenu.this.application.enableGraphicsHeader(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.displayGraphicsCommentItem = new MenuItem(popupMenu, 32);
        this.displayGraphicsCommentItem.setText(Messages.getString("GDE_MSGT0042"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.displayGraphicsCommentItem.setToolTipText(Messages.getString("GDE_MSGT0878"));
        }
        this.displayGraphicsCommentItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "toggleViewGraphicsCommentItem action performed! " + String.valueOf(e));
                boolean selection = AbstractTabAreaContextMenu.this.displayGraphicsCommentItem.getSelection();
                AbstractTabAreaContextMenu.this.application.getMenuBar().getRecordCommentMenuItem().setSelection(selection);
                AbstractTabAreaContextMenu.this.application.enableRecordSetComment(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.displayGraphicsCurveSurvey = new MenuItem(popupMenu, 32);
        this.displayGraphicsCurveSurvey.setText(Messages.getString("GDE_MSGT0876"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.displayGraphicsCurveSurvey.setToolTipText(Messages.getString("GDE_MSGT0877"));
        }
        this.displayGraphicsCurveSurvey.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "displayGraphicsCurveSurvey action performed! " + String.valueOf(e));
                boolean selection = AbstractTabAreaContextMenu.this.displayGraphicsCurveSurvey.getSelection();
                AbstractTabAreaContextMenu.this.application.getMenuBar().getGraphicsCurveSurveyMenuItem().setSelection(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.enableCurveSurvey(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.partialTableItem = new MenuItem(popupMenu, 32);
        this.partialTableItem.setText(Messages.getString("GDE_MSGT0704"));
        this.partialTableItem.setSelection(Settings.getInstance().isPartialDataTable());
        this.partialTableItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "partialTableItem action performed! " + String.valueOf(e));
                boolean selection = AbstractTabAreaContextMenu.this.partialTableItem.getSelection();
                AbstractTabAreaContextMenu.this.application.getMenuBar().getPartialTableMenuItem().setSelection(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.enablePartialDataTable(selection);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
    }

    protected void createCopyItems(Menu popupMenu) {
        this.copyTabItem = new MenuItem(popupMenu, 8);
        this.copyTabItem.setText(Messages.getString("GDE_MSGT0026").substring(0, Messages.getString("GDE_MSGT0026").lastIndexOf(9)));
        this.copyTabItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "copyTabItem action performed! " + String.valueOf(e));
                AbstractTabAreaContextMenu.this.application.copyTabContentAsImage();
            }
        });
        this.copyPrintImageItem = new MenuItem(popupMenu, 8);
        this.copyPrintImageItem.setText(Messages.getString("GDE_MSGT0027").substring(0, Messages.getString("GDE_MSGT0027").lastIndexOf(9)));
        this.copyPrintImageItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "copyPrintImageItem action performed! " + String.valueOf(e));
                AbstractTabAreaContextMenu.this.application.copyGraphicsPrintImage();
            }
        });
    }

    protected void createFileItems(final Menu popupMenu) {
        this.fileName = new MenuItem(popupMenu, 0);
        this.fileName.setText(">> [" + Messages.getString("GDE_MSGT0864") + "] <<");
        if (!GDE.IS_OS_ARCH_ARM) {
            this.fileName.setToolTipText(Messages.getString("GDE_MSGT0863"));
        }
        new MenuItem(popupMenu, 2);
        this.openRecordSetItem = new MenuItem(popupMenu, 8);
        this.openRecordSetItem.setText(Messages.getString("GDE_MSGT0849"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.openRecordSetItem.setToolTipText(Messages.getString("GDE_MSGT0851"));
        }
        this.openRecordSetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "openRecordSetItem.widgetSelected, event=" + String.valueOf(evt));
                }
                SourceDataSet sourceDataSet = SourceDataSet.createSourceDataSet(Paths.get((String)popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString()), new String[0]), Analyzer.getInstance());
                String recordSetName = popupMenu.getData(TabMenuOnDemand.RECORDSET_BASE_NAME.toString()).toString().split(Pattern.quote(" | "))[0];
                if (sourceDataSet != null && sourceDataSet.load(recordSetName)) {
                    AbstractTabAreaContextMenu.this.application.selectTab(c -> c instanceof GraphicsWindow && ((GraphicsWindow)((Object)c)).getGraphicsType().equals((Object)GraphicsWindow.GraphicsType.NORMAL));
                    AbstractTabAreaContextMenu.this.application.updateGraphicsWindow();
                }
            }
        });
        this.deleteFileItem = new MenuItem(popupMenu, 8);
        this.deleteFileItem.setText(Messages.getString("GDE_MSGT0861"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.deleteFileItem.setToolTipText(Messages.getString("GDE_MSGT0862"));
        }
        this.deleteFileItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                File file;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "deleteFileItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (FileUtils.checkFileExist((file = new File((String)popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString()))).getPath())) {
                    String linkFilePath = (String)popupMenu.getData(TabMenuOnDemand.DATA_LINK_PATH.toString());
                    if (file.getPath().endsWith(".osd") && !linkFilePath.isEmpty()) {
                        FileUtils.deleteFile(linkFilePath);
                        if (AbstractTabAreaContextMenu.this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0071", new Object[]{file.getAbsolutePath()})) == 64) {
                            FileUtils.deleteFile(file.getPath());
                            AbstractTabAreaContextMenu.this.presentHistoExplorer.resetHisto();
                        }
                    } else if (AbstractTabAreaContextMenu.this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0050", new Object[]{file.getAbsolutePath()})) == 64) {
                        FileUtils.deleteFile(file.getPath());
                        AbstractTabAreaContextMenu.this.presentHistoExplorer.resetHisto();
                    }
                }
            }
        });
        this.openFolderItem = new MenuItem(popupMenu, 8);
        this.openFolderItem.setText(Messages.getString("GDE_MSGT0873"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.openFolderItem.setToolTipText(Messages.getString("GDE_MSGT0874"));
        }
        this.openFolderItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "openFolderItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(Paths.get((String)popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString()), new String[0]).getParent().toFile());
                    }
                    catch (IOException e) {
                        AbstractTabAreaContextMenu.this.application.openMessageDialogAsync(Messages.getString("GDE_MSGI0065"));
                    }
                }
            }
        });
        new MenuItem(popupMenu, 2);
        this.hideItem = new MenuItem(popupMenu, 64);
        this.hideItem.setText(Messages.getString("GDE_MSGT0852"));
        this.hideMenu = new Menu(this.hideItem);
        this.hideItem.setMenu(this.hideMenu);
        this.hideMenuRecordSetItem = new MenuItem(this.hideMenu, 8);
        this.hideMenuRecordSetItem.setText(Messages.getString("GDE_MSGT0853"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.hideMenuRecordSetItem.setToolTipText(Messages.getString("GDE_MSGT0854"));
        }
        this.hideMenuRecordSetItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "hideMenuRecordSetItem.widgetSelected, event=" + String.valueOf(evt));
                }
                ExclusionActivity.setExcludeRecordSet(Paths.get((String)popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString()), new String[0]), popupMenu.getData(TabMenuOnDemand.RECORDSET_BASE_NAME.toString()).toString());
                AbstractTabAreaContextMenu.this.settings.setSuppressMode(true);
                AbstractTabAreaContextMenu.this.application.getMenuBar().getSuppressModeItem().setSelection(true);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, true, true);
            }
        });
        this.hideMenuFileItem = new MenuItem(this.hideMenu, 8);
        this.hideMenuFileItem.setText(Messages.getString("GDE_MSGT0855"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.hideMenuFileItem.setToolTipText(Messages.getString("GDE_MSGT0856"));
        }
        this.hideMenuFileItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "hideMenuFileItem.widgetSelected, event=" + String.valueOf(evt));
                }
                ExclusionActivity.setExcludeRecordSet(Paths.get(popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString()).toString(), new String[0]), "");
                AbstractTabAreaContextMenu.this.settings.setSuppressMode(true);
                AbstractTabAreaContextMenu.this.application.getMenuBar().getSuppressModeItem().setSelection(true);
                AbstractTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, true, true);
            }
        });
        new MenuItem(this.hideMenu, 2);
        this.hideMenuRevokeItem = new MenuItem(this.hideMenu, 8);
        this.hideMenuRevokeItem.setText(Messages.getString("GDE_MSGT0857"));
        this.hideMenuRevokeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String dataFilePath;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "hideMenuFileItem.widgetSelected, event=" + String.valueOf(evt));
                }
                if ((dataFilePath = (String)popupMenu.getData(TabMenuOnDemand.DATA_FILE_PATH.toString())) != null) {
                    ExclusionActivity.clearExcludeLists();
                    AbstractTabAreaContextMenu.this.presentHistoExplorer.resetHisto();
                }
            }
        });
    }

    protected void setCoreEnabled(boolean enabled) {
        this.fileName.setEnabled(enabled);
        this.openRecordSetItem.setEnabled(enabled);
        this.deleteFileItem.setEnabled(enabled);
        this.openFolderItem.setEnabled(enabled);
        this.hideItem.setEnabled(enabled);
        this.hideMenuRecordSetItem.setEnabled(enabled);
        this.hideMenuFileItem.setEnabled(enabled);
        this.hideMenuRevokeItem.setEnabled(enabled);
        this.suppressModeItem.setEnabled(enabled);
        this.curveSelectionItem.setEnabled(enabled);
        this.displayGraphicsHeaderItem.setEnabled(enabled);
        this.displayGraphicsCommentItem.setEnabled(enabled);
        this.displayGraphicsCurveSurvey.setEnabled(enabled);
        this.copyTabItem.setEnabled(enabled);
        this.copyPrintImageItem.setEnabled(enabled);
        this.partialTableItem.setEnabled(enabled);
    }

    protected void setCommonItems(Menu popupMenu) {
        String excludedText;
        this.suppressModeItem.setSelection(this.application.getMenuBar().getSuppressModeItem().getSelection());
        this.curveSelectionItem.setSelection(this.application.getMenuBar().getCurveSelectionMenuItem().getSelection());
        this.displayGraphicsHeaderItem.setSelection(this.application.getMenuBar().getGraphicsHeaderMenuItem().getSelection());
        this.displayGraphicsCommentItem.setSelection(this.application.getMenuBar().getRecordCommentMenuItem().getSelection());
        this.displayGraphicsCurveSurvey.setSelection(this.application.getMenuBar().getGraphicsCurveSurveyMenuItem().getSelection());
        this.partialTableItem.setSelection(this.application.getMenuBar().getPartialTableMenuItem().getSelection());
        String excludedList = (String)popupMenu.getData(TabMenuOnDemand.EXCLUDED_LIST.toString());
        if (excludedList == null) {
            excludedList = "";
        }
        String string = excludedText = excludedList.isEmpty() ? "" : " " + excludedList.replace(",", "\n ") + "\n";
        if (!GDE.IS_OS_ARCH_ARM) {
            this.hideItem.setToolTipText(excludedText + Messages.getString("GDE_MSGT0798"));
        }
        if (!GDE.IS_OS_ARCH_ARM) {
            this.hideMenuRevokeItem.setToolTipText(excludedText + Messages.getString("GDE_MSGT0858"));
        }
        this.fileName.setText(">> [" + Messages.getString("GDE_MSGT0864") + "] <<");
        this.openRecordSetItem.setText(Messages.getString("GDE_MSGT0849"));
    }

    protected void setDataPathItems(Menu popupMenu, Path dataPath) {
        this.openFolderItem.setEnabled(Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
        String tmpFileName = dataPath.getFileName().toString();
        String displayName = tmpFileName.length() > 22 ? "..." + tmpFileName.substring(tmpFileName.length() - 22) : tmpFileName;
        this.fileName.setText(">> " + displayName.toString() + " : " + String.format("%1.22s", popupMenu.getData(TabMenuOnDemand.RECORDSET_BASE_NAME.toString()).toString()) + " <<");
        List<String> dataSetExtentions = SourceFolders.DirectoryType.IMPORT.getDataSetExtentions(Analyzer.getInstance().getActiveDevice(), Analyzer.getInstance().getSettings());
        boolean isImport = dataSetExtentions.contains(PathUtils.getFileExtention(dataPath));
        this.openRecordSetItem.setText(Messages.getString(isImport ? "GDE_MSGT0850" : "GDE_MSGT0849"));
    }

    public static enum TabMenuOnDemand {
        IS_CURSOR_IN_CANVAS,
        DATA_LINK_PATH,
        DATA_FILE_PATH,
        RECORDSET_BASE_NAME,
        EXCLUDED_LIST,
        SUMMARY_WARNING;

    }
}

