/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import com.sun.istack.Nullable;
import gde.GDE;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.AbstractChartWindow;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.menu.CurveSelectorContextMenu;
import gde.utils.ColorUtils;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class SelectorComposite
extends Composite {
    private static final String $CLASS_NAME = SelectorComposite.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int TEXT_EXTENT_FACTOR = 6;
    private static final int YGAP_CHARTSELECTOR = GDE.IS_WINDOWS ? 2 : 0;
    private static final int COMBO_COLUMN_ORDINAL = 1;
    private final DataExplorer application;
    private final Menu popupmenu;
    final CurveSelectorContextMenu contextMenu;
    private Button curveSelectorHeader;
    private Button chartSelector;
    private Button smartSelector;
    private Button saveTemplate;
    private int initialSelectorHeaderWidth;
    private int selectorColumnWidth;
    private Table curveSelectorTable;
    private TableColumn tableSelectorColumn;
    private TableColumn tableCurveTypeColumn;
    private int initialCurveTypeColumnWidth;
    private int curveTypeColumnWidth;
    private int oldSelectorColumnWidth = 0;
    private TableEditor[] editors = new TableEditor[0];
    private AbstractChartWindow.WindowActor windowActor;

    public SelectorComposite(SashForm useParent, AbstractChartWindow parentWindow) {
        super((Composite)useParent, 0);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.application = DataExplorer.getInstance();
        this.popupmenu = new Menu((Decorations)DataExplorer.getInstance().getShell(), 8);
        this.contextMenu = new CurveSelectorContextMenu();
        this.contextMenu.createMenu(this.popupmenu);
        this.windowActor = parentWindow.windowActor;
        this.initGUI();
    }

    public Button getCurveSelectorHeader() {
        return this.curveSelectorHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initGUI() {
        FormLayout curveSelectorLayout = new FormLayout();
        this.setBackground(this.application.COLOR_BACKGROUND);
        this.setLayout((Layout)curveSelectorLayout);
        GridData curveSelectorLData = new GridData();
        this.setLayoutData(curveSelectorLData);
        this.addHelpListener(new HelpListener(this){

            public void helpRequested(HelpEvent evt) {
                log.log(Level.FINEST, "helpRequested ", evt);
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_41.html");
            }
        });
        this.curveSelectorHeader = new Button((Composite)this, 16416);
        this.curveSelectorHeader.setText(Messages.getString("GDE_MSGT0254"));
        this.curveSelectorHeader.setToolTipText(Messages.getString("GDE_MSGT0671"));
        this.curveSelectorHeader.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE + 3, 1));
        this.curveSelectorHeader.pack();
        this.initialSelectorHeaderWidth = this.curveSelectorHeader.getSize().x + 8;
        FormData curveSelectorHeaderLData = new FormData();
        curveSelectorHeaderLData.height = 33;
        curveSelectorHeaderLData.left = new FormAttachment(0, 1000, GDE.IS_WINDOWS ? 6 : 0);
        curveSelectorHeaderLData.top = new FormAttachment(0, 1000, 0);
        this.curveSelectorHeader.setLayoutData((Object)curveSelectorHeaderLData);
        this.curveSelectorHeader.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setForeground(this.application.COLOR_FOREGROUND);
        this.curveSelectorHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.fine(() -> "curveSelectorHeader.widgetSelected, event=" + String.valueOf(evt));
                if (!SelectorComposite.this.curveSelectorHeader.getSelection()) {
                    SelectorComposite.this.resetContextMenuMeasuring();
                    SelectorComposite.this.windowActor.clearMeasuring();
                    for (TableItem tableItem : SelectorComposite.this.curveSelectorTable.getItems()) {
                        if (!tableItem.getChecked()) continue;
                        SelectorComposite.this.toggleRecordSelection(tableItem, false, false);
                    }
                } else {
                    for (TableItem tableItem : SelectorComposite.this.curveSelectorTable.getItems()) {
                        if (tableItem.getChecked()) continue;
                        SelectorComposite.this.toggleRecordSelection(tableItem, false, true);
                    }
                }
                SelectorComposite.this.windowActor.updateChartWindow(true);
            }
        });
        this.chartSelector = new Button((Composite)this, 0x40004008);
        FormData chartSelectorLData = new FormData();
        chartSelectorLData.width = GDE.IS_WINDOWS ? 26 : 33;
        chartSelectorLData.height = GDE.IS_WINDOWS ? 26 : 33;
        chartSelectorLData.left = new FormAttachment((Control)this.curveSelectorHeader);
        chartSelectorLData.top = new FormAttachment(0, 1000, YGAP_CHARTSELECTOR);
        this.chartSelector.setLayoutData((Object)chartSelectorLData);
        this.chartSelector.setImage(SWTResourceManager.getImage("gde/resource/moveToNext.png"));
        this.chartSelector.setToolTipText(Messages.getString("GDE_MSGT0899", GDE.MOD1));
        this.chartSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.fine(() -> "chartSelector.widgetSelected, event=" + String.valueOf(evt));
                SelectorComposite.this.windowActor.scrollSummaryComposite();
            }
        });
        this.smartSelector = new Button((Composite)this, 0x40004002);
        FormData smartSelectorLData = new FormData();
        smartSelectorLData.width = GDE.IS_WINDOWS ? 26 : 33;
        smartSelectorLData.height = GDE.IS_WINDOWS ? 26 : 33;
        smartSelectorLData.left = new FormAttachment((Control)this.chartSelector, 13);
        smartSelectorLData.top = new FormAttachment(0, 1000, YGAP_CHARTSELECTOR);
        this.smartSelector.setLayoutData((Object)smartSelectorLData);
        this.smartSelector.setImage(SWTResourceManager.getImage("gde/resource/smartSetting.png"));
        this.smartSelector.setSelection(true);
        this.smartSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.fine(() -> "smartSelector.widgetSelected, event=" + String.valueOf(evt));
                SelectorComposite.this.resetContextMenuMeasuring();
                SelectorComposite.this.windowActor.clearMeasuring();
                SelectorComposite.this.windowActor.getTrailRecordSet().setSmartStatistics(SelectorComposite.this.smartSelector.getSelection());
                SelectorComposite.this.windowActor.setTemplateChart();
                SelectorComposite.this.windowActor.updateHistoTabs(false, true, true);
            }
        });
        this.saveTemplate = new Button((Composite)this, 0x40004008);
        FormData saveTemplateLData = new FormData();
        saveTemplateLData.width = GDE.IS_WINDOWS ? 26 : 33;
        saveTemplateLData.height = GDE.IS_WINDOWS ? 26 : 33;
        saveTemplateLData.left = new FormAttachment((Control)this.smartSelector, -1);
        saveTemplateLData.top = new FormAttachment(0, 1000, YGAP_CHARTSELECTOR);
        this.saveTemplate.setLayoutData((Object)saveTemplateLData);
        this.saveTemplate.setImage(SWTResourceManager.getImage("gde/resource/saveTemplate.png"));
        this.saveTemplate.setToolTipText(Messages.getString("GDE_MSGT0884", GDE.MOD1));
        this.saveTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.fine(() -> "saveTemplate.widgetSelected, event=" + String.valueOf(evt));
                SelectorComposite.this.windowActor.saveTemplate();
            }
        });
        this.curveSelectorTable = new Table((Composite)this, 65572);
        this.curveSelectorTable.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.curveSelectorTable.setLinesVisible(true);
        FormData curveTableLData = new FormData();
        curveTableLData.width = 82;
        curveTableLData.height = 457;
        curveTableLData.left = new FormAttachment(0, 1000, 0);
        curveTableLData.top = new FormAttachment(0, 1000, 33);
        curveTableLData.bottom = new FormAttachment(1000, 1000, 0);
        curveTableLData.right = new FormAttachment(1000, 1000, 0);
        this.curveSelectorTable.setLayoutData((Object)curveTableLData);
        this.curveSelectorTable.setMenu(this.popupmenu);
        this.curveSelectorTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.fine(() -> "curveSelectorTable.widgetSelected, event=" + String.valueOf(evt));
                if (evt != null && evt.item != null) {
                    TableItem eventItem = (TableItem)evt.item;
                    log.finer(() -> "checked/Old=" + eventItem.getChecked() + String.valueOf(eventItem.getData("oldState")));
                    if (SelectorComposite.this.getTableItemRecord(eventItem) != null) {
                        String recordName = SelectorComposite.this.getTableItemRecord(eventItem).getName();
                        if (!eventItem.getChecked() && ((Boolean)eventItem.getData("oldState")).booleanValue() && SelectorComposite.this.windowActor.isMeasureRecord(recordName)) {
                            if (SelectorComposite.this.windowActor.isMeasureRecord(recordName)) {
                                SelectorComposite.this.contextMenu.setMeasurement(recordName, false);
                                SelectorComposite.this.contextMenu.setDeltaMeasurement(recordName, false);
                            }
                            SelectorComposite.this.windowActor.clearMeasuring();
                        }
                        SelectorComposite.this.popupmenu.setData("recordName", eventItem.getData("recordName"));
                        SelectorComposite.this.popupmenu.setData("nameReplacement", eventItem.getData("nameReplacement"));
                        SelectorComposite.this.popupmenu.setData("curveSelectedItem", (Object)eventItem);
                        if (SelectorComposite.this.toggleRecordSelection(eventItem, true, false)) {
                            SelectorComposite.this.windowActor.updateChartWindow(false);
                        }
                    }
                }
            }
        });
        SelectorComposite selectorComposite = this;
        synchronized (selectorComposite) {
            this.tableSelectorColumn = new TableColumn(this.curveSelectorTable, 16384);
            this.tableSelectorColumn.setWidth(this.selectorColumnWidth);
            this.tableCurveTypeColumn = new TableColumn(this.curveSelectorTable, 16384);
            this.tableCurveTypeColumn.setWidth(this.curveTypeColumnWidth);
        }
    }

    public synchronized void doUpdateCurveSelectorTable() {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        boolean smartStatistics = this.windowActor.getTrailRecordSet().isSmartStatistics();
        this.chartSelector.setEnabled(smartStatistics);
        this.smartSelector.setToolTipText(Messages.getString(smartStatistics ? "GDE_MSGT0887" : "GDE_MSGT0898", GDE.MOD1));
        this.smartSelector.setSelection(smartStatistics);
        this.curveSelectorTable.removeAll();
        for (TableEditor editor : this.editors) {
            if (editor == null) continue;
            if (editor.getEditor() != null) {
                editor.getEditor().dispose();
            }
            editor.dispose();
        }
        int itemWidth = this.initialSelectorHeaderWidth;
        int checkBoxWidth = 20;
        int textSize = 10;
        int itemWidth2 = this.initialCurveTypeColumnWidth;
        int textSize2 = 10;
        boolean isOneVisible = false;
        final TrailRecordSet recordSet = this.windowActor.getTrailRecordSet();
        if (recordSet != null) {
            Combo[] selectorCombos = new Combo[recordSet.size()];
            this.editors = new TableEditor[recordSet.size()];
            for (int i = 0; i < recordSet.getDisplayRecords().size(); ++i) {
                final TrailRecord record = recordSet.getDisplayRecords().get(i);
                textSize = record.getName().length() * 6;
                if (itemWidth < textSize + checkBoxWidth) {
                    itemWidth = textSize + checkBoxWidth;
                }
                if (itemWidth2 < (textSize2 = (int)((double)(record.getTrailSelector().getApplicableTrailsTexts().stream().mapToInt(w -> w.length()).max().orElse(10) * 6 * 15) / 20.0)) + checkBoxWidth) {
                    itemWidth2 = textSize2 + checkBoxWidth;
                }
                TableItem item = new TableItem(this.curveSelectorTable, 0);
                item.setForeground(ColorUtils.getColor(record.getRGB()));
                item.setData("recordName", (Object)record.getName());
                item.setData("nameReplacement", (Object)record.getNameReplacement());
                item.setText(record.getNameReplacement().intern());
                this.editors[i] = new TableEditor(this.curveSelectorTable);
                selectorCombos[i] = new Combo((Composite)this.curveSelectorTable, 8);
                this.editors[i].grabHorizontal = true;
                this.editors[i].setEditor((Control)selectorCombos[i], item, 1);
                selectorCombos[i].setItems(record.getTrailSelector().getApplicableTrailsTexts().toArray(new String[0]));
                selectorCombos[i].setText(record.getTrailSelector().getTrailText());
                selectorCombos[i].setToolTipText(!record.getLabel().isEmpty() ? record.getLabel() : Messages.getString("GDE_MSGT0748"));
                selectorCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        log.fine(() -> "selectorCombos.SelectionListener, event=" + String.valueOf(event));
                        Combo combo = (Combo)event.getSource();
                        recordSet.refillRecord(record, combo.getSelectionIndex());
                        SelectorComposite.this.windowActor.updateHistoTabs(false, false, false);
                    }
                });
                if (record.isVisible()) {
                    isOneVisible = true;
                    item.setChecked(true);
                    item.setData("oldState", (Object)true);
                } else {
                    item.setChecked(false);
                    item.setData("oldState", (Object)false);
                }
                this.setHeaderSelection(isOneVisible);
            }
            this.selectorColumnWidth = itemWidth;
            this.curveTypeColumnWidth = itemWidth2;
            log.fine(() -> "curveSelectorTable width = " + this.selectorColumnWidth);
        }
        this.tableCurveTypeColumn.setWidth(this.curveTypeColumnWidth);
        if (this.oldSelectorColumnWidth != this.selectorColumnWidth) {
            this.curveSelectorHeader.setSize(this.selectorColumnWidth - 1, this.curveSelectorHeader.getSize().y);
            int xOverlap = 2;
            this.tableSelectorColumn.setWidth(this.selectorColumnWidth - xOverlap);
            this.oldSelectorColumnWidth = this.selectorColumnWidth;
            FormData layoutData2 = (FormData)this.chartSelector.getLayoutData();
            layoutData2.left = new FormAttachment(0, 1000, itemWidth - xOverlap);
        }
        this.windowActor.setChartSashFormWeights(this);
        log.fine(() -> "curveSelectorTable width = " + this.selectorColumnWidth);
        this.curveSelectorTable.redraw();
    }

    public void setHeaderSelection(boolean enable) {
        this.curveSelectorHeader.setSelection(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectorColumnWidth() {
        SelectorComposite selectorComposite = this;
        synchronized (selectorComposite) {
            return this.selectorColumnWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCompositeWidth() {
        SelectorComposite selectorComposite = this;
        synchronized (selectorComposite) {
            return this.selectorColumnWidth + this.curveTypeColumnWidth;
        }
    }

    public void resetContextMenuMeasuring() {
        for (TableItem tableItem : this.curveSelectorTable.getItems()) {
            String recordName;
            TrailRecord record;
            if (!tableItem.getChecked() || (record = this.getTableItemRecord(tableItem)) == null || !this.windowActor.isMeasureRecord(recordName = record.getName())) continue;
            this.contextMenu.resetMeasuring();
        }
    }

    public void setRecordSelection(TrailRecord activeRecord) {
        TableItem tableItem = Arrays.stream(this.curveSelectorTable.getItems()).filter(c -> ((String)c.getData("recordName")).equals(activeRecord.getName())).findFirst().orElseThrow(UnsupportedOperationException::new);
        tableItem.setChecked(true);
        this.setRecordSelection(activeRecord, true, tableItem);
    }

    public void setRecordSelection(TrailRecord activeRecord, int selectIndex) {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        int displayIndex = -1;
        for (int i = 0; i < this.curveSelectorTable.getItems().length; ++i) {
            TableItem tableItem2 = this.curveSelectorTable.getItems()[i];
            if (!((String)tableItem2.getData("recordName")).equals(activeRecord.getName())) continue;
            displayIndex = i;
            break;
        }
        TableItem tableItem = this.curveSelectorTable.getItems()[displayIndex];
        tableItem.setChecked(true);
        this.setRecordSelection(activeRecord, true, tableItem);
        Combo selectorCombo = (Combo)this.editors[displayIndex].getEditor();
        selectorCombo.select(selectIndex);
        this.windowActor.getTrailRecordSet().refillRecord(activeRecord, selectorCombo.getSelectionIndex());
    }

    private void setRecordSelection(TrailRecord activeRecord, boolean isVisible, TableItem tableItem) {
        log.fine(() -> "isVisible old= " + activeRecord.isVisible());
        if (isVisible) {
            activeRecord.setVisible(true);
            this.popupmenu.getItem(0).setSelection(true);
            tableItem.setData("oldState", (Object)true);
            this.setHeaderSelection(true);
        } else {
            activeRecord.setVisible(false);
            this.popupmenu.getItem(0).setSelection(false);
            tableItem.setData("oldState", (Object)false);
        }
        activeRecord.getParent().syncScaleOfSyncableRecords();
        activeRecord.getParent().setDisplayable();
        activeRecord.getParent().updateVisibleAndDisplayableRecordsForTable();
    }

    private boolean toggleRecordSelection(TableItem item, boolean isTableSelection, boolean forceVisible) {
        boolean isToggled = false;
        TrailRecord activeRecord = this.getTableItemRecord(item);
        if (!isTableSelection || item.getChecked() != ((Boolean)item.getData("oldState")).booleanValue()) {
            isToggled = true;
            log.fine(() -> "selection state changed= " + activeRecord.getName());
            if (activeRecord != null) {
                this.setRecordSelection(activeRecord, isTableSelection && item.getChecked() || forceVisible, item);
                log.fine(() -> "isVisible= " + activeRecord.isVisible());
            }
        }
        return isToggled;
    }

    @Nullable
    private TrailRecord getTableItemRecord(TableItem item) {
        if (this.windowActor.getTrailRecordSet() == null) {
            return null;
        }
        TrailRecordSet trailRecordSet = this.windowActor.getTrailRecordSet();
        return trailRecordSet != null ? trailRecordSet.get(item.getData("recordName")) : null;
    }

    public Rectangle getRealBounds() {
        if (this.curveSelectorTable.getItemCount() > 0) {
            Rectangle firstRowBounds = this.curveSelectorTable.getItem(0).getBounds();
            Rectangle lastRowBounds = this.curveSelectorTable.getItem(this.curveSelectorTable.getItemCount() - 1).getBounds();
            int headerHeight = this.curveSelectorTable.getLocation().y;
            return new Rectangle(this.getBounds().x, headerHeight, this.getBounds().width, lastRowBounds.y + lastRowBounds.height - firstRowBounds.y);
        }
        return new Rectangle(1, 1, 1, 1);
    }

    public void setVerticalBarVisible(boolean visible) {
        if (!visible) {
            this.curveSelectorTable.setTopIndex(0);
        }
        this.curveSelectorTable.getVerticalBar().setVisible(visible);
    }

    public void updateColorSchema() {
        this.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setBackground(this.application.COLOR_BACKGROUND);
        this.curveSelectorHeader.setForeground(this.application.COLOR_FOREGROUND);
    }
}

