/*
 * Decompiled with CFR 0.152.
 */
package gde.device.htronic;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.htronic.AkkuMasterC4Dialog;
import gde.device.htronic.AkkuMasterC4SerialPort;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AkkuMasterChannelTab {
    static final Logger log = Logger.getLogger(AkkuMasterChannelTab.class.getName());
    AkkuMasterC4Dialog parent;
    String name;
    byte[] channelSig;
    String[] aCapacity;
    String[] aCellCount;
    String[] aAkkuTyp;
    String[] aProgramm;
    String[] aChargeCurrent_mA;
    String[] aDischargeCurrent_mA;
    AkkuMasterC4SerialPort serialPort;
    Channel channel;
    Timer timer;
    TimerTask timerTask;
    CTabItem channelTab;
    Button captureOnlyButton;
    Group programGroup;
    Group captureOnlyGroup;
    CCombo memoryNumberCombo;
    CCombo capacityMilliAh;
    Group akkuGroup;
    Text chargeCurrentText;
    Button stopDataGatheringButton;
    Button startDataGatheringButton;
    Text memoryNumberText;
    CCombo dischargeCurrent;
    Text dischargeCurrentText;
    CCombo chargeCurrent;
    CCombo program;
    Text programText;
    Group programTypeGroup;
    Text akkuTypeText;
    CCombo akkuType;
    CCombo countCells;
    Text countCellsText;
    Text capacityText;
    Text captureOnlyText;
    Button programmButton;
    Composite channelComposite;
    boolean isCaptureOnly = false;
    boolean isDefinedProgram = false;
    boolean isDataGatheringEnabled = false;
    boolean isStopButtonEnabled = false;
    String capacityMilliAhValue = "0";
    int countCellsValue = 0;
    int akkuTypeValue = 0;
    int programValue = 0;
    String chargeCurrentValue = "0";
    String dischargeCurrentValue = "0";
    int memoryNumberValue = 1;
    boolean isCollectData = false;
    boolean isGatheredRecordSetVisible = true;
    RecordSet recordSet;
    int retryCounter = 10;
    long timeStamp;
    boolean isChargeCurrentAdded = false;
    boolean isDischargeCurrentAdded = false;
    boolean isCollectDataStopped = true;
    boolean isMemorySelectionChanged = false;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");
    int actualCurrent = 0;
    String processName = "";
    final Channels channels;
    final DataExplorer application;

    public AkkuMasterChannelTab(AkkuMasterC4Dialog useParent, String newName, byte[] useChannelSig, AkkuMasterC4SerialPort useSerialPort, Channel useChannel, String[] arrayCapacity, String[] arrayCellCount, String[] arrayAkkuTyp, String[] arrayProgramm, String[] arrayChargeCurrent_mA, String[] arrayDischargeCurrent_mA) {
        this.parent = useParent;
        this.name = newName;
        this.channelSig = useChannelSig;
        this.serialPort = useSerialPort;
        this.channel = useChannel;
        this.aCapacity = arrayCapacity;
        this.aCellCount = arrayCellCount;
        this.aAkkuTyp = arrayAkkuTyp;
        this.aProgramm = arrayProgramm;
        this.aChargeCurrent_mA = arrayChargeCurrent_mA;
        this.aDischargeCurrent_mA = arrayDischargeCurrent_mA;
        this.channels = Channels.getInstance();
        this.application = DataExplorer.getInstance();
    }

    public void addChannelTab(CTabFolder tabFolder) {
        this.channelTab = new CTabItem(tabFolder, 0);
        this.channelTab.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.channelTab.setText(this.name);
        this.channelComposite = new Composite((Composite)tabFolder, 0);
        this.channelTab.setControl((Control)this.channelComposite);
        this.channelComposite.setLayout(null);
        this.channelComposite.addMouseTrackListener((MouseTrackListener)this.parent.getDevice().getDialog().mouseTrackerEnterFadeOut);
        this.channelComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "channelComposite.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateStartDataGatheringButton();
                AkkuMasterChannelTab.this.updateStopDataGatheringButton();
            }
        });
        this.captureOnlyGroup = new Group(this.channelComposite, 0);
        this.captureOnlyGroup.setLayout(null);
        this.captureOnlyGroup.setBounds(12, 8, 400, 80);
        this.captureOnlyGroup.addMouseTrackListener((MouseTrackListener)this.parent.getDevice().getDialog().mouseTrackerEnterFadeOut);
        this.captureOnlyGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "captureOnlyGroup.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateCaptureOnlyButton();
            }
        });
        this.captureOnlyText = new Text((Composite)this.captureOnlyGroup, 66);
        this.captureOnlyText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.captureOnlyText.setText(Messages.getString((String)"GDE_MSGT1173"));
        this.captureOnlyText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.captureOnlyText.setBounds(51, GDE.IS_MAC_COCOA ? 25 : 40, 315, 37);
        this.captureOnlyButton = new Button((Composite)this.captureOnlyGroup, 16400);
        this.captureOnlyButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.captureOnlyButton.setText(Messages.getString((String)"GDE_MSGT1174"));
        this.captureOnlyButton.setBounds(12, GDE.IS_MAC_COCOA ? 0 : 15, 310, 22);
        this.captureOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "captureOnlyButton.widgetSelected, event=" + String.valueOf(evt));
                if (AkkuMasterChannelTab.this.captureOnlyButton.getSelection()) {
                    try {
                        AkkuMasterChannelTab.this.isCaptureOnly = true;
                        AkkuMasterChannelTab.this.isDefinedProgram = false;
                        AkkuMasterChannelTab.this.updateAdjustedValues();
                        AkkuMasterChannelTab.this.isDataGatheringEnabled = true;
                        AkkuMasterChannelTab.this.updateCaptureOnlyButton();
                        AkkuMasterChannelTab.this.updateProgramButton();
                        AkkuMasterChannelTab.this.updateStartDataGatheringButton();
                    }
                    catch (Exception e) {
                        AkkuMasterChannelTab.this.captureOnlyButton.setSelection(false);
                        AkkuMasterChannelTab.this.stopTimer();
                        AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            }
        });
        this.programGroup = new Group(this.channelComposite, 0);
        this.programGroup.setLayout(null);
        this.programGroup.setBounds(12, 95, 400, 250);
        this.programGroup.addMouseTrackListener((MouseTrackListener)this.parent.getDevice().getDialog().mouseTrackerEnterFadeOut);
        this.programGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "programGroup.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateProgramButton();
            }
        });
        this.programmButton = new Button((Composite)this.programGroup, 16400);
        this.programmButton.setText(Messages.getString((String)"GDE_MSGT1175"));
        this.programmButton.setBounds(12, GDE.IS_MAC_COCOA ? 0 : 15, 295, 21);
        this.programmButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.programmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "programmButton.widgetSelected, event=" + String.valueOf(evt));
                if (AkkuMasterChannelTab.this.programmButton.getSelection()) {
                    try {
                        AkkuMasterChannelTab.this.isCaptureOnly = false;
                        AkkuMasterChannelTab.this.isDefinedProgram = true;
                        AkkuMasterChannelTab.this.updateAdjustedValues();
                        AkkuMasterChannelTab.this.isDataGatheringEnabled = true;
                        AkkuMasterChannelTab.this.updateCaptureOnlyButton();
                        AkkuMasterChannelTab.this.updateProgramButton();
                        AkkuMasterChannelTab.this.updateStartDataGatheringButton();
                    }
                    catch (Exception e) {
                        AkkuMasterChannelTab.this.programmButton.setSelection(false);
                        AkkuMasterChannelTab.this.stopTimer();
                        AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                    }
                }
            }
        });
        this.akkuGroup = new Group((Composite)this.programGroup, 0);
        RowLayout akkuRowLayout = new RowLayout(512);
        akkuRowLayout.spacing = 3;
        akkuRowLayout.center = true;
        akkuRowLayout.justify = true;
        this.akkuGroup.setLayout((Layout)akkuRowLayout);
        this.akkuGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.akkuGroup.setText(Messages.getString((String)"GDE_MSGT1176"));
        this.akkuGroup.setBounds(15, GDE.IS_MAC_COCOA ? 25 : 40, 369, 75);
        this.akkuGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "akkuGroup.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateCapacityMilliAhText();
                AkkuMasterChannelTab.this.updateCountCellSelection();
                AkkuMasterChannelTab.this.updateAkkuType();
            }
        });
        this.capacityText = new Text((Composite)this.akkuGroup, 0x1000000);
        this.capacityText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.capacityText.setLayoutData((Object)new RowData(112, 18));
        this.capacityText.setText(Messages.getString((String)"GDE_MSGT1177"));
        this.capacityText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.capacityText.setEditable(false);
        this.capacityMilliAh = new CCombo((Composite)this.akkuGroup, 2048);
        this.capacityMilliAh.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.capacityMilliAh.setItems(this.aCapacity);
        this.capacityMilliAh.setText(this.aCapacity[5]);
        this.capacityMilliAh.setLayoutData((Object)new RowData(112, GDE.IS_LINUX ? 22 : 20));
        this.capacityMilliAh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "capacityMilliAh.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateCapacityMilliAhValue();
            }
        });
        this.countCellsText = new Text((Composite)this.akkuGroup, 0x1000000);
        this.countCellsText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.countCellsText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.countCellsText.setLayoutData((Object)new RowData(112, 18));
        this.countCellsText.setText(Messages.getString((String)"GDE_MSGT1178"));
        this.countCellsText.setEditable(false);
        this.countCells = new CCombo((Composite)this.akkuGroup, 2048);
        this.countCells.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.countCells.setLayoutData((Object)new RowData(112, GDE.IS_LINUX ? 22 : 20));
        this.countCells.setItems(this.aCellCount);
        this.countCells.setText(this.aCellCount[3]);
        this.countCells.setEditable(false);
        this.countCells.setBackground(this.application.COLOR_WHITE);
        this.countCells.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "countCells.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateCellCountValue();
            }
        });
        this.akkuTypeText = new Text((Composite)this.akkuGroup, 0x1000000);
        this.akkuTypeText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.akkuTypeText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.akkuTypeText.setLayoutData((Object)new RowData(112, 18));
        this.akkuTypeText.setText(Messages.getString((String)"GDE_MSGT1179"));
        this.akkuTypeText.setDoubleClickEnabled(false);
        this.akkuTypeText.setDragDetect(false);
        this.akkuTypeText.setEditable(false);
        this.akkuType = new CCombo((Composite)this.akkuGroup, 2048);
        this.akkuType.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.akkuType.setLayoutData((Object)new RowData(112, GDE.IS_LINUX ? 22 : 20));
        this.akkuType.setItems(this.aAkkuTyp);
        this.akkuType.setText(this.aAkkuTyp[0]);
        this.akkuType.setEditable(false);
        this.akkuType.setBackground(this.application.COLOR_WHITE);
        this.akkuType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "akkuType.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateAkkuTypeValue();
            }
        });
        this.akkuGroup.layout();
        this.programTypeGroup = new Group((Composite)this.programGroup, 0);
        this.programTypeGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.programTypeGroup.setBounds(15, GDE.IS_MAC_COCOA ? 95 : 115, 369, 130);
        this.programTypeGroup.setText(Messages.getString((String)"GDE_MSGT1180"));
        GridLayout programGrpLayout = new GridLayout();
        programGrpLayout.numColumns = 3;
        programGrpLayout.makeColumnsEqualWidth = true;
        this.programTypeGroup.setLayout((Layout)programGrpLayout);
        this.programTypeGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                log.log(Level.FINEST, "programTypeGroup.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateProgramText();
                AkkuMasterChannelTab.this.updateChargeCurrentText();
                AkkuMasterChannelTab.this.updateDichargeCurrentText();
                AkkuMasterChannelTab.this.updateMemoryNumberSelection();
            }
        });
        this.programText = new Text((Composite)this.programTypeGroup, 0x1000000);
        this.programText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.programText.setBackground(this.application.COLOR_LIGHT_GREY);
        GridData gridDataText = new GridData(347, 18);
        gridDataText.horizontalAlignment = 0x1000000;
        gridDataText.horizontalSpan = 3;
        this.programText.setLayoutData((Object)gridDataText);
        this.programText.setText(Messages.getString((String)"GDE_MSGT1181"));
        this.program = new CCombo((Composite)this.programTypeGroup, 2048);
        this.program.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        GridData gridDataCombo = new GridData(347, GDE.IS_LINUX ? 22 : 20);
        gridDataCombo.horizontalAlignment = 0x1000000;
        gridDataCombo.horizontalSpan = 3;
        this.program.setLayoutData((Object)gridDataCombo);
        this.program.setItems(this.aProgramm);
        this.program.select(2);
        this.program.setEditable(false);
        this.program.setBackground(this.application.COLOR_WHITE);
        this.program.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "program.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateProgramSelectionValue();
            }
        });
        this.chargeCurrentText = new Text((Composite)this.programTypeGroup, 0x1000000);
        this.chargeCurrentText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.chargeCurrentText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.chargeCurrentText.setLayoutData((Object)new GridData(112, 18));
        this.chargeCurrentText.setText(Messages.getString((String)"GDE_MSGT1182"));
        this.chargeCurrentText.setEditable(false);
        this.dischargeCurrentText = new Text((Composite)this.programTypeGroup, 0x1000000);
        this.dischargeCurrentText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.dischargeCurrentText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.dischargeCurrentText.setLayoutData((Object)new GridData(112, 18));
        this.dischargeCurrentText.setDragDetect(false);
        this.dischargeCurrentText.setDoubleClickEnabled(false);
        this.dischargeCurrentText.setText(Messages.getString((String)"GDE_MSGT1183"));
        this.dischargeCurrentText.setEditable(false);
        this.memoryNumberText = new Text((Composite)this.programTypeGroup, 0x1000000);
        this.memoryNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.memoryNumberText.setBackground(this.application.COLOR_LIGHT_GREY);
        this.memoryNumberText.setLayoutData((Object)new GridData(112, 18));
        this.memoryNumberText.setText(Messages.getString((String)"GDE_MSGT1184"));
        this.memoryNumberText.setEditable(false);
        this.chargeCurrent = new CCombo((Composite)this.programTypeGroup, 2048);
        this.chargeCurrent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.chargeCurrent.setLayoutData((Object)new GridData(112, GDE.IS_LINUX ? 22 : 20));
        this.chargeCurrent.setItems(this.aChargeCurrent_mA);
        this.chargeCurrent.setText(this.aChargeCurrent_mA[5]);
        this.chargeCurrent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "chargeCurrent.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateChargeCurrentValue();
            }
        });
        this.dischargeCurrent = new CCombo((Composite)this.programTypeGroup, 2048);
        this.dischargeCurrent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.dischargeCurrent.setLayoutData((Object)new GridData(112, GDE.IS_LINUX ? 22 : 20));
        this.dischargeCurrent.setItems(this.aDischargeCurrent_mA);
        this.dischargeCurrent.setText(this.aDischargeCurrent_mA[5]);
        this.dischargeCurrent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "dischargeCurrent.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateDischargeCurrentValue();
            }
        });
        this.memoryNumberCombo = new CCombo((Composite)this.programTypeGroup, 2048);
        this.memoryNumberCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.memoryNumberCombo.setLayoutData((Object)new GridData(112, GDE.IS_LINUX ? 22 : 20));
        this.memoryNumberCombo.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"});
        this.memoryNumberCombo.select(1);
        this.memoryNumberCombo.setEditable(false);
        this.memoryNumberCombo.setBackground(this.application.COLOR_WHITE);
        this.memoryNumberCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "memoryNumberCombo.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateMemoryNumberValue();
                AkkuMasterChannelTab.this.setMemorySelectionChanged(true);
            }
        });
        this.programTypeGroup.layout();
        this.startDataGatheringButton = new Button(this.channelComposite, 0x1000008);
        this.startDataGatheringButton.setBounds(12, 360, 190, 28);
        this.startDataGatheringButton.setText(Messages.getString((String)"GDE_MSGT0277"));
        this.startDataGatheringButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.startDataGatheringButton.setSelection(this.isCollectData);
        this.startDataGatheringButton.setEnabled(false);
        this.startDataGatheringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "startAufzeichnungButton.widgetSelected, event=" + String.valueOf(evt));
                if (!AkkuMasterChannelTab.this.isCollectData()) {
                    AkkuMasterChannelTab.this.setCollectData(true);
                    try {
                        if (AkkuMasterChannelTab.this.isCaptureOnly()) {
                            AkkuMasterChannelTab.this.updateAdjustedValues();
                        } else {
                            int programNumber = AkkuMasterChannelTab.this.getProgramNumber();
                            int waitTime_days = 1;
                            int accuTyp = AkkuMasterChannelTab.this.getAkkuType();
                            int cellCount = AkkuMasterChannelTab.this.getCellCount();
                            int akkuCapacity = AkkuMasterChannelTab.this.getAkkuCapacity();
                            int dischargeCurrent_mA = AkkuMasterChannelTab.this.getDischargeCurrent();
                            int chargeCurrent_mA = AkkuMasterChannelTab.this.getChargeCurrent();
                            log.log(Level.FINE, " programNumber = " + programNumber + " waitTime_days = " + waitTime_days + " accuTyp = " + accuTyp + " cellCount = " + cellCount + " akkuCapacity = " + akkuCapacity + " dischargeCurrent_mA = " + dischargeCurrent_mA + " chargeCurrent_mA = " + chargeCurrent_mA);
                            AkkuMasterChannelTab.this.serialPort.writeNewProgram(AkkuMasterChannelTab.this.channelSig, programNumber, waitTime_days, accuTyp, cellCount, akkuCapacity, dischargeCurrent_mA, chargeCurrent_mA);
                            if (AkkuMasterChannelTab.this.isMemorySelectionChanged()) {
                                int memoryNumber = AkkuMasterChannelTab.this.getMemoryNumberSelectionIndex();
                                log.log(Level.FINE, "memoryNumber =" + memoryNumber);
                                AkkuMasterChannelTab.this.serialPort.setMemoryNumberCycleCountSleepTime(AkkuMasterChannelTab.this.channelSig, memoryNumber, 2, 2000);
                            }
                            if (AkkuMasterChannelTab.this.parent.getMaxCurrent() < AkkuMasterChannelTab.this.parent.getActiveCurrent() + dischargeCurrent_mA || AkkuMasterChannelTab.this.parent.getMaxCurrent() < AkkuMasterChannelTab.this.parent.getActiveCurrent() + chargeCurrent_mA) {
                                AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGW1100", (Object[])new Object[]{dischargeCurrent_mA, chargeCurrent_mA}));
                                AkkuMasterChannelTab.this.setCollectData(false);
                                AkkuMasterChannelTab.this.startDataGatheringButton.setSelection(false);
                                return;
                            }
                            AkkuMasterChannelTab.this.serialPort.start(AkkuMasterChannelTab.this.channelSig);
                            AkkuMasterChannelTab.this.serialPort.ok(AkkuMasterChannelTab.this.channelSig);
                        }
                        AkkuMasterChannelTab.this.isDataGatheringEnabled = false;
                        AkkuMasterChannelTab.this.updateStartDataGatheringButton();
                        AkkuMasterChannelTab.this.isStopButtonEnabled = true;
                        AkkuMasterChannelTab.this.updateStopDataGatheringButton();
                        AkkuMasterChannelTab.this.channels.switchChannel(AkkuMasterChannelTab.this.channel.getName());
                        int delay = 0;
                        int period = (int)AkkuMasterChannelTab.this.application.getActiveDevice().getTimeStep_ms();
                        AkkuMasterChannelTab.this.setTimer(new Timer());
                        AkkuMasterChannelTab.this.setTimerTask(new TimerTask(){
                            HashMap<String, Object> data;

                            @Override
                            public void run() {
                                block17: {
                                    try {
                                        this.data = AkkuMasterChannelTab.this.serialPort.getData(AkkuMasterChannelTab.this.channelSig);
                                        log.log(Level.FINE, "error state = " + String.valueOf(this.data.get(AkkuMasterC4SerialPort.PROCESS_ERROR_NO)));
                                        if (0 == (Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_ERROR_NO)) {
                                            AkkuMasterChannelTab.this.processName = ((String)this.data.get(AkkuMasterC4SerialPort.PROCESS_NAME)).split(" ")[1].trim();
                                            log.log(Level.FINE, AkkuMasterChannelTab.this.name + ": processName = " + AkkuMasterChannelTab.this.processName);
                                            AkkuMasterChannelTab.this.application.setStatusMessage("");
                                            int processNumber = Integer.valueOf(((String)this.data.get(AkkuMasterC4SerialPort.PROCESS_NAME)).split(" ")[0]);
                                            if (processNumber == 1 || processNumber == 2) {
                                                log.log(Level.FINE, AkkuMasterChannelTab.this.channel.getName() + "=" + AkkuMasterChannelTab.this.channel.size());
                                                if (AkkuMasterChannelTab.this.channel.size() == 0 || !AkkuMasterChannelTab.this.channel.getRecordSetNames()[AkkuMasterChannelTab.this.channel.getRecordSetNames().length - 1].endsWith(" " + AkkuMasterChannelTab.this.processName) || new Date().getTime() - AkkuMasterChannelTab.this.getTimeStamp() > 30000L || AkkuMasterChannelTab.this.isCollectDataStopped()) {
                                                    AkkuMasterChannelTab.this.setCollectDataStopped(false);
                                                    AkkuMasterChannelTab.this.recordSetKey = AkkuMasterChannelTab.this.channel.getNextRecordSetNumber() + ") " + AkkuMasterChannelTab.this.processName;
                                                    AkkuMasterChannelTab.this.channel.put((Object)AkkuMasterChannelTab.this.recordSetKey, (Object)RecordSet.createRecordSet((String)AkkuMasterChannelTab.this.recordSetKey, (IDevice)AkkuMasterChannelTab.this.application.getActiveDevice(), (int)AkkuMasterChannelTab.this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                                                    AkkuMasterChannelTab.this.channel.applyTemplateBasics(AkkuMasterChannelTab.this.recordSetKey);
                                                    log.log(Level.FINE, AkkuMasterChannelTab.this.recordSetKey + " created for channel " + AkkuMasterChannelTab.this.channel.getName());
                                                    if (AkkuMasterChannelTab.this.channel.getActiveRecordSet() == null) {
                                                        AkkuMasterChannelTab.this.channel.setActiveRecordSet(AkkuMasterChannelTab.this.recordSetKey);
                                                    }
                                                    AkkuMasterChannelTab.this.recordSet = (RecordSet)AkkuMasterChannelTab.this.channel.get((Object)AkkuMasterChannelTab.this.recordSetKey);
                                                    AkkuMasterChannelTab.this.recordSet.setAllDisplayable();
                                                    if (AkkuMasterChannelTab.this.channel.getName().equals(AkkuMasterChannelTab.this.channels.getActiveChannel().getName())) {
                                                        AkkuMasterChannelTab.this.application.getMenuToolBar().addRecordSetName(AkkuMasterChannelTab.this.recordSetKey);
                                                        AkkuMasterChannelTab.this.channels.getActiveChannel().switchRecordSet(AkkuMasterChannelTab.this.recordSetKey);
                                                    }
                                                    AkkuMasterChannelTab.this.actualCurrent = (Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_CURRENT);
                                                    AkkuMasterChannelTab.this.updateCurrentStatus();
                                                } else {
                                                    log.log(Level.FINE, "re-using " + AkkuMasterChannelTab.this.recordSetKey);
                                                }
                                                AkkuMasterChannelTab.this.setTimeStamp();
                                                int[] points = new int[AkkuMasterChannelTab.this.recordSet.size()];
                                                points[0] = (Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_VOLTAGE);
                                                points[1] = (Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_CURRENT);
                                                points[2] = Integer.valueOf((Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_CAPACITY)) * 1000;
                                                points[3] = Integer.valueOf((Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_POWER)) / 1000;
                                                points[4] = Integer.valueOf((Integer)this.data.get(AkkuMasterC4SerialPort.PROCESS_ENERGIE)) / 1000;
                                                log.log(Level.FINE, points[0] + " mV; " + points[1] + " mA; " + points[2] + " mAh; " + points[3] + " mW; " + points[4] + " mWh");
                                                AkkuMasterChannelTab.this.recordSet.addPoints(points);
                                                if (AkkuMasterChannelTab.this.recordSet.isChildOfActiveChannel() && AkkuMasterChannelTab.this.recordSet.equals((Object)AkkuMasterChannelTab.this.channels.getActiveChannel().getActiveRecordSet())) {
                                                    AkkuMasterChannelTab.this.application.updateAllTabs(false);
                                                }
                                            } else if (0 == AkkuMasterChannelTab.this.setRetryCounter(AkkuMasterChannelTab.this.getRetryCounter() - 1)) {
                                                AkkuMasterChannelTab.this.stopTimer();
                                                log.log(Level.WARNING, "Timer stopped AkkuMaster inactiv - " + AkkuMasterChannelTab.this.name);
                                                AkkuMasterChannelTab.this.application.setStatusMessage("=====> Timer stopped AkkuMaster inactiv - " + AkkuMasterChannelTab.this.name, 3);
                                                AkkuMasterChannelTab.this.setRetryCounter(10);
                                                AkkuMasterChannelTab.this.updateCurrentStatus();
                                                AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                                                AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                                            } else {
                                                log.log(Level.FINE, "Waiting for device activation - " + AkkuMasterChannelTab.this.name);
                                                AkkuMasterChannelTab.this.application.setStatusMessage("=====> Waiting for device activation - " + AkkuMasterChannelTab.this.name);
                                            }
                                            break block17;
                                        }
                                        log.log(Level.FINE, "canceling timer due to error");
                                        AkkuMasterChannelTab.this.updateCurrentStatus();
                                        AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                                        AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                                        if (!AkkuMasterChannelTab.this.isCaptureOnly()) {
                                            try {
                                                AkkuMasterChannelTab.this.serialPort.stop(AkkuMasterChannelTab.this.channelSig);
                                            }
                                            catch (IOException e) {
                                                log.log(Level.SEVERE, e.getMessage(), e);
                                            }
                                        }
                                        AkkuMasterChannelTab.this.setCollectData(false);
                                        AkkuMasterChannelTab.this.stopTimer();
                                        AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0027"));
                                    }
                                    catch (DataInconsitsentException e) {
                                        AkkuMasterChannelTab.this.updateCurrentStatus();
                                        AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                                        AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                                        log.log(Level.SEVERE, e.getMessage(), e);
                                        AkkuMasterChannelTab.this.setCollectData(false);
                                        AkkuMasterChannelTab.this.stopTimer();
                                        if (!AkkuMasterChannelTab.this.parent.isDisposed()) {
                                            AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}));
                                        }
                                    }
                                    catch (Exception e) {
                                        AkkuMasterChannelTab.this.updateCurrentStatus();
                                        AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                                        AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                                        log.log(Level.SEVERE, e.getMessage(), e);
                                        AkkuMasterChannelTab.this.setCollectData(false);
                                        AkkuMasterChannelTab.this.stopTimer();
                                        if (AkkuMasterChannelTab.this.parent.isDisposed()) break block17;
                                        AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                                    }
                                }
                            }
                        });
                        AkkuMasterChannelTab.this.getTimer().scheduleAtFixedRate(AkkuMasterChannelTab.this.getTimerTask(), delay, (long)period);
                    }
                    catch (Throwable e1) {
                        AkkuMasterChannelTab.this.updateCurrentStatus();
                        AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                        AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                        AkkuMasterChannelTab.this.isStopButtonEnabled = false;
                        AkkuMasterChannelTab.this.startDataGatheringButton.setSelection(true);
                        AkkuMasterChannelTab.this.application.openMessageDialog(AkkuMasterChannelTab.this.parent.getDialogShell(), Messages.getString((String)"GDE_MSGE0026"));
                    }
                }
            }
        });
        this.stopDataGatheringButton = new Button(this.channelComposite, 0x1000008);
        this.stopDataGatheringButton.setBounds(225, 360, 190, 28);
        this.stopDataGatheringButton.setText(Messages.getString((String)"GDE_MSGT0278"));
        this.stopDataGatheringButton.setEnabled(false);
        this.stopDataGatheringButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.stopDataGatheringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "stopAuzeichnungButton.widgetSelected, event=" + String.valueOf(evt));
                AkkuMasterChannelTab.this.updateCurrentStatus();
                AkkuMasterChannelTab.this.isChargeCurrentAdded = false;
                AkkuMasterChannelTab.this.isDischargeCurrentAdded = false;
                AkkuMasterChannelTab.this.updateDialogAfterStop();
                if (!AkkuMasterChannelTab.this.isCaptureOnly()) {
                    try {
                        AkkuMasterChannelTab.this.serialPort.stop(AkkuMasterChannelTab.this.channelSig);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AkkuMasterChannelTab.this.stopTimer();
                AkkuMasterChannelTab.this.recordSet = (RecordSet)AkkuMasterChannelTab.this.channels.getActiveChannel().get((Object)AkkuMasterChannelTab.this.recordSetKey);
                AkkuMasterChannelTab.this.application.updateStatisticsData();
            }
        });
    }

    private void updateCurrentStatus() {
        log.log(Level.FINE, "'" + this.processName.trim() + "' - " + this.isChargeCurrentAdded + ", " + this.isDischargeCurrentAdded);
        if (this.processName.trim().equalsIgnoreCase(Messages.getString((String)"GDE_MSGT1126").trim())) {
            if (!this.isChargeCurrentAdded) {
                this.parent.addTotalChargeCurrent(this.actualCurrent);
                this.isChargeCurrentAdded = true;
            } else {
                this.parent.subtractTotalChargeCurrent(this.actualCurrent);
                this.isChargeCurrentAdded = false;
            }
            if (this.isDischargeCurrentAdded) {
                this.parent.subtractTotalDischargeCurrent(this.actualCurrent);
                this.isDischargeCurrentAdded = false;
            }
        } else if (this.processName.trim().equalsIgnoreCase(Messages.getString((String)"GDE_MSGT1127").trim())) {
            if (!this.isDischargeCurrentAdded) {
                this.parent.addTotalDischargeCurrent(this.actualCurrent);
                this.isDischargeCurrentAdded = true;
            } else {
                this.parent.subtractTotalDischargeCurrent(this.actualCurrent);
                this.isDischargeCurrentAdded = false;
            }
            if (this.isChargeCurrentAdded) {
                this.parent.subtractTotalChargeCurrent(this.actualCurrent);
                this.isChargeCurrentAdded = false;
            }
        } else {
            if (this.isChargeCurrentAdded) {
                this.parent.subtractTotalChargeCurrent(this.actualCurrent);
                this.isChargeCurrentAdded = false;
            }
            if (this.isDischargeCurrentAdded) {
                this.parent.subtractTotalDischargeCurrent(this.actualCurrent);
                this.isDischargeCurrentAdded = false;
            }
        }
        log.log(Level.FINE, "'" + this.processName.trim() + "' - " + this.isChargeCurrentAdded + ", " + this.isDischargeCurrentAdded);
    }

    void updateAdjustedValues() throws Exception {
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
        }
        String[] configuration = this.serialPort.getConfiguration(this.channelSig);
        if (log.isLoggable(Level.FINER)) {
            this.serialPort.print(configuration);
        }
        if (!configuration[0].equals("0")) {
            this.programValue = Integer.valueOf(configuration[2].split(" ")[0]) - 1;
            this.program.setText(this.aProgramm[this.programValue]);
            this.akkuTypeValue = Integer.valueOf(configuration[3].split(" ")[0]);
            this.akkuType.setText(this.aAkkuTyp[this.akkuTypeValue]);
            this.countCellsValue = Integer.valueOf(configuration[4].split(" ")[0]) - 1;
            this.countCells.select(this.countCellsValue);
            this.capacityMilliAhValue = configuration[5].split(" ")[0];
            this.capacityMilliAh.setText(this.capacityMilliAhValue);
            this.chargeCurrentValue = configuration[7].split(" ")[0];
            this.chargeCurrent.setText(this.chargeCurrentValue);
            this.dischargeCurrentValue = configuration[6].split(" ")[0];
            this.dischargeCurrent.setText(this.dischargeCurrentValue);
            String[] adjustments = this.serialPort.getAdjustedValues(this.channelSig);
            this.memoryNumberValue = Integer.valueOf(adjustments[0].split(" ")[0]);
            this.memoryNumberCombo.select(this.memoryNumberValue);
            if (log.isLoggable(Level.FINER)) {
                this.serialPort.print(adjustments);
            }
        }
    }

    public void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        this.isCollectData = false;
        this.isCollectDataStopped = true;
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            this.updateDialogAfterStop();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AkkuMasterChannelTab.this.updateDialogAfterStop();
                }
            });
        }
    }

    void updateDialogAfterStop() {
        this.isDataGatheringEnabled = false;
        this.isStopButtonEnabled = false;
        this.isCaptureOnly = false;
        this.isDefinedProgram = false;
        this.isMemorySelectionChanged = false;
        this.startDataGatheringButton.setEnabled(this.isDataGatheringEnabled);
        this.stopDataGatheringButton.setEnabled(this.isStopButtonEnabled);
        this.captureOnlyButton.setSelection(this.isCaptureOnly);
        this.programmButton.setSelection(this.isDefinedProgram);
    }

    public boolean isDataColletionActive() {
        return this.isCollectData() || !this.isCollectDataStopped();
    }

    public boolean isCollectData() {
        return this.isCollectData;
    }

    public boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    void updateStartDataGatheringButton() {
        this.startDataGatheringButton.setEnabled(this.isDataGatheringEnabled);
    }

    void updateStopDataGatheringButton() {
        this.stopDataGatheringButton.setEnabled(this.isStopButtonEnabled);
    }

    void updateCaptureOnlyButton() {
        this.captureOnlyButton.setSelection(this.isCaptureOnly);
    }

    void updateProgramButton() {
        this.programmButton.setSelection(this.isDefinedProgram);
    }

    void updateCapacityMilliAhText() {
        this.capacityMilliAh.setText(this.capacityMilliAhValue);
    }

    void updateCountCellSelection() {
        this.countCells.select(this.countCellsValue);
    }

    void updateAkkuType() {
        this.akkuType.setText(this.aAkkuTyp[this.akkuTypeValue]);
    }

    void updateCapacityMilliAhValue() {
        this.capacityMilliAhValue = this.capacityMilliAh.getText();
    }

    void updateCellCountValue() {
        this.countCellsValue = this.countCells.getSelectionIndex();
    }

    void updateAkkuTypeValue() {
        this.akkuTypeValue = this.akkuType.getSelectionIndex();
    }

    void updateProgramText() {
        this.program.setText(this.aProgramm[this.programValue]);
    }

    void updateChargeCurrentText() {
        this.chargeCurrent.setText(this.chargeCurrentValue);
    }

    void updateDichargeCurrentText() {
        this.dischargeCurrent.setText(this.dischargeCurrentValue);
    }

    void updateMemoryNumberSelection() {
        this.memoryNumberCombo.select(this.memoryNumberValue);
    }

    void updateProgramSelectionValue() {
        this.programValue = this.program.getSelectionIndex() + 1;
    }

    void updateChargeCurrentValue() {
        this.chargeCurrentValue = this.chargeCurrent.getText();
    }

    void updateDischargeCurrentValue() {
        this.dischargeCurrentValue = this.dischargeCurrent.getText();
    }

    void updateMemoryNumberValue() {
        this.memoryNumberValue = this.memoryNumberCombo.getSelectionIndex();
        this.memoryNumberCombo.setBackground(SWTResourceManager.getColor((int)13));
    }

    void setMemorySelectionChanged(boolean enabled) {
        this.isMemorySelectionChanged = enabled;
    }

    void setCollectData(boolean enabled) {
        this.isCollectData = enabled;
    }

    boolean isCaptureOnly() {
        return this.isCaptureOnly;
    }

    int getProgramNumber() {
        return Integer.valueOf(this.program.getText().split(" ")[0]);
    }

    int getAkkuType() {
        return Integer.valueOf(this.akkuType.getText().split(" ")[0]);
    }

    int getCellCount() {
        return Integer.valueOf(this.countCells.getText().split(" ")[0]);
    }

    int getAkkuCapacity() {
        return Integer.valueOf(this.capacityMilliAh.getText());
    }

    int getDischargeCurrent() {
        return Integer.valueOf(this.dischargeCurrent.getText());
    }

    int getChargeCurrent() {
        return Integer.valueOf(this.chargeCurrent.getText());
    }

    boolean isMemorySelectionChanged() {
        return this.isMemorySelectionChanged;
    }

    int getMemoryNumberSelectionIndex() {
        return this.memoryNumberCombo.getSelectionIndex();
    }

    public void setTimer(Timer newTimer) {
        this.timer = newTimer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    void setTimerTask(TimerTask newTimerTask) {
        this.timerTask = newTimerTask;
    }

    public void setTimeStamp() {
        this.timeStamp = new Date().getTime();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    String getName() {
        return this.name;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public boolean isChargeCurrentAdded() {
        return this.isChargeCurrentAdded;
    }

    public boolean isDischargeCurrentAdded() {
        return this.isDischargeCurrentAdded;
    }

    public int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }

    public int getRetryCounter() {
        return this.retryCounter;
    }

    public int getActualCurrent() {
        return this.actualCurrent;
    }
}

