/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.skyrc.ChargerDialog;
import gde.device.skyrc.IMaxB6RDX1UsbPort;
import gde.device.skyrc.ImaxB6GathererThread;
import gde.device.skyrc.MC3000;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class IMaxB6USB
extends MC3000
implements IDevice {
    static final Logger log = Logger.getLogger(IMaxB6USB.class.getName());
    protected final ChargerDialog dialog;
    ImaxB6GathererThread dataGatherThread;
    IMaxB6RDX1UsbPort usbPort;
    int[] resetEnergy = new int[]{5, 5};
    double[] energy = new double[]{0.0, 0.0};
    protected String[] USAGE_MODE_DJI;
    SystemInfo[] systemInfo = new SystemInfo[1];
    SystemSetting[] systemSetting = new SystemSetting[1];

    public IMaxB6USB(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        this.STATUS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3601") + ":" + Messages.getString((String)"GDE_MSGT3602"), Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3604"), Messages.getString((String)"GDE_MSGT3605")};
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3615"), Messages.getString((String)"GDE_MSGT3616")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.USAGE_MODE_DJI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3612")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648"), Messages.getString((String)"GDE_MSGT3687")};
        this.usbPort = new IMaxB6RDX1UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    public IMaxB6USB(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.STATUS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3601") + ":" + Messages.getString((String)"GDE_MSGT3602"), Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3604"), Messages.getString((String)"GDE_MSGT3605")};
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3615"), Messages.getString((String)"GDE_MSGT3616")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3625"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3626"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_PB = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3623")};
        this.USAGE_MODE_DJI = new String[]{Messages.getString((String)"GDE_MSGT3617"), Messages.getString((String)"GDE_MSGT3612")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3649"), Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3648"), Messages.getString((String)"GDE_MSGT3687")};
        this.usbPort = new IMaxB6RDX1UsbPort(this, this.application);
        this.dialog = new ChargerDialog(this.application.getShell(), this);
    }

    @Override
    public DeviceDialog getDialog() {
        return this.dialog;
    }

    @Override
    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    @Override
    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    @Override
    public int getLovDataByteSize() {
        return 86;
    }

    @Override
    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVoltage = Integer.MIN_VALUE;
        int minVoltage = Integer.MAX_VALUE;
        points[0] = DataParser.parse2UnsignedShort((byte)dataBuffer[10], (byte)dataBuffer[9]);
        points[1] = DataParser.parse2Short((byte)dataBuffer[12], (byte)dataBuffer[11]);
        points[2] = DataParser.parse2Short((byte)dataBuffer[6], (byte)dataBuffer[5]) * 1000;
        points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1]).intValue();
        switch (dataBuffer[1]) {
            case 0: {
                this.energy[0] = this.energy[0] + (double)points[0] / 1000.0 * (double)points[1] / 3600.0;
                points[4] = Double.valueOf(this.energy[0]).intValue();
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "add up Energy");
                break;
            }
            case 1: {
                this.energy[0] = 0.0;
                points[4] = 0;
                points[4] = 0;
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "reset Energy");
                break;
            }
            default: {
                points[4] = points[4];
                if (!log.isLoggable(java.util.logging.Level.FINE)) break;
                log.log(java.util.logging.Level.FINE, "untouche Energy");
            }
        }
        points[5] = dataBuffer[13] * 1000;
        points[6] = dataBuffer[14] * 1000;
        points[7] = dataBuffer[15] * 1000;
        if (dataBuffer[0] <= 3) {
            int j = 0;
            int i = 9;
            while (i < points.length) {
                if (dataBuffer[j + 17] > 5) {
                    points[i] = DataParser.parse2Short((byte)dataBuffer[j + 18], (byte)dataBuffer[j + 17]);
                    maxVoltage = points[i] > maxVoltage ? points[i] : maxVoltage;
                    minVoltage = points[i] < minVoltage ? points[i] : minVoltage;
                } else {
                    points[i] = 0;
                }
                ++i;
                j += 2;
            }
            points[8] = 1000 * (maxVoltage != Integer.MIN_VALUE && minVoltage != Integer.MAX_VALUE ? maxVoltage - minVoltage : 0);
        }
        return points;
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            int j = 0;
            int k = 0;
            while (j < points.length) {
                points[j] = ((convertBuffer[k] & 0xFF) << 24) + ((convertBuffer[k + 1] & 0xFF) << 16) + ((convertBuffer[k + 2] & 0xFF) << 8) + ((convertBuffer[k + 3] & 0xFF) << 0);
                ++j;
                k += 4;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - reduction) * factor + offset;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - offset) / factor + reduction;
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public int getCurrentSmoothIndex() {
        return 1;
    }

    public boolean isProcessing(int outletNum, byte[] channelBuffer, byte[] dataBuffer) {
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, outletNum + " isProcessing = " + (dataBuffer == null ? channelBuffer[4] == 1 : dataBuffer[4] >= 1));
        }
        if (dataBuffer == null) {
            return channelBuffer[4] == 1;
        }
        return (channelBuffer[5] == 4 || channelBuffer[5] == 5) && dataBuffer[17] == 2 && !this.isContinuousRecordSet() && this.settings.isReduceChargeDischarge() ? false : dataBuffer[4] == 1;
    }

    @Override
    public String getProcessingStatusName(byte[] dataBuffer) {
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : this.STATUS_MODE[dataBuffer[4]];
    }

    @Override
    public String getProcessingBatteryTypeName(byte[] channelBuffer) {
        return this.BATTERY_TYPE[channelBuffer[5]];
    }

    @Override
    public int getProcessingType(byte[] channelBuffer) {
        return channelBuffer[7];
    }

    @Override
    public int getBatteryType(byte[] channelBuffer) {
        return channelBuffer[5];
    }

    @Override
    public String getProcessingTypeName(byte[] channelBuffer) {
        String processTypeName = "";
        switch (this.getBatteryType(channelBuffer)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                processTypeName = this.USAGE_MODE_LI[channelBuffer[7]];
                break;
            }
            case 4: 
            case 5: {
                processTypeName = this.USAGE_MODE_NI[channelBuffer[7]];
                break;
            }
            case 6: {
                processTypeName = this.USAGE_MODE_PB[channelBuffer[7]];
            }
        }
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : processTypeName;
    }

    public int getCycleNumber(byte[] dataBuffer) {
        return dataBuffer[18] + 1;
    }

    public int getProcessSubType(byte[] channelBuffer, byte[] dataBuffer) {
        if (channelBuffer[5] == 4 || channelBuffer[5] == 5) {
            return dataBuffer[17];
        }
        return this.getProcessingType(channelBuffer);
    }

    public String getProcessSubTypeName(byte[] channelBuffer, byte[] dataBuffer) {
        switch (this.getBatteryType(channelBuffer)) {
            default: {
                return "";
            }
            case 4: 
            case 5: 
        }
        if (this.isContinuousRecordSet() || this.getProcessingType(channelBuffer) != 4) {
            return "";
        }
        switch (dataBuffer[17]) {
            default: {
                return Messages.getString((String)"GDE_MSGT3620");
            }
            case 2: {
                return Messages.getString((String)"GDE_MSGT3627");
            }
            case 3: 
        }
        return Messages.getString((String)"GDE_MSGT3623");
    }

    @Override
    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 2};
    }

    public int getNumberCells(byte[] channelBuffer) {
        return channelBuffer[6];
    }

    public String getProductIdString() {
        return String.format("%2x", this.systemInfo[0].getProductId());
    }

    public String getHarwareString() {
        return this.systemInfo[0].getHardwareVersion();
    }

    @Override
    public String getFirmwareString() {
        return this.systemInfo[0].getFirmwareVersion();
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
    }

    @Override
    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        String[] measurementNames = this.getMeasurementNames(channelConfigNumber);
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + measurementNames[i]);
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    @Override
    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    @Override
    public void open_closeCommPort() {
        block21: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block21;
                        this.dataGatherThread = new ImaxB6GathererThread(this.application, this, this.usbPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.dataGatherThread != null && this.usbPort.isConnected()) {
                                this.systemInfo[0] = new SystemInfo(this, this.usbPort.getSystemInfo(this.dataGatherThread.getUsbInterface(), IMaxB6RDX1UsbPort.QuerySystemInfo.CHANNEL_A.value()));
                                this.systemSetting[0] = new SystemSetting(this, this.usbPort.getSystemSetting(this.dataGatherThread.getUsbInterface(), IMaxB6RDX1UsbPort.QuerySystemSetting.CHANNEL_A.value()));
                                WaitTimer.delay((long)100L);
                                this.dataGatherThread.start();
                            }
                        }
                        catch (Throwable e) {
                            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(java.util.logging.Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (this.dataGatherThread != null) {
                        this.dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public String getFileBaseDir() {
        return this.getName();
    }

    protected class SystemInfo {
        byte productId;
        byte[] productModel = new byte[6];
        byte isUpgradeSupported;
        byte isSoftwareEncrytion;
        byte customerId;
        byte[] firmwareVersion = new byte[2];
        byte[] hardwareVersion = new byte[2];

        public SystemInfo(IMaxB6USB this$0, byte[] buffer) {
            this.productId = buffer[4];
            for (int i = 0; i < this.productModel.length; ++i) {
                this.productModel[i] = buffer[i + 5];
            }
            this.isUpgradeSupported = buffer[11];
            this.isSoftwareEncrytion = buffer[12];
            this.customerId = buffer[13];
            System.arraycopy(buffer, 16, this.firmwareVersion, 0, 2);
            System.arraycopy(buffer, 18, this.hardwareVersion, 0, 2);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("productId=0x%02x productModel=%s, isUpgradeSupported=%b isSoftwareEncrytion=%b customerId=0x%02x firmwareVersion=%s hardwareVersion=%s", this.getProductId(), this.getProductModel(), this.isUpgradeSupported(), this.isSoftwareEncryption(), this.getCustomerId(), this.getFirmwareVersion(), this.getHardwareVersion()));
            }
        }

        public byte getProductId() {
            return this.productId;
        }

        public String getProductModel() {
            byte[] tmpMachineID = new byte[6];
            System.arraycopy(this.productModel, 0, tmpMachineID, 0, 6);
            return String.format("%s", new String(tmpMachineID));
        }

        public boolean isUpgradeSupported() {
            return this.isUpgradeSupported == 1;
        }

        public boolean isSoftwareEncryption() {
            return this.isSoftwareEncrytion == 1;
        }

        public byte getCustomerId() {
            return this.customerId;
        }

        public String getFirmwareVersion() {
            return String.format("Firmware: %d.%02d", this.firmwareVersion[0], this.firmwareVersion[1]);
        }

        public int getFirmwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.firmwareVersion[0], this.firmwareVersion[1]));
        }

        public String getHardwareVersion() {
            return String.format("Hardware: %d.%02d", this.hardwareVersion[0], this.hardwareVersion[1]);
        }

        public int getHardwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.hardwareVersion[0], this.hardwareVersion[1]));
        }
    }

    protected class SystemSetting {
        byte productId;
        byte restingTimeNiMH;
        byte isProtectionTime;
        byte[] protectionTime = new byte[2];
        byte isCapacityLimit;
        byte[] capacityLimit = new byte[2];
        byte isKeySound;
        byte isSystemSound;
        byte[] voltageLow = new byte[2];
        byte isTemperaturLimit;
        byte[] voltage = new byte[2];
        byte[] voltage1 = new byte[2];
        byte[] voltage2 = new byte[2];
        byte[] voltage3 = new byte[2];
        byte[] voltage4 = new byte[2];
        byte[] voltage5 = new byte[2];
        byte[] voltage6 = new byte[2];

        public SystemSetting(IMaxB6USB this$0, byte[] buffer) {
            this.productId = buffer[3];
            this.restingTimeNiMH = buffer[4];
            this.isProtectionTime = buffer[5];
            System.arraycopy(buffer, 6, this.protectionTime, 0, 2);
            this.isCapacityLimit = buffer[8];
            System.arraycopy(buffer, 9, this.capacityLimit, 0, 2);
            this.isKeySound = buffer[11];
            this.isSystemSound = buffer[12];
            System.arraycopy(buffer, 13, this.voltageLow, 0, 2);
            this.isTemperaturLimit = buffer[17];
            System.arraycopy(buffer, 18, this.voltage, 0, 2);
            System.arraycopy(buffer, 20, this.voltage1, 0, 2);
            System.arraycopy(buffer, 22, this.voltage2, 0, 2);
            System.arraycopy(buffer, 24, this.voltage3, 0, 2);
            System.arraycopy(buffer, 26, this.voltage4, 0, 2);
            System.arraycopy(buffer, 28, this.voltage5, 0, 2);
            System.arraycopy(buffer, 30, this.voltage6, 0, 2);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, String.format("productId=0x%02x restingTimeNiMH=%d isPrtotectionTime=%b protectionTime=%d isCapacityLimit=%b capacityLimit=%d isKeySound=%b isSystemSound=%b voltageLow=%d isTemperaturLimit=%b", this.getProductId(), this.getRestingTimeNiMH(), this.isProtectionTime(), this.getProtectionTime(), this.isCapacityLimit(), this.getCapacityLimit(), this.isKeySound(), this.isSystemSound(), this.getVoltageLow(), this.isTemperaturLimit()));
                log.log(Level.FINER, String.format("voltage=%d, voltage1=%d voltage2=%d voltage3=%d voltage4=%d voltage5=%d voltage6=%d", this.getVoltage(), this.getVoltage1(), this.getVoltage2(), this.getVoltage3(), this.getVoltage4(), this.getVoltage5(), this.getVoltage6()));
            }
        }

        public byte getProductId() {
            return this.productId;
        }

        public boolean isTimeLimiting() {
            return this.isProtectionTime == 1;
        }

        public short getTimeLimit() {
            return DataParser.parse2Short((byte)this.protectionTime[1], (byte)this.protectionTime[0]);
        }

        public boolean isCapacityLimit() {
            return this.isCapacityLimit == 1;
        }

        public short getCapacityLimit() {
            return DataParser.parse2Short((byte)this.capacityLimit[1], (byte)this.capacityLimit[0]);
        }

        public boolean isKeySound() {
            return this.isKeySound == 1;
        }

        public boolean isSystemSound() {
            return this.isSystemSound == 1;
        }

        public byte getRestingTimeNiMH() {
            return this.restingTimeNiMH;
        }

        public boolean isProtectionTime() {
            return this.isProtectionTime == 1;
        }

        public short getProtectionTime() {
            return DataParser.parse2Short((byte[])this.protectionTime, (int)0);
        }

        public short getVoltageLow() {
            return DataParser.parse2Short((byte)this.voltageLow[1], (byte)this.voltageLow[0]);
        }

        public boolean isTemperaturLimit() {
            return this.isTemperaturLimit == 1;
        }

        public short getVoltage() {
            return DataParser.parse2Short((byte)this.voltage[1], (byte)this.voltage[0]);
        }

        public short getVoltage1() {
            return DataParser.parse2Short((byte)this.voltage1[1], (byte)this.voltage1[0]);
        }

        public short getVoltage2() {
            return DataParser.parse2Short((byte)this.voltage2[1], (byte)this.voltage2[0]);
        }

        public short getVoltage3() {
            return DataParser.parse2Short((byte)this.voltage3[1], (byte)this.voltage3[0]);
        }

        public short getVoltage4() {
            return DataParser.parse2Short((byte)this.voltage4[1], (byte)this.voltage4[0]);
        }

        public short getVoltage5() {
            return DataParser.parse2Short((byte)this.voltage5[1], (byte)this.voltage5[0]);
        }

        public short getVoltage6() {
            return DataParser.parse2Short((byte)this.voltage6[1], (byte)this.voltage6[0]);
        }
    }
}

