/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.smmodellbau.JLog2;
import gde.device.smmodellbau.JLog2Dialog;
import gde.device.smmodellbau.JLog2SerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.util.logging.Logger;

public class JLog2LiveGathererThread
extends Thread {
    static final String $CLASS_NAME = JLog2LiveGathererThread.class.getName();
    static final Logger log = Logger.getLogger(JLog2LiveGathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 36;
    final DataExplorer application;
    final JLog2SerialPort serialPort;
    final JLog2 device;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    final JLog2Dialog dialog;
    String recordSetKey = Messages.getString((String)"GDE_MSGT0272");

    public JLog2LiveGathererThread(DataExplorer currentApplication, JLog2 useDevice, JLog2SerialPort useSerialPort, int channelConfigNumber, JLog2Dialog useDialog) throws ApplicationConfigurationException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        this.dialog = useDialog;
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet = null;
        int[] points = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        long measurementCount = 0L;
        byte[] dataBuffer = null;
        this.serialPort.isInterruptedByUser = false;
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        try {
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                WaitTimer.delay((long)1000L);
            }
            while (!this.serialPort.isInterruptedByUser && this.serialPort.cleanInputStream() <= 0) {
                WaitTimer.delay((long)1000L);
            }
        }
        catch (Exception e) {
            log.logp(java.util.logging.Level.SEVERE, $CLASS_NAME, "run", e.getMessage(), e);
        }
        try {
            long startTime = System.nanoTime() / 1000000L;
            while (!this.serialPort.isInterruptedByUser) {
                try {
                    dataBuffer = this.serialPort.getData();
                    String processName = this.device.getProcessName(dataBuffer);
                    if (this.channel.size() == 0 || recordSet == null || !this.recordSetKey.endsWith(" " + processName)) {
                        this.application.setStatusMessage("");
                        this.recordSetKey = this.channel.getNextRecordSetNumber() + ") " + processName;
                        this.channel.put((Object)this.recordSetKey, (Object)RecordSet.createRecordSet((String)this.recordSetKey, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", this.recordSetKey + " created for channel " + this.channel.getName());
                        if (this.channel.getActiveRecordSet() == null) {
                            this.channel.setActiveRecordSet(this.recordSetKey);
                        }
                        recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey);
                        this.channel.applyTemplateBasics(this.recordSetKey);
                        if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                            this.channels.getActiveChannel().switchRecordSet(this.recordSetKey);
                        }
                        measurementCount = 0L;
                    }
                    recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)(System.nanoTime() / 1000000L - startTime));
                    if (recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)this.channels.getActiveChannel().getActiveRecordSet())) {
                        this.application.updateAllTabs(false);
                    }
                    if (++measurementCount <= 0L || measurementCount % 10L != 0L) continue;
                    this.device.updateVisibilityStatus(recordSet, true);
                }
                catch (DataInconsitsentException e) {
                    String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                    this.cleanup(message);
                }
                catch (Throwable e) {
                    log.log(java.util.logging.Level.FINE, "JLog2 program end detected");
                    this.finalizeRecordSet();
                }
            }
        }
        catch (Throwable throwable) {
            if (this.serialPort.isConnected()) {
                this.serialPort.close();
            }
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    JLog2LiveGathererThread.this.device.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2804"), Messages.getString((String)"GDE_MSGT2804"));
                    if (JLog2LiveGathererThread.this.dialog != null && !JLog2LiveGathererThread.this.dialog.isDisposed()) {
                        JLog2LiveGathererThread.this.dialog.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2805"));
                    }
                }
            });
            this.application.setStatusMessage("");
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "======> exit");
            throw throwable;
        }
        if (this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        GDE.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
        this.application.setStatusMessage("");
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    public synchronized void stopDataGathering() {
        this.serialPort.isInterruptedByUser = true;
    }

    void finalizeRecordSet() {
        RecordSet tmpRecordSet;
        this.stopDataGathering();
        if (this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JLog2LiveGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        JLog2LiveGathererThread.this.application.updateStatisticsData();
                        JLog2LiveGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        JLog2LiveGathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }
}

