/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    @Override
    public TransferData[] getSupportedTypes() {
        int[] types = this.getTypeIds();
        TransferData[] data2 = new TransferData[types.length];
        int i2 = 0;
        while (i2 < types.length) {
            data2[i2] = new TransferData();
            data2[i2].type = types[i2];
            data2[i2].formatetc = new FORMATETC();
            data2[i2].formatetc.cfFormat = types[i2];
            data2[i2].formatetc.dwAspect = 1;
            data2[i2].formatetc.lindex = -1;
            data2[i2].formatetc.tymed = 1;
            ++i2;
        }
        return data2;
    }

    @Override
    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] types = this.getTypeIds();
        int i2 = 0;
        while (i2 < types.length) {
            FORMATETC format = transferData.formatetc;
            if (format.cfFormat == types[i2] && (format.dwAspect & 1) == 1 && (format.tymed & 1) == 1) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] data2 = (byte[])object;
        int size = data2.length;
        long newPtr = OS.GlobalAlloc(64, size);
        OS.MoveMemory(newPtr, data2, size);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = newPtr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    @Override
    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject data2 = new IDataObject(transferData.pIDataObject);
        data2.AddRef();
        FORMATETC formatetc = transferData.formatetc;
        STGMEDIUM stgmedium = new STGMEDIUM();
        stgmedium.tymed = 1;
        transferData.result = this.getData(data2, formatetc, stgmedium);
        data2.Release();
        if (transferData.result != 0) {
            return null;
        }
        long hMem = stgmedium.unionField;
        int size = OS.GlobalSize(hMem);
        byte[] buffer = new byte[size];
        long ptr = OS.GlobalLock(hMem);
        OS.MoveMemory(buffer, ptr, size);
        OS.GlobalUnlock(hMem);
        OS.GlobalFree(hMem);
        return buffer;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

