/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math3.stat.clustering.Clusterable;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class EuclideanDoublePoint
implements Clusterable<EuclideanDoublePoint>,
Serializable {
    private static final long serialVersionUID = 8026472786091227632L;
    private final double[] point;

    public EuclideanDoublePoint(double[] point) {
        this.point = point;
    }

    @Override
    public EuclideanDoublePoint centroidOf(Collection<EuclideanDoublePoint> points) {
        double[] centroid = new double[this.getPoint().length];
        for (EuclideanDoublePoint p2 : points) {
            for (int i2 = 0; i2 < centroid.length; ++i2) {
                int n2 = i2;
                centroid[n2] = centroid[n2] + p2.getPoint()[i2];
            }
        }
        int i3 = 0;
        while (i3 < centroid.length) {
            int n3 = i3++;
            centroid[n3] = centroid[n3] / (double)points.size();
        }
        return new EuclideanDoublePoint(centroid);
    }

    @Override
    public double distanceFrom(EuclideanDoublePoint p2) {
        return MathArrays.distance(this.point, p2.getPoint());
    }

    public boolean equals(Object other) {
        if (!(other instanceof EuclideanDoublePoint)) {
            return false;
        }
        return Arrays.equals(this.point, ((EuclideanDoublePoint)other).point);
    }

    public double[] getPoint() {
        return this.point;
    }

    public int hashCode() {
        return Arrays.hashCode(this.point);
    }

    public String toString() {
        return Arrays.toString(this.point);
    }
}

