/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SparseRealMatrix;
import org.apache.commons.math3.util.OpenIntToDoubleHashMap;

public class OpenMapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix,
Serializable {
    private static final long serialVersionUID = -5962461716457143437L;
    private final int rows;
    private final int columns;
    private final OpenIntToDoubleHashMap entries;

    public OpenMapRealMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, NumberIsTooLargeException {
        super(rowDimension, columnDimension);
        long lRow = rowDimension;
        long lCol = columnDimension;
        if (lRow * lCol >= Integer.MAX_VALUE) {
            throw new NumberIsTooLargeException(lRow * lCol, (Number)Integer.MAX_VALUE, false);
        }
        this.rows = rowDimension;
        this.columns = columnDimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
    }

    public OpenMapRealMatrix(OpenMapRealMatrix matrix) {
        this.rows = matrix.rows;
        this.columns = matrix.columns;
        this.entries = new OpenIntToDoubleHashMap(matrix.entries);
    }

    public OpenMapRealMatrix copy() {
        return new OpenMapRealMatrix(this);
    }

    public OpenMapRealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, NumberIsTooLargeException {
        return new OpenMapRealMatrix(rowDimension, columnDimension);
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public OpenMapRealMatrix add(OpenMapRealMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m2);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator2 = m2.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            int row2 = iterator2.key() / this.columns;
            int col = iterator2.key() - row2 * this.columns;
            out.setEntry(row2, col, this.getEntry(row2, col) + iterator2.value());
        }
        return out;
    }

    public OpenMapRealMatrix subtract(RealMatrix m2) throws MatrixDimensionMismatchException {
        try {
            return this.subtract((OpenMapRealMatrix)m2);
        }
        catch (ClassCastException cce) {
            return (OpenMapRealMatrix)super.subtract(m2);
        }
    }

    public OpenMapRealMatrix subtract(OpenMapRealMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m2);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator2 = m2.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            int row2 = iterator2.key() / this.columns;
            int col = iterator2.key() - row2 * this.columns;
            out.setEntry(row2, col, this.getEntry(row2, col) - iterator2.value());
        }
        return out;
    }

    public RealMatrix multiply(RealMatrix m2) throws DimensionMismatchException, NumberIsTooLargeException {
        try {
            return this.multiply((OpenMapRealMatrix)m2);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkMultiplicationCompatible(this, m2);
            int outCols = m2.getColumnDimension();
            BlockRealMatrix out = new BlockRealMatrix(this.rows, outCols);
            OpenIntToDoubleHashMap.Iterator iterator2 = this.entries.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                double value = iterator2.value();
                int key2 = iterator2.key();
                int i2 = key2 / this.columns;
                int k2 = key2 % this.columns;
                for (int j2 = 0; j2 < outCols; ++j2) {
                    out.addToEntry(i2, j2, value * m2.getEntry(k2, j2));
                }
            }
            return out;
        }
    }

    public OpenMapRealMatrix multiply(OpenMapRealMatrix m2) throws DimensionMismatchException, NumberIsTooLargeException {
        MatrixUtils.checkMultiplicationCompatible(this, m2);
        int outCols = m2.getColumnDimension();
        OpenMapRealMatrix out = new OpenMapRealMatrix(this.rows, outCols);
        OpenIntToDoubleHashMap.Iterator iterator2 = this.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            double value = iterator2.value();
            int key2 = iterator2.key();
            int i2 = key2 / this.columns;
            int k2 = key2 % this.columns;
            for (int j2 = 0; j2 < outCols; ++j2) {
                int rightKey = m2.computeKey(k2, j2);
                if (!m2.entries.containsKey(rightKey)) continue;
                int outKey = out.computeKey(i2, j2);
                double outValue = out.entries.get(outKey) + value * m2.entries.get(rightKey);
                if (outValue == 0.0) {
                    out.entries.remove(outKey);
                    continue;
                }
                out.entries.put(outKey, outValue);
            }
        }
        return out;
    }

    public double getEntry(int row2, int column2) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        return this.entries.get(this.computeKey(row2, column2));
    }

    public int getRowDimension() {
        return this.rows;
    }

    public void setEntry(int row2, int column2, double value) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        if (value == 0.0) {
            this.entries.remove(this.computeKey(row2, column2));
        } else {
            this.entries.put(this.computeKey(row2, column2), value);
        }
    }

    public void addToEntry(int row2, int column2, double increment) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        int key2 = this.computeKey(row2, column2);
        double value = this.entries.get(key2) + increment;
        if (value == 0.0) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    public void multiplyEntry(int row2, int column2, double factor) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        int key2 = this.computeKey(row2, column2);
        double value = this.entries.get(key2) * factor;
        if (value == 0.0) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    private int computeKey(int row2, int column2) {
        return row2 * this.columns + column2;
    }
}

