/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class LevyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130314L;
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double mu, double c2) {
        this(new Well19937c(), mu, c2);
    }

    public LevyDistribution(RandomGenerator rng, double mu, double c2) {
        super(rng);
        this.mu = mu;
        this.c = c2;
        this.halfC = 0.5 * c2;
    }

    public double density(double x2) {
        if (x2 < this.mu) {
            return Double.NaN;
        }
        double delta = x2 - this.mu;
        double f2 = this.halfC / delta;
        return FastMath.sqrt(f2 / Math.PI) * FastMath.exp(-f2) / delta;
    }

    public double logDensity(double x2) {
        if (x2 < this.mu) {
            return Double.NaN;
        }
        double delta = x2 - this.mu;
        double f2 = this.halfC / delta;
        return 0.5 * FastMath.log(f2 / Math.PI) - f2 - FastMath.log(delta);
    }

    public double cumulativeProbability(double x2) {
        if (x2 < this.mu) {
            return Double.NaN;
        }
        return Erf.erfc(FastMath.sqrt(this.halfC / (x2 - this.mu)));
    }

    public double inverseCumulativeProbability(double p2) throws OutOfRangeException {
        if (p2 < 0.0 || p2 > 1.0) {
            throw new OutOfRangeException(p2, (Number)0, 1);
        }
        double t2 = Erf.erfcInv(p2);
        return this.mu + this.halfC / (t2 * t2);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getNumericalMean() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalVariance() {
        return Double.POSITIVE_INFINITY;
    }

    public double getSupportLowerBound() {
        return this.mu;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

